/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.function.Consumer;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class JSONTools {
    public static void toJSON(ObjectNode jsonNode, String name, RigidBodyTransformReadOnly rigidBodyTransform) {
        ObjectNode transformObject = jsonNode.putObject(name);
        JSONTools.toJSON(transformObject, rigidBodyTransform);
    }

    public static void toEuclid(JsonNode jsonNode, String name, RigidBodyTransformBasics rigidBodyTransform) {
        ObjectNode transformObject = (ObjectNode)jsonNode.get(name);
        JSONTools.toEuclid((JsonNode)transformObject, rigidBodyTransform);
    }

    public static void toJSON(ObjectNode jsonNode, RigidBodyTransformReadOnly rigidBodyTransform) {
        jsonNode.put("x", (float)MathTools.roundToPrecision((double)rigidBodyTransform.getTranslation().getX(), (double)5.0E-4));
        jsonNode.put("y", (float)MathTools.roundToPrecision((double)rigidBodyTransform.getTranslation().getY(), (double)5.0E-4));
        jsonNode.put("z", (float)MathTools.roundToPrecision((double)rigidBodyTransform.getTranslation().getZ(), (double)5.0E-4));
        jsonNode.put("rollInDegrees", (float)MathTools.roundToPrecision((double)Math.toDegrees(rigidBodyTransform.getRotation().getRoll()), (double)0.02));
        jsonNode.put("pitchInDegrees", (float)MathTools.roundToPrecision((double)Math.toDegrees(rigidBodyTransform.getRotation().getPitch()), (double)0.02));
        jsonNode.put("yawInDegrees", (float)MathTools.roundToPrecision((double)Math.toDegrees(rigidBodyTransform.getRotation().getYaw()), (double)0.02));
    }

    public static void toEuclid(JsonNode jsonNode, RigidBodyTransformBasics rigidBodyTransform) {
        rigidBodyTransform.getTranslation().setX(jsonNode.get("x").asDouble());
        rigidBodyTransform.getTranslation().setY(jsonNode.get("y").asDouble());
        rigidBodyTransform.getTranslation().setZ(jsonNode.get("z").asDouble());
        rigidBodyTransform.getRotation().setYawPitchRoll(Math.toRadians(jsonNode.get("yawInDegrees").asDouble()), Math.toRadians(jsonNode.get("pitchInDegrees").asDouble()), Math.toRadians(jsonNode.get("rollInDegrees").asDouble()));
    }

    public static void toJSON(ObjectNode jsonNode, String name, Tuple3DReadOnly tuple3D) {
        ObjectNode transformObject = jsonNode.putObject(name);
        JSONTools.toJSON(transformObject, tuple3D);
    }

    public static void toEuclid(JsonNode jsonNode, String name, Tuple3DBasics tuple3D) {
        ObjectNode transformObject = (ObjectNode)jsonNode.get(name);
        JSONTools.toEuclid((JsonNode)transformObject, tuple3D);
    }

    public static void toJSON(ObjectNode jsonNode, Tuple3DReadOnly tuple3D) {
        jsonNode.put("x", (float)MathTools.roundToPrecision((double)tuple3D.getX(), (double)5.0E-4));
        jsonNode.put("y", (float)MathTools.roundToPrecision((double)tuple3D.getY(), (double)5.0E-4));
        jsonNode.put("z", (float)MathTools.roundToPrecision((double)tuple3D.getZ(), (double)5.0E-4));
    }

    public static void toEuclid(JsonNode jsonNode, Tuple3DBasics tuple3D) {
        tuple3D.setX(jsonNode.get("x").asDouble());
        tuple3D.setY(jsonNode.get("y").asDouble());
        tuple3D.setZ(jsonNode.get("z").asDouble());
    }

    public static void forEachArrayElement(JsonNode parentNode, String arrayName, Consumer<JsonNode> nodeConsumer) {
        Iterator actionNodeIterator = parentNode.withArray(arrayName).elements();
        while (actionNodeIterator.hasNext()) {
            nodeConsumer.accept((JsonNode)actionNodeIterator.next());
        }
    }
}

