/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import us.ihmc.log.LogTools;
import us.ihmc.tools.inputDevices.joystick.JoystickCompatibilityFilter;
import us.ihmc.tools.inputDevices.joystick.JoystickCustomizationFilter;
import us.ihmc.tools.inputDevices.joystick.JoystickEventListener;
import us.ihmc.tools.inputDevices.joystick.JoystickModel;
import us.ihmc.tools.inputDevices.joystick.JoystickStatusListener;

public class JoystickUpdater
implements Runnable {
    private static final boolean DEBUG = false;
    private final Controller joystickController;
    private final Object listnerConch = new Object();
    private final ArrayList<JoystickEventListener> listeners = new ArrayList();
    private final ArrayList<JoystickStatusListener> generalListenersList;
    private final Map<Component.Identifier, JoystickCompatibilityFilter> compatibilityFilterMap = new HashMap<Component.Identifier, JoystickCompatibilityFilter>();
    private final Map<Component.Identifier, JoystickCustomizationFilter> customizationFilterMap = new HashMap<Component.Identifier, JoystickCustomizationFilter>();
    private HashMap<String, Float> lastValues = new HashMap();
    private int pollIntervalMillis = 5;
    private boolean connected;
    private boolean threadRunning = false;

    public JoystickUpdater(Controller joystickController, JoystickModel model, ArrayList<JoystickStatusListener> generalListenersList) {
        this.joystickController = joystickController;
        this.generalListenersList = generalListenersList;
        for (JoystickCompatibilityFilter compatibilityFilter : model.getCompatibilityFilters()) {
            this.compatibilityFilterMap.put(compatibilityFilter.getIdentifier(), compatibilityFilter);
        }
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JoystickEventListener listener) {
        Object object = this.listnerConch;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        Object object = this.listnerConch;
        synchronized (object) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.threadRunning = true;
        while (this.threadRunning) {
            if (!this.joystickController.poll()) {
                this.connected = false;
                for (JoystickStatusListener listener : this.generalListenersList) {
                    listener.updateConnectivity(this.connected);
                }
                this.stopThread();
            }
            EventQueue queue = this.joystickController.getEventQueue();
            Event event = new Event();
            while (queue.getNextEvent(event)) {
                if (this.compatibilityFilterMap.containsKey(event.getComponent().getIdentifier())) {
                    event.set(event.getComponent(), (float)this.compatibilityFilterMap.get(event.getComponent().getIdentifier()).apply(event.getValue()), event.getNanos());
                }
                if (this.customizationFilterMap.containsKey(event.getComponent().getIdentifier())) {
                    event.set(event.getComponent(), (float)this.customizationFilterMap.get(event.getComponent().getIdentifier()).apply(event.getValue()), event.getNanos());
                }
                if (!this.isNewValue(event)) continue;
                Iterator<JoystickStatusListener> iterator = this.listnerConch;
                synchronized (iterator) {
                    try {
                        for (JoystickEventListener listener : this.listeners) {
                            listener.processEvent(event);
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        LogTools.error((Object)this, (Object)e.getMessage());
                    }
                }
                for (JoystickStatusListener listener : this.generalListenersList) {
                    listener.updateConnectivity(this.connected);
                }
            }
            try {
                Thread.sleep(this.pollIntervalMillis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopThread() {
        this.threadRunning = false;
    }

    private boolean isNewValue(Event event) {
        Float value = this.lastValues.get(event.getComponent().getName());
        if (value != null && event.getValue() == value.floatValue()) {
            this.lastValues.put(event.getComponent().getName(), value);
            return false;
        }
        this.lastValues.put(event.getComponent().getName(), Float.valueOf(event.getValue()));
        return true;
    }

    public void setPollIntervalMillis(int pollIntervalMillis) {
        this.pollIntervalMillis = pollIntervalMillis;
    }

    public void setCustomizationFilter(JoystickCustomizationFilter componentFilter) {
        this.customizationFilterMap.put(componentFilter.getIdentifier(), componentFilter);
    }
}

