/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;

public class ProcessStreamGobbler
extends Thread {
    private final Process process;
    private final PrintStream outputStream;
    private final InputStream inputStream;
    private final String processName;
    private final String processPrintingPrefix;
    private Timer currentTimer;
    private BufferedReader bufferedReader;
    private final Object monitor = new Object();
    private boolean shutdown = false;

    public ProcessStreamGobbler(String processName, Process process, InputStream inputStream, PrintStream outputStream) {
        this(processName, process, inputStream, outputStream, "[Process: " + processName + "] ");
    }

    public ProcessStreamGobbler(String processName, Process process, InputStream inputStream, PrintStream outputStream, String processPrintingPrefix) {
        super("ProcessStreamGobbler_" + processName);
        this.process = process;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.processName = processName;
        this.processPrintingPrefix = processPrintingPrefix;
        Runtime.getRuntime().addShutdownHook(new Thread(this::onJVMShutdown, "IHMC-ProcessStreamGobblerShutdown"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
            this.bufferedReader = new BufferedReader(inputStreamReader);
            while (!this.shutdown) {
                if (!this.process.isAlive()) {
                    LogTools.info((String)"{} is no longer alive. Shutting down...", (Object)this.processName);
                    this.startShutdown();
                    break;
                }
                if (!this.bufferedReader.ready()) {
                    this.startTimer();
                    Object object = this.monitor;
                    synchronized (object) {
                        this.monitor.wait();
                    }
                }
                while (this.bufferedReader.ready()) {
                    this.processStreams(this.bufferedReader);
                }
            }
            while (this.bufferedReader.ready()) {
                this.processStreams(this.bufferedReader);
            }
            this.bufferedReader.close();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void startTimer() {
        this.currentTimer = new Timer("ProcessStreamGobbler_" + this.processName + "Timer");
        this.currentTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        if (!ProcessStreamGobbler.this.process.isAlive()) {
                            LogTools.info((String)"{} is no longer alive. Shutting down...", (Object)ProcessStreamGobbler.this.processName);
                            ProcessStreamGobbler.this.startShutdown();
                        }
                        if (!ProcessStreamGobbler.this.bufferedReader.ready()) break block6;
                        Object object = ProcessStreamGobbler.this.monitor;
                        synchronized (object) {
                            ProcessStreamGobbler.this.monitor.notify();
                        }
                        ProcessStreamGobbler.this.currentTimer.cancel();
                        ProcessStreamGobbler.this.currentTimer.purge();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, 0L, 500L);
    }

    private void processStreams(BufferedReader bufferedReader) throws IOException {
        try {
            String line = bufferedReader.readLine();
            if (line != null) {
                this.outputStream.println((String)(this.processPrintingPrefix == null ? line : this.processPrintingPrefix + line));
                this.outputStream.flush();
            }
        }
        catch (IOException ioException) {
            if (ioException.getMessage().equals("Stream closed")) {
                LogTools.info((String)"{}: Input stream closed. Shutting down...", (Object)this.processName);
                this.startShutdown();
            }
            throw ioException;
        }
    }

    private void onJVMShutdown() {
        this.currentTimer.cancel();
        this.currentTimer.purge();
        this.interrupt();
        ExceptionTools.handle(() -> this.bufferedReader.close(), (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startShutdown() {
        this.shutdown = true;
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
            this.currentTimer.purge();
        }
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }
}

