/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.lists;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import us.ihmc.commons.lists.ListWrappingIndexTools;

public class CircularArrayList<E>
implements Iterable<E> {
    private ArrayList<E> list;

    public CircularArrayList() {
        this.list = new ArrayList();
    }

    public CircularArrayList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public void reindexTo(int spinAmount) {
        spinAmount %= this.list.size();
        int count = 0;
        int start = 0;
        while (count < this.list.size()) {
            int current = start;
            E prev = this.list.get(start);
            do {
                int next = (current + spinAmount) % this.list.size();
                E temp = this.list.get(next);
                this.list.set(next, prev);
                prev = temp;
                current = next;
                ++count;
            } while (start != current);
            ++start;
        }
    }

    public int wrapIndex(int index) {
        return ListWrappingIndexTools.wrap((int)index, this.list);
    }

    public int getNextIndex(int index) {
        return ListWrappingIndexTools.next((int)index, this.list);
    }

    public int getPreviousIndex(int index) {
        return ListWrappingIndexTools.previous((int)index, this.list);
    }

    public E get(int index) {
        return (E)ListWrappingIndexTools.getWrap((int)index, this.list);
    }

    public E getNext(int index) {
        return (E)ListWrappingIndexTools.getNext((int)index, this.list);
    }

    public E getPrevious(int index) {
        return (E)ListWrappingIndexTools.getPrevious((int)index, this.list);
    }

    public E set(int index, E element) {
        return (E)ListWrappingIndexTools.setWrap((int)index, element, this.list);
    }

    public boolean add(E e) {
        return this.list.add(e);
    }

    public int size() {
        return this.list.size();
    }

    public ArrayList<E> getList() {
        return this.list;
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    public void sort(Comparator<? super E> c) {
        this.list.sort(c);
    }
}

