/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick;

import net.java.games.input.Component;
import us.ihmc.tools.inputDevices.joystick.JoystickComponentFilter;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;

public class JoystickCompatibilityFilter
implements JoystickComponentFilter {
    private final JoystickMapping mapping;
    private final boolean invert;
    private final double restToZeroCorrection;
    private final double scaleCorrection;

    public JoystickCompatibilityFilter(JoystickMapping channel, boolean invert, double restToZeroCorrection, double scaleCorrection) {
        this.mapping = channel;
        this.invert = invert;
        this.restToZeroCorrection = restToZeroCorrection;
        this.scaleCorrection = scaleCorrection;
    }

    @Override
    public double apply(double value) {
        double corrected = value + this.restToZeroCorrection;
        double scaled = corrected * this.scaleCorrection;
        return this.invert ? -scaled : scaled;
    }

    @Override
    public Component.Identifier getIdentifier() {
        return this.mapping.getIdentifier();
    }
}

