/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.property;

import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class StoredPropertyKey<T> {
    private final String titleCasedName;
    private final String saveName;
    private final Class<T> type;
    private final int index;
    private final Object defaultValue;
    private String description = "";

    public StoredPropertyKey(Class<T> type, int index, String titleCasedName) {
        this(type, index, titleCasedName, null);
    }

    public StoredPropertyKey(Class<T> type, int index, String titleCasedName, Object defaultValue) {
        if (!ClassUtils.isPrimitiveOrWrapper(type)) {
            throw new RuntimeException("Type must be primitive!");
        }
        this.type = type;
        this.index = index;
        this.titleCasedName = titleCasedName;
        this.defaultValue = defaultValue;
        this.saveName = this.buildCamelCasedName();
    }

    public String getTitleCasedName() {
        return this.titleCasedName;
    }

    public int getIndex() {
        return this.index;
    }

    public Class<T> getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public String getCamelCasedName() {
        return this.saveName;
    }

    private String buildCamelCasedName() {
        String[] splitBySpaces = this.titleCasedName.split(" ");
        Object saveName = "";
        for (String splitBySpace : splitBySpaces) {
            saveName = (String)saveName + StringUtils.capitalize((String)splitBySpace);
        }
        saveName = StringUtils.uncapitalize((String)saveName);
        return saveName;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof StoredPropertyKey)) {
            return false;
        }
        StoredPropertyKey otherStoredPropertyKey = (StoredPropertyKey)other;
        return this.index == otherStoredPropertyKey.index;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasDescription() {
        return !this.description.isEmpty();
    }
}

