/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.WorkspaceDirectory;
import us.ihmc.tools.io.resources.ResourceTools;

public class WorkspaceJavaDirectory
extends WorkspaceDirectory {
    private final Path classpathPath;

    public WorkspaceJavaDirectory(Class<?> classForFindingSourceSetDirectory, String javaDirectoryName) {
        this.setFilesystemDirectoryToSourceSetDirectory(classForFindingSourceSetDirectory, javaDirectoryName);
        this.classpathPath = ResourceTools.getResourcesPathForClass(classForFindingSourceSetDirectory);
        this.initialize();
    }

    public WorkspaceJavaDirectory(Class<?> classForFindingSourceSetDirectory, String javaDirectoryName, String subsequentOrAbsoluteJavaPackagePath) {
        this.setFilesystemDirectoryToSourceSetDirectory(classForFindingSourceSetDirectory, javaDirectoryName);
        this.classpathPath = ResourceTools.getResourcesPathForClass(classForFindingSourceSetDirectory).resolve(subsequentOrAbsoluteJavaPackagePath);
        this.initialize();
    }

    private void initialize() {
        String subsequentPathToJavaDirectory = this.classpathPath.toString().substring(1);
        if (this.filesystemDirectory != null) {
            this.filesystemDirectory = this.filesystemDirectory.resolve(subsequentPathToJavaDirectory);
        }
    }

    public static void main(String[] args) {
        WorkspaceJavaDirectory workspaceDirectory = new WorkspaceJavaDirectory(WorkspaceJavaDirectory.class, "java");
        WorkspaceJavaDirectory.printTestInfo(workspaceDirectory);
        workspaceDirectory = new WorkspaceJavaDirectory(WorkspaceJavaDirectory.class, "java", "/stuff/moreStuff");
        WorkspaceJavaDirectory.printTestInfo(workspaceDirectory);
        workspaceDirectory = new WorkspaceJavaDirectory(WorkspaceJavaDirectory.class, "java", "stuff/moreStuff");
        WorkspaceJavaDirectory.printTestInfo(workspaceDirectory);
    }

    private static void printTestInfo(WorkspaceJavaDirectory workspaceDirectory) {
        LogTools.info((String)"File access available: {}", (Object)(workspaceDirectory.isFileAccessAvailable() ? "Yes" : "No"));
        if (workspaceDirectory.isFileAccessAvailable()) {
            Path directoryPath = workspaceDirectory.getFilesystemDirectory();
            LogTools.info((String)"Directory path: {}", (Object)directoryPath);
        }
    }
}

