/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick.mapping;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Event;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.tools.inputDevices.joystick.JoystickCompatibilityFilter;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;

public enum MadCatzFLY5StickMapping implements JoystickMapping
{
    TRIGGER,
    THROTTLE_LEFT,
    THROTTLE_RIGHT,
    THROTTLE_LOCK,
    HAT,
    THUMB_SCOLL_UP,
    THUMB_SCOLL_DOWN,
    STICK_ROLL,
    STICK_PITCH,
    STICK_YAW,
    BUTTON_2,
    BUTTON_3,
    BUTTON_4,
    BUTTON_5,
    BUTTON_6,
    BUTTON_7,
    BUTTON_8,
    BUTTON_9,
    BUTTON_10,
    BUTTON_11,
    BASE_MODE_BUTTON;

    public static final MadCatzFLY5StickMapping[] values;
    private static final BiMap<Component.Identifier, MadCatzFLY5StickMapping> windowsBiMap;
    private static final BiMap<Component.Identifier, MadCatzFLY5StickMapping> macBiMap;
    private static final BiMap<Component.Identifier, MadCatzFLY5StickMapping> linuxBiMap;

    private static void mapValues(MadCatzFLY5StickMapping mapping, Component.Identifier windowsIdentifier, Component.Identifier macIdentifier, Component.Identifier linuxIdentifier) {
        windowsBiMap.put((Object)windowsIdentifier, (Object)mapping);
        macBiMap.put((Object)macIdentifier, (Object)mapping);
        linuxBiMap.put((Object)linuxIdentifier, (Object)mapping);
    }

    public static List<JoystickCompatibilityFilter> getCompatibilityFilters() {
        ArrayList<JoystickCompatibilityFilter> compatibilityFilters = new ArrayList<JoystickCompatibilityFilter>();
        return compatibilityFilters;
    }

    @Override
    public Component.Identifier getIdentifier() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (Component.Identifier)windowsBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (Component.Identifier)macBiMap.inverse().get((Object)this);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (Component.Identifier)linuxBiMap.inverse().get((Object)this);
        }
        return null;
    }

    public static MadCatzFLY5StickMapping getMapping(Component.Identifier identifier) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return (MadCatzFLY5StickMapping)windowsBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_MAC) {
            return (MadCatzFLY5StickMapping)macBiMap.get((Object)identifier);
        }
        if (SystemUtils.IS_OS_LINUX) {
            return (MadCatzFLY5StickMapping)linuxBiMap.get((Object)identifier);
        }
        return null;
    }

    private static MadCatzFLY5StickMapping getMapping(Component component) {
        return MadCatzFLY5StickMapping.getMapping(component.getIdentifier());
    }

    public static MadCatzFLY5StickMapping getMapping(Event event) {
        return MadCatzFLY5StickMapping.getMapping(event.getComponent());
    }

    static {
        values = MadCatzFLY5StickMapping.values();
        windowsBiMap = HashBiMap.create((int)values.length);
        macBiMap = HashBiMap.create((int)values.length);
        linuxBiMap = HashBiMap.create((int)values.length);
        MadCatzFLY5StickMapping.mapValues(TRIGGER, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button._0, (Component.Identifier)Component.Identifier.Button.TRIGGER);
        MadCatzFLY5StickMapping.mapValues(THROTTLE_LEFT, (Component.Identifier)Component.Identifier.Axis.Z, (Component.Identifier)Component.Identifier.Axis.Z, (Component.Identifier)Component.Identifier.Axis.Z);
        MadCatzFLY5StickMapping.mapValues(THROTTLE_RIGHT, (Component.Identifier)Component.Identifier.Axis.SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER, (Component.Identifier)Component.Identifier.Axis.SLIDER);
        MadCatzFLY5StickMapping.mapValues(THROTTLE_LOCK, null, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button.THUMB);
        MadCatzFLY5StickMapping.mapValues(HAT, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Axis.POV, (Component.Identifier)Component.Identifier.Axis.POV);
        MadCatzFLY5StickMapping.mapValues(THUMB_SCOLL_UP, (Component.Identifier)Component.Identifier.Button._11, (Component.Identifier)Component.Identifier.Button._11, (Component.Identifier)Component.Identifier.Button.BASE6);
        MadCatzFLY5StickMapping.mapValues(THUMB_SCOLL_DOWN, (Component.Identifier)Component.Identifier.Button._12, (Component.Identifier)Component.Identifier.Button._12, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
        MadCatzFLY5StickMapping.mapValues(STICK_ROLL, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X, (Component.Identifier)Component.Identifier.Axis.X);
        MadCatzFLY5StickMapping.mapValues(STICK_PITCH, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y, (Component.Identifier)Component.Identifier.Axis.Y);
        MadCatzFLY5StickMapping.mapValues(STICK_YAW, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ, (Component.Identifier)Component.Identifier.Axis.RZ);
        MadCatzFLY5StickMapping.mapValues(BUTTON_2, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button._1, (Component.Identifier)Component.Identifier.Button.THUMB);
        MadCatzFLY5StickMapping.mapValues(BUTTON_3, (Component.Identifier)Component.Identifier.Button._2, (Component.Identifier)Component.Identifier.Button._2, (Component.Identifier)Component.Identifier.Button.THUMB2);
        MadCatzFLY5StickMapping.mapValues(BUTTON_4, (Component.Identifier)Component.Identifier.Button._3, (Component.Identifier)Component.Identifier.Button._3, (Component.Identifier)Component.Identifier.Button.TOP);
        MadCatzFLY5StickMapping.mapValues(BUTTON_5, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button._4, (Component.Identifier)Component.Identifier.Button.TOP2);
        MadCatzFLY5StickMapping.mapValues(BUTTON_6, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button._5, (Component.Identifier)Component.Identifier.Button.PINKIE);
        MadCatzFLY5StickMapping.mapValues(BUTTON_7, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button._6, (Component.Identifier)Component.Identifier.Button.BASE);
        MadCatzFLY5StickMapping.mapValues(BUTTON_8, (Component.Identifier)Component.Identifier.Button._7, (Component.Identifier)Component.Identifier.Button._7, (Component.Identifier)Component.Identifier.Button.BASE2);
        MadCatzFLY5StickMapping.mapValues(BUTTON_9, (Component.Identifier)Component.Identifier.Button._8, (Component.Identifier)Component.Identifier.Button._8, (Component.Identifier)Component.Identifier.Button.BASE3);
        MadCatzFLY5StickMapping.mapValues(BUTTON_10, (Component.Identifier)Component.Identifier.Button._9, (Component.Identifier)Component.Identifier.Button._9, (Component.Identifier)Component.Identifier.Button.BASE4);
        MadCatzFLY5StickMapping.mapValues(BUTTON_11, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button.BASE5);
        MadCatzFLY5StickMapping.mapValues(BASE_MODE_BUTTON, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button._10, (Component.Identifier)Component.Identifier.Button.UNKNOWN);
    }
}

