/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class FloatArrayCollector<From extends Number>
implements Collector<From, Buffer, float[]> {
    private FloatArrayCollector() {
    }

    @Override
    public Supplier<Buffer> supplier() {
        return () -> new Buffer();
    }

    @Override
    public BiConsumer<Buffer, From> accumulator() {
        return Buffer::add;
    }

    @Override
    public BinaryOperator<Buffer> combiner() {
        return Buffer::join;
    }

    @Override
    public Function<Buffer, float[]> finisher() {
        return Buffer::toArray;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    public static <T extends Number> Collector<T, ?, float[]> create() {
        return new FloatArrayCollector();
    }

    class Buffer {
        float[] curr = new float[64];
        int size;

        Buffer() {
        }

        void add(From d) {
            if (this.curr.length == this.size) {
                this.curr = Arrays.copyOf(this.curr, this.size * 2);
            }
            this.curr[this.size++] = ((Number)d).floatValue();
        }

        Buffer join(Buffer other) {
            Buffer res = new Buffer();
            res.curr = Arrays.copyOf(this.curr, this.size + other.size);
            System.arraycopy(other.curr, 0, res.curr, this.size, other.size);
            res.size = this.size + other.size;
            return res;
        }

        float[] toArray() {
            if (this.size != this.curr.length) {
                this.curr = Arrays.copyOf(this.curr, this.size);
            }
            return this.curr;
        }
    }
}

