/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.property;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.commons.text.WordUtils;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.JSONFileTools;
import us.ihmc.tools.io.WorkspaceDirectory;
import us.ihmc.tools.io.WorkspaceFile;
import us.ihmc.tools.property.BooleanStoredPropertyKey;
import us.ihmc.tools.property.DoubleStoredPropertyKey;
import us.ihmc.tools.property.IntegerStoredPropertyKey;
import us.ihmc.tools.property.StoredPropertyKey;
import us.ihmc.tools.property.StoredPropertySet;
import us.ihmc.tools.string.StringTools;

public class StoredPropertySetJavaGenerator {
    private final String jsonFileName;
    private final Class<?> basePropertySetClass;
    private String directoryNameToAssumePresent;
    private String subsequentPathToResourceFolder;
    private String subsequentPathToJavaFolder;
    private final WorkspaceDirectory javaDirectory;
    private final WorkspaceFile primaryJavaFile;
    private final WorkspaceFile basicsJavaFile;
    private final WorkspaceFile readOnlyJavaFile;
    private String storedPropertySetTitle;
    private final ArrayList<StoredPropertyFromFile> storedPropertiesFromFile = new ArrayList();

    public StoredPropertySetJavaGenerator(Class<?> basePropertySetClass, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String subsequentPathToJavaFolder) {
        this.basePropertySetClass = basePropertySetClass;
        this.directoryNameToAssumePresent = directoryNameToAssumePresent;
        this.subsequentPathToResourceFolder = subsequentPathToResourceFolder;
        this.subsequentPathToJavaFolder = subsequentPathToJavaFolder;
        this.javaDirectory = new WorkspaceDirectory(directoryNameToAssumePresent, subsequentPathToJavaFolder, basePropertySetClass);
        this.jsonFileName = basePropertySetClass.getSimpleName() + ".json";
        this.primaryJavaFile = new WorkspaceFile(this.javaDirectory, basePropertySetClass.getSimpleName() + ".java");
        this.basicsJavaFile = new WorkspaceFile(this.javaDirectory, basePropertySetClass.getSimpleName() + "Basics.java");
        this.readOnlyJavaFile = new WorkspaceFile(this.javaDirectory, basePropertySetClass.getSimpleName() + "ReadOnly.java");
    }

    public void loadFromJSON() {
        JSONFileTools.loadFromClasspath(this.basePropertySetClass, this.jsonFileName, node -> {
            if (node instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)node;
                objectNode.fieldNames().forEachRemaining(fieldName -> {
                    JsonNode propertyNode = objectNode.get(fieldName);
                    if (fieldName.equals("title")) {
                        this.storedPropertySetTitle = propertyNode.textValue();
                    } else {
                        String description = "";
                        if (propertyNode instanceof ArrayNode) {
                            ArrayNode arrayNode = (ArrayNode)propertyNode;
                            description = arrayNode.get(1).textValue();
                            if (arrayNode.get(0) instanceof BooleanNode) {
                                this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Boolean", "boolean", description));
                            } else if (arrayNode.get(0) instanceof DoubleNode) {
                                this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Double", "double", description));
                            } else if (arrayNode.get(0) instanceof IntNode) {
                                this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Integer", "int", description));
                            }
                        } else if (propertyNode instanceof ObjectNode) {
                            ObjectNode keyObjectNode = (ObjectNode)propertyNode;
                            JsonNode descriptionNode = keyObjectNode.get("description");
                            if (descriptionNode != null) {
                                description = descriptionNode.textValue();
                            }
                            JsonNode valueNode = keyObjectNode.get("value");
                            JsonNode typeNode = keyObjectNode.get("type");
                            boolean isBooleanProperty = valueNode instanceof BooleanNode;
                            isBooleanProperty |= typeNode != null && typeNode.textValue().equals("Boolean");
                            boolean isDoubleProperty = valueNode instanceof DoubleNode;
                            isDoubleProperty |= typeNode != null && typeNode.textValue().equals("Double");
                            boolean isIntegerProperty = valueNode instanceof IntNode;
                            isIntegerProperty |= typeNode != null && typeNode.textValue().equals("Integer");
                            if (isBooleanProperty) {
                                this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Boolean", "boolean", description));
                            } else if (isDoubleProperty) {
                                this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Double", "double", description));
                            } else if (isIntegerProperty) {
                                this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Integer", "int", description));
                            }
                        } else if (propertyNode instanceof BooleanNode) {
                            this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Boolean", "boolean", description));
                        } else if (propertyNode instanceof DoubleNode) {
                            this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Double", "double", description));
                        } else if (propertyNode instanceof IntNode) {
                            this.storedPropertiesFromFile.add(new StoredPropertyFromFile((String)fieldName, "Integer", "int", description));
                        }
                    }
                });
            }
        });
    }

    public void loadFromStoredPropertySet(StoredPropertySet storedPropertySet) {
        this.storedPropertySetTitle = storedPropertySet.getTitle();
        for (StoredPropertyKey<?> key : storedPropertySet.getKeyList().keys()) {
            if (key instanceof BooleanStoredPropertyKey) {
                this.storedPropertiesFromFile.add(new StoredPropertyFromFile(key.getTitleCasedName(), "Boolean", "boolean", key.getDescription()));
                continue;
            }
            if (key instanceof DoubleStoredPropertyKey) {
                this.storedPropertiesFromFile.add(new StoredPropertyFromFile(key.getTitleCasedName(), "Double", "double", key.getDescription()));
                continue;
            }
            if (!(key instanceof IntegerStoredPropertyKey)) continue;
            this.storedPropertiesFromFile.add(new StoredPropertyFromFile(key.getTitleCasedName(), "Integer", "int", key.getDescription()));
        }
    }

    public void generate() {
        String primaryJavaFileContents = "package %s;\n\nimport us.ihmc.tools.property.*;\n\n/**\n * The JSON file for this property set is located here:\n * %5$s/%7$s/%2$s.json\n *\n * This class was auto generated. Property attributes must be edited in the JSON file,\n * after which this class should be regenerated by running the main. This class uses\n * the generator to assist in the addition, removal, and modification of property keys.\n * It is permissible to forgo these benefits and abandon the generator, in which case\n * you should also move it from the generated-java folder to the java folder.\n *\n * If the constant paths have changed, change them in this file and run the main to regenerate.\n */\npublic class %2$s extends StoredPropertySet implements %2$sBasics\n{\n   public static final String DIRECTORY_NAME_TO_ASSUME_PRESENT = \"%4$s\";\n   public static final String SUBSEQUENT_PATH_TO_RESOURCE_FOLDER = \"%5$s\";\n   public static final String SUBSEQUENT_PATH_TO_JAVA_FOLDER = \"%6$s\";\n\n   public static final StoredPropertyKeyList keys = new StoredPropertyKeyList();\n\n%3$s\n   /**\n    * Loads this property set.\n    */\n   public %2$s()\n   {\n      this(\"\");\n   }\n\n   /**\n    * Loads an alternate version of this property set in the same folder.\n    */\n   public %2$s(String versionSpecifier)\n   {\n      this(%2$s.class, DIRECTORY_NAME_TO_ASSUME_PRESENT, SUBSEQUENT_PATH_TO_RESOURCE_FOLDER, versionSpecifier);\n   }\n\n   /**\n    * Loads an alternate version of this property set in other folders.\n    */\n   public %2$s(Class<?> classForLoading, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String versionSuffix)\n   {\n      super(keys, classForLoading, %2$s.class, directoryNameToAssumePresent, subsequentPathToResourceFolder, versionSuffix);\n      load();\n   }\n\n   public %2$s(StoredPropertySetReadOnly other)\n   {\n      super(keys, %2$s.class, DIRECTORY_NAME_TO_ASSUME_PRESENT, SUBSEQUENT_PATH_TO_RESOURCE_FOLDER, other.getCurrentVersionSuffix());\n      set(other);\n   }\n\n   public static void main(String[] args)\n   {\n      StoredPropertySet parameters = new StoredPropertySet(keys,\n                                                           %2$s.class,\n                                                           DIRECTORY_NAME_TO_ASSUME_PRESENT,\n                                                           SUBSEQUENT_PATH_TO_RESOURCE_FOLDER);\n      parameters.generateJavaFiles(SUBSEQUENT_PATH_TO_JAVA_FOLDER);\n   }\n}\n".formatted(this.basePropertySetClass.getPackage().getName(), this.basePropertySetClass.getSimpleName(), this.getParameterKeysStrings(), this.directoryNameToAssumePresent, this.subsequentPathToResourceFolder, this.subsequentPathToJavaFolder, this.basePropertySetClass.getPackage().getName().replaceAll("\\.", "/"));
        FileTools.write((Path)this.primaryJavaFile.getFilePath(), (byte[])primaryJavaFileContents.getBytes(), (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        LogTools.info((String)"Generated successfully: {}", (Object)this.primaryJavaFile.getFilePath());
        String basicsJavaFileContents = "package %s;\n\nimport us.ihmc.tools.property.StoredPropertySetBasics;\n\n/**\n * This class was auto generated. Do not edit by hand. Edit the cooresponding JSON file\n * and run the main in super to regenerate.\n */\npublic interface %2$sBasics extends %2$sReadOnly, StoredPropertySetBasics\n{\n%3$s}\n".formatted(this.basePropertySetClass.getPackage().getName(), this.basePropertySetClass.getSimpleName(), this.getParameterSetterStrings());
        FileTools.write((Path)this.basicsJavaFile.getFilePath(), (byte[])basicsJavaFileContents.getBytes(), (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        LogTools.info((String)"Generated successfully: {}", (Object)this.basicsJavaFile.getFilePath());
        String readOnlyJavaFileContents = "package %s;\n\nimport us.ihmc.tools.property.StoredPropertySetReadOnly;\n\nimport static %4$s.%2$s.*;\n\n/**\n * This class was auto generated. Do not edit by hand. Edit the cooresponding JSON file\n * and run the main in super to regenerate.\n */\npublic interface %2$sReadOnly extends StoredPropertySetReadOnly\n{\n%3$s}\n".formatted(this.basePropertySetClass.getPackage().getName(), this.basePropertySetClass.getSimpleName(), this.getParameterGetterStrings(), this.basePropertySetClass.getPackage().getName());
        FileTools.write((Path)this.readOnlyJavaFile.getFilePath(), (byte[])readOnlyJavaFileContents.getBytes(), (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        LogTools.info((String)"Generated successfully: {}", (Object)this.readOnlyJavaFile.getFilePath());
    }

    private String getParameterKeysStrings() {
        StringBuilder propertyKeyDeclarations = new StringBuilder();
        for (StoredPropertyFromFile storedPropertyFromFile : this.storedPropertiesFromFile) {
            propertyKeyDeclarations.append(this.getParameterJavadoc(storedPropertyFromFile.description()));
            propertyKeyDeclarations.append("public static final %2$sStoredPropertyKey %1$s = keys.add%2$sKey(\"%3$s\");\n".indent(3).formatted(StringTools.titleToCamelCase(storedPropertyFromFile.titleCasedName()), storedPropertyFromFile.typeName(), storedPropertyFromFile.titleCasedName()));
        }
        return propertyKeyDeclarations.toString();
    }

    private String getParameterSetterStrings() {
        StringBuilder propertyKeyDeclarations = new StringBuilder();
        for (int i = 0; i < this.storedPropertiesFromFile.size(); ++i) {
            StoredPropertyFromFile storedPropertyFromFile = this.storedPropertiesFromFile.get(i);
            propertyKeyDeclarations.append(this.getParameterJavadoc(storedPropertyFromFile.description()));
            propertyKeyDeclarations.append("default void set%1$s(%2$s %3$s)\n{\n   set(%4$s.%3$s, %3$s);\n}\n".indent(3).formatted(StringTools.titleToPascalCase(storedPropertyFromFile.titleCasedName()), storedPropertyFromFile.typePrimitiveName(), StringTools.titleToCamelCase(storedPropertyFromFile.titleCasedName()), this.basePropertySetClass.getSimpleName()));
            if (i >= this.storedPropertiesFromFile.size() - 1) continue;
            propertyKeyDeclarations.append("\n");
        }
        return propertyKeyDeclarations.toString();
    }

    private String getParameterGetterStrings() {
        StringBuilder propertyKeyDeclarations = new StringBuilder();
        for (int i = 0; i < this.storedPropertiesFromFile.size(); ++i) {
            StoredPropertyFromFile storedPropertyFromFile = this.storedPropertiesFromFile.get(i);
            propertyKeyDeclarations.append(this.getParameterJavadoc(storedPropertyFromFile.description()));
            propertyKeyDeclarations.append("default %2$s get%1$s()\n{\n   return get(%3$s);\n}\n".indent(3).formatted(StringTools.titleToPascalCase(storedPropertyFromFile.titleCasedName()), storedPropertyFromFile.typePrimitiveName(), StringTools.titleToCamelCase(storedPropertyFromFile.titleCasedName()), this.basePropertySetClass.getSimpleName()));
            if (i >= this.storedPropertiesFromFile.size() - 1) continue;
            propertyKeyDeclarations.append("\n");
        }
        return propertyKeyDeclarations.toString();
    }

    private String getParameterJavadoc(String description) {
        if (description.isEmpty()) {
            return "";
        }
        return "/**\n * %s\n */\n".indent(3).formatted(WordUtils.wrap((String)description, (int)80, (String)"\n    * ", (boolean)false));
    }

    private record StoredPropertyFromFile(String titleCasedName, String typeName, String typePrimitiveName, String description) {
    }
}

