/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import java.io.IOException;
import java.nio.file.Path;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.WorkspacePathTools;

public class DockerCommand {
    private ProcessBuilder processBuilder;
    private Process process;

    public DockerCommand(String projectName, String scriptPath) {
        Path script = WorkspacePathTools.handleWorkingDirectoryFuzziness(projectName).resolve(scriptPath).toAbsolutePath().normalize();
        LogTools.info((String)"Command: {}", (Object)script);
        this.processBuilder = new ProcessBuilder("/bin/bash", script.toString());
        this.processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        this.processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
    }

    public void start() {
        try {
            this.process = this.processBuilder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    public void waitFor() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void shutdown() {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
            LogTools.info((String)"Destroying process...");
            try {
                this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            LogTools.info((String)"Done.");
        }
    }
}

