/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.thread.CallableAfterExecuteHandler;
import us.ihmc.tools.thread.ExceptionHandlingThreadPoolExecutor;

public class ResettableExceptionHandlingExecutorService {
    public static final ExceptionHandler MESSAGE_AND_TRACE_WITH_THREAD_NAME = exception -> {
        if (exception != null) {
            LogTools.error((String)"Exception in thread: {}: {}", (Object)Thread.currentThread().getName(), (Object)exception.getMessage());
            exception.printStackTrace();
        }
    };
    private final Supplier<ExceptionHandlingThreadPoolExecutor> executorServiceSupplier;
    private ExceptionHandlingThreadPoolExecutor executorService;

    public ResettableExceptionHandlingExecutorService(Supplier<ExceptionHandlingThreadPoolExecutor> executorServiceSupplier) {
        this.executorServiceSupplier = executorServiceSupplier;
        this.executorService = executorServiceSupplier.get();
    }

    public void clearTaskQueue() {
        this.executorService.getQueue().clear();
    }

    public void execute(Runnable runnable) {
        this.execute(runnable, MESSAGE_AND_TRACE_WITH_THREAD_NAME);
    }

    public void execute(Runnable runnable, ExceptionHandler exceptionHandler) {
        this.executorService.execute(runnable, exceptionHandler);
    }

    public Future<Void> submit(Runnable runnable) {
        return this.submit(runnable, MESSAGE_AND_TRACE_WITH_THREAD_NAME);
    }

    public Future<Void> submit(Runnable runnable, ExceptionHandler exceptionHandler) {
        return this.executorService.submit(runnable, exceptionHandler);
    }

    public <V> Future<V> submit(Callable<V> callable, CallableAfterExecuteHandler<V> callableAfterExecuteHandler) {
        return this.executorService.submit(callable, callableAfterExecuteHandler);
    }

    public void clearQueueAndExecute(Runnable runnable) {
        this.clearTaskQueue();
        this.execute(runnable);
    }

    public boolean isExecuting() {
        return this.executorService.getActiveCount() > 0 || this.executorService.getQueue().size() > 0;
    }

    public void interruptAndReset() {
        this.executorService.interruptRunningAndCancelQueue();
        this.executorService = this.executorServiceSupplier.get();
    }

    public void destroy() {
        this.destroy(1500);
    }

    public void destroy(int maxMillisToWait) {
        this.executorService.shutdownNow();
        if (maxMillisToWait > 0) {
            ExceptionTools.handle(() -> this.executorService.awaitTermination(maxMillisToWait, TimeUnit.MILLISECONDS), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        }
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }
}

