/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ProjectDirectoryTools {
    private static final String buildFile = "build.gradle";
    private static final String sourceDirectory = "src";
    private static final String groupDirectory = "main";
    private static final String resourceDirectory = "resources";

    public static Path getProjectDirectory(Class<?> classInProject, String projectName) {
        URL myURL = classInProject.getResource(classInProject.getSimpleName() + ".class");
        try {
            URI myURI = myURL.toURI();
            String scheme = myURI.getScheme();
            if (scheme != null && scheme.equalsIgnoreCase("file")) {
                Path myPath;
                Path currentPath = myPath = Paths.get(myURI);
                while ((currentPath = currentPath.getParent()) != null) {
                    if (!ProjectDirectoryTools.isProjectDirectory(projectName, currentPath)) continue;
                    return currentPath;
                }
            }
        }
        catch (IllegalArgumentException | URISyntaxException myURI) {
            // empty catch block
        }
        Path workingDirectory = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        if (workingDirectory.getFileName() != null && projectName.equals(workingDirectory.getFileName().toString()) && ProjectDirectoryTools.isProjectDirectory(projectName, workingDirectory)) {
            return workingDirectory;
        }
        Path projectPath = Paths.get(projectName, new String[0]);
        if (ProjectDirectoryTools.isProjectDirectory(projectName, projectPath)) {
            return projectPath;
        }
        return null;
    }

    public static Path getMainResourceDirectory(Class<?> classInProject, String projectName) {
        Path resourceDirectoryPath;
        Path projectDirectory = ProjectDirectoryTools.getProjectDirectory(classInProject, projectName);
        if (projectDirectory != null && Files.exists(resourceDirectoryPath = projectDirectory.resolve(Paths.get(sourceDirectory, groupDirectory, resourceDirectory)), new LinkOption[0])) {
            return resourceDirectoryPath;
        }
        return null;
    }

    private static boolean isProjectDirectory(String projectName, Path currentPath) {
        String name;
        Path file = currentPath.getFileName();
        return file != null && projectName.equals(name = currentPath.getFileName().toString()) && Files.exists(currentPath.resolve(buildFile), new LinkOption[0]);
    }

    public static void main(String[] args) {
        System.out.println(ProjectDirectoryTools.getMainResourceDirectory(ProjectDirectoryTools.class, "ihmc-java-toolkit"));
    }
}

