/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import java.util.function.BiConsumer;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.tools.io.HybridResourceMode;
import us.ihmc.tools.io.WorkspaceDirectory;

public class HybridDirectory {
    private final WorkspaceDirectory workspaceDirectory;
    private final Path externalDirectory;
    private HybridResourceMode mode = HybridResourceMode.WORKSPACE;

    public HybridDirectory(Path externalDirectory, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, Class<?> classForResourceDirectory) {
        this(externalDirectory, directoryNameToAssumePresent, subsequentPathToResourceFolder, classForResourceDirectory, "");
    }

    public HybridDirectory(Path externalDirectory, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String absoluteResourceDirectory) {
        this(externalDirectory, directoryNameToAssumePresent, subsequentPathToResourceFolder, null, absoluteResourceDirectory);
    }

    public HybridDirectory(Path externalDirectory, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, Class<?> classForResourceDirectory, String subsequentOrAbsoluteResourcePackagePath) {
        this.workspaceDirectory = new WorkspaceDirectory(directoryNameToAssumePresent, subsequentPathToResourceFolder, classForResourceDirectory, subsequentOrAbsoluteResourcePackagePath);
        String subsequentExternalPath = subsequentOrAbsoluteResourcePackagePath;
        if (subsequentExternalPath.startsWith("/")) {
            subsequentExternalPath = subsequentExternalPath.replaceFirst("/", "");
        }
        this.externalDirectory = externalDirectory.resolve(subsequentExternalPath).toAbsolutePath().normalize();
    }

    public void walkResourcesFlat(BiConsumer<String, BasicPathVisitor.PathType> pathVisitor) {
        this.workspaceDirectory.walkResourcesFlat(pathVisitor);
    }

    public boolean isWorkspaceFileAccessAvailable() {
        return this.workspaceDirectory.isFileAccessAvailable();
    }

    public void setMode(HybridResourceMode mode) {
        this.mode = mode;
    }

    public HybridResourceMode getMode() {
        return this.mode;
    }

    public Path getDirectoryForWriting() {
        return this.mode == HybridResourceMode.WORKSPACE ? this.workspaceDirectory.getDirectoryPath() : this.externalDirectory;
    }

    public Path getWorkspaceDirectory() {
        return this.workspaceDirectory.getDirectoryPath();
    }

    public Path getExternalDirectory() {
        return this.externalDirectory;
    }

    public Class<?> getClassForLoading() {
        return this.workspaceDirectory.getClassForLoading();
    }

    public String getPathNecessaryForClasspathLoading() {
        return this.workspaceDirectory.getPathNecessaryForClasspathLoading();
    }

    public String getPathNecessaryForResourceExploring() {
        return this.workspaceDirectory.getPathNecessaryForResourceExploring();
    }

    WorkspaceDirectory getInternalWorkspaceDirectory() {
        return this.workspaceDirectory;
    }
}

