/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import us.ihmc.tools.containers.ContainerTools;
import us.ihmc.tools.reflect.ReflectionTools;
import us.ihmc.tools.reflect.StringFieldMatcher;

public class RecursiveObjectComparer {
    private Object topLevelObject1;
    private Object topLevelObject2;
    private final int maxDepth;
    private final int maxSize;
    private final ArrayList<Field> differingFields = new ArrayList();
    private final ArrayList<Object[]> secondLowestLevelDifferenceList = new ArrayList();
    private final LinkedHashMap<Object, ArrayList<Object>> secondLowestLevelDifferenceMap = new LinkedHashMap();
    private final ArrayList<String> secondLowestLevelDifferenceLocations = new ArrayList();
    private final ArrayList<String[]> lowestLevelDifferencesList = new ArrayList();
    private LinkedHashMap<Object, ArrayList<Object>> previouslyProcessedDifferentObjectPairs = new LinkedHashMap();
    private LinkedHashMap<Object, ArrayList<Object>> previouslyProcessedEqualObjectPairs = new LinkedHashMap();
    private LinkedHashMap<Object, ArrayList<Object>> objectStack = new LinkedHashMap();
    private long primitivesProcessed = 0L;
    private long fieldsProcessed = 0L;
    private final StringBuffer differenceLocationBuffer = new StringBuffer();
    private LinkedHashMap<Object, ArrayList<Object>> objectPairsToIgnore = new LinkedHashMap();
    private LinkedHashSet<Field> fieldsToIgnore = new LinkedHashSet();
    private LinkedHashSet<Class<?>> classesToIgnore = new LinkedHashSet();
    private StringFieldMatcher stringFieldMatchersToIgnore = new StringFieldMatcher();
    private final boolean isTopLevel;

    public RecursiveObjectComparer(int maxDepth, int maxSize) {
        this.maxDepth = maxDepth;
        this.maxSize = maxSize;
        this.isTopLevel = true;
    }

    private RecursiveObjectComparer(RecursiveObjectComparer parentComparer, int maxDepth, int maxSize) {
        this.maxDepth = maxDepth;
        this.maxSize = maxSize;
        this.isTopLevel = false;
        this.classesToIgnore = parentComparer.classesToIgnore;
        this.fieldsToIgnore = parentComparer.fieldsToIgnore;
        this.stringFieldMatchersToIgnore = parentComparer.stringFieldMatchersToIgnore;
        this.previouslyProcessedEqualObjectPairs = parentComparer.previouslyProcessedEqualObjectPairs;
        this.previouslyProcessedDifferentObjectPairs = parentComparer.previouslyProcessedDifferentObjectPairs;
        this.objectStack = parentComparer.objectStack;
    }

    public boolean compare(Object object1, Object object2) throws IllegalArgumentException, IllegalAccessException {
        this.topLevelObject1 = object1;
        this.topLevelObject2 = object2;
        boolean objectsEqual = this.recursivelyCompareObjects(this.topLevelObject1, this.topLevelObject2, this.maxDepth, null);
        this.doPostCompareSanityChecks();
        return objectsEqual;
    }

    public void clear() {
        this.differingFields.clear();
        this.secondLowestLevelDifferenceList.clear();
        this.secondLowestLevelDifferenceMap.clear();
        this.secondLowestLevelDifferenceLocations.clear();
        this.lowestLevelDifferencesList.clear();
        this.previouslyProcessedDifferentObjectPairs.clear();
        this.previouslyProcessedEqualObjectPairs.clear();
        this.objectStack.clear();
        this.primitivesProcessed = 0L;
        this.fieldsProcessed = 0L;
        this.differenceLocationBuffer.setLength(0);
    }

    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    public long getPrimitivesProcessed() {
        return this.primitivesProcessed;
    }

    public long getFieldsProcessed() {
        return this.fieldsProcessed;
    }

    public ArrayList<Field> getDifferingFields() {
        return this.differingFields;
    }

    public ArrayList<Object[]> getLowestLevelObjectDifferenceList() {
        return this.secondLowestLevelDifferenceList;
    }

    public HashMap<Object, ArrayList<Object>> getLowestLevelObjectDifferenceMap() {
        return this.secondLowestLevelDifferenceMap;
    }

    public ArrayList<String> getLowestLevelObjectDifferenceLocations() {
        return this.secondLowestLevelDifferenceLocations;
    }

    public void addFieldToIgnore(Field fieldToIgnore) {
        this.fieldsToIgnore.add(fieldToIgnore);
    }

    public void addFieldsToIgnore(Collection<Field> fieldsToIgnore) {
        this.fieldsToIgnore.addAll(fieldsToIgnore);
    }

    public void addStringFieldsToIgnore(StringFieldMatcher stringFieldMatcherToIgnore) {
        if (stringFieldMatcherToIgnore != null) {
            this.stringFieldMatchersToIgnore.combine(stringFieldMatcherToIgnore);
        }
    }

    public void addClassToIgnore(Class<?> classToIgnore) {
        this.classesToIgnore.add(classToIgnore);
    }

    public void addClassesToIgnore(Collection<? extends Class<?>> classesToIgnore) {
        this.classesToIgnore.addAll(classesToIgnore);
    }

    public void addObjectPairsToIgnore(Map<Object, ArrayList<Object>> additionalObjectPairsToIgnore) {
        for (Object key : additionalObjectPairsToIgnore.keySet()) {
            if (this.objectPairsToIgnore.containsKey(key)) {
                this.objectPairsToIgnore.get(key).addAll((Collection<Object>)additionalObjectPairsToIgnore.get(key));
                continue;
            }
            this.objectPairsToIgnore.put(key, new ArrayList(additionalObjectPairsToIgnore.get(key)));
        }
    }

    private void doPostCompareSanityChecks() {
        if (this.isTopLevel() && !this.objectStack.isEmpty()) {
            throw new RuntimeException("object stack should be empty. It contains\n: " + this.objectStack);
        }
        int size = this.differingFields.size();
        if (this.secondLowestLevelDifferenceList.size() != size) {
            throw new RuntimeException("Sizes don't match");
        }
        if (this.secondLowestLevelDifferenceLocations.size() != size) {
            throw new RuntimeException("Sizes don't match");
        }
        if (this.lowestLevelDifferencesList.size() != size) {
            throw new RuntimeException("Sizes don't match");
        }
    }

    private boolean recursivelyCompareObjects(Object object1, Object object2, int depthToGo, Field callingField) throws IllegalArgumentException, IllegalAccessException {
        boolean ret;
        if (this.hasMaximumNumberOfDifferencesBeenReached()) {
            ret = true;
        } else if (RecursiveObjectComparer.areObjectsIdenticalOrBothNull(object1, object2)) {
            ret = true;
        } else if (RecursiveObjectComparer.isExactlyOneObjectNull(object1, object2)) {
            this.storeExactlyOneNullDifference(object1, object2, callingField);
            ret = false;
        } else if (RecursiveObjectComparer.areObjectsOfDifferentClasses(object1, object2)) {
            this.storeDifferentClassesDifference(object1, object2, callingField);
            ret = false;
        } else {
            Class<?> objectType = object1.getClass();
            if (this.isClassAnException(objectType)) {
                ret = true;
            } else if (this.isObjectPairAnException(object1, object2)) {
                ret = true;
            } else if (this.alreadyKnowObjectsAreDifferent(object1, object2)) {
                ret = false;
            } else if (this.alreadyKnowObjectsAreEqual(object1, object2)) {
                ret = true;
            } else if (this.areObjectsAlreadyBeingCompared(object1, object2)) {
                ret = true;
            } else {
                this.addObjectPairToObjectStack(object1, object2);
                if (callingField == null) {
                    this.differenceLocationBuffer.append(objectType.getName());
                }
                if (objectType.isArray()) {
                    ret = this.handleArrays(object1, object2, depthToGo, callingField);
                    this.doBookKeeping(object1, object2, ret);
                } else if (Map.class.isAssignableFrom(objectType)) {
                    ret = this.handleMaps(object1, object2, depthToGo, callingField);
                    this.doBookKeeping(object1, object2, ret);
                } else {
                    ret = this.compareFields(object1, object2, depthToGo);
                }
            }
        }
        return ret;
    }

    private void doBookKeeping(Object object1, Object object2, boolean equal) {
        if (equal) {
            this.registerEqualObjects(object1, object2);
        } else {
            this.registerDifferentObjects(object1, object2);
        }
        this.removeFromObjectStack(object1, object2);
    }

    private boolean compareFields(Object object1, Object object2, int depthToGo) {
        if (depthToGo > 0) {
            try {
                boolean result = this.tryToCompareFields(object1, object2, depthToGo);
                return result;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                this.removeFromObjectStack(object1, object2);
                return false;
            }
        }
        this.removeFromObjectStack(object1, object2);
        return true;
    }

    private boolean tryToCompareFields(Object object1, Object object2, int depthToGo) throws IllegalAccessException {
        ArrayList<Field> allFields = ReflectionTools.getAllFields(object1.getClass());
        boolean equal = true;
        for (Field field : allFields) {
            if (this.fieldsToIgnore.contains(field) || this.stringFieldMatchersToIgnore != null && this.stringFieldMatchersToIgnore.matches(object1)) continue;
            int oldLocationBufferLength = this.differenceLocationBuffer.length();
            this.differenceLocationBuffer.append("." + this.getFieldString(field));
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            boolean isPrimitive = fieldType.isPrimitive();
            if (isPrimitive) {
                if (!ReflectionTools.isPrimitiveFieldContentTheSame(object1, object2, field)) {
                    this.storePrimitiveDifference(object1, object2, field);
                    equal = false;
                }
                ++this.primitivesProcessed;
            } else {
                Object fieldContent2;
                Object fieldContent1 = field.get(object1);
                boolean fieldEqual = this.recursivelyCompareObjects(fieldContent1, fieldContent2 = field.get(object2), depthToGo - 1, field);
                if (!fieldEqual) {
                    equal = false;
                }
            }
            this.differenceLocationBuffer.setLength(oldLocationBufferLength);
            ++this.fieldsProcessed;
        }
        this.doBookKeeping(object1, object2, equal);
        return equal;
    }

    private void addObjectPairToObjectStack(Object object1, Object object2) {
        ArrayList<Object> objectStackEntry = this.objectStack.get(object1);
        if (objectStackEntry == null) {
            objectStackEntry = new ArrayList();
            this.objectStack.put(object1, objectStackEntry);
        }
        objectStackEntry.add(object2);
    }

    private boolean areObjectsAlreadyBeingCompared(Object object1, Object object2) {
        ArrayList<Object> objectStackEntry = this.objectStack.get(object1);
        if (objectStackEntry == null) {
            return false;
        }
        boolean objectsAlreadyBeingCompared = objectStackEntry.contains(object2);
        return objectsAlreadyBeingCompared;
    }

    private boolean alreadyKnowObjectsAreEqual(Object object1, Object object2) {
        boolean alreadyKnowObjectsAreEqual = this.previouslyProcessedEqualObjectPairs.get(object1) != null && this.previouslyProcessedEqualObjectPairs.get(object1).contains(object2);
        return alreadyKnowObjectsAreEqual;
    }

    private boolean alreadyKnowObjectsAreDifferent(Object object1, Object object2) {
        boolean alreadyKnowObjectsAreDifferent = this.previouslyProcessedDifferentObjectPairs.get(object1) != null && this.previouslyProcessedDifferentObjectPairs.get(object1).contains(object2);
        return alreadyKnowObjectsAreDifferent;
    }

    private boolean isObjectPairAnException(Object object1, Object object2) {
        ArrayList<Object> exceptionEntry = this.objectPairsToIgnore.get(object1);
        return exceptionEntry != null && exceptionEntry.contains(object2);
    }

    private boolean isClassAnException(Class<?> objectType) {
        for (Class clazz : this.classesToIgnore) {
            if (!clazz.isAssignableFrom(objectType)) continue;
            return true;
        }
        return false;
    }

    private static boolean areObjectsOfDifferentClasses(Object object1, Object object2) {
        Class<?> object2Type;
        Class<?> object1Type = object1.getClass();
        return object1Type != (object2Type = object2.getClass());
    }

    private boolean hasMaximumNumberOfDifferencesBeenReached() {
        return this.differingFields.size() >= this.maxSize;
    }

    private static boolean areObjectsIdenticalOrBothNull(Object object1, Object object2) {
        return object1 == object2;
    }

    private static boolean isExactlyOneObjectNull(Object object1, Object object2) {
        boolean object2Null;
        boolean object1Null = object1 == null;
        boolean bl = object2Null = object2 == null;
        return object1Null && !object2Null || !object1Null && object2Null;
    }

    private void registerEqualObjects(Object object1, Object object2) {
        ArrayList<Object> entry = this.previouslyProcessedEqualObjectPairs.get(object1);
        if (entry == null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object2);
            this.previouslyProcessedEqualObjectPairs.put(object1, arrayList);
        } else {
            entry.add(object2);
        }
    }

    private void registerDifferentObjects(Object object1, Object object2) {
        ArrayList<Object> entry = this.previouslyProcessedDifferentObjectPairs.get(object1);
        if (entry == null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object2);
            this.previouslyProcessedDifferentObjectPairs.put(object1, arrayList);
        } else {
            entry.add(object2);
        }
    }

    private void removeFromObjectStack(Object object1, Object object2) {
        ArrayList<Object> objectStackEntry = this.objectStack.get(object1);
        if (objectStackEntry != null) {
            ContainerTools.removeByReference(objectStackEntry, object2);
            if (objectStackEntry.isEmpty()) {
                this.objectStack.remove(object1);
            }
        } else {
            throw new RuntimeException("Object not found!");
        }
    }

    private void storePrimitiveDifference(Object object1, Object object2, Field callingField) throws IllegalArgumentException, IllegalAccessException {
        this.log(object1, object2, callingField);
        String[] primitiveDifference = RecursiveObjectComparer.getPrimitiveDifference(object1, object2, callingField);
        this.lowestLevelDifferencesList.add(primitiveDifference);
    }

    private void storePrimitiveDifferenceForArrays(Object array1, Object array2, Field callingField, int arrayIndex) throws IllegalArgumentException, IllegalAccessException {
        this.log(array1, array2, callingField);
        String[] primitiveDifference = RecursiveObjectComparer.getPrimitiveDifferenceForArrays(array1, array2, arrayIndex);
        this.lowestLevelDifferencesList.add(primitiveDifference);
    }

    private void storeArrayLengthDifference(Object array1, Object array2, Field callingField) {
        this.log(array1, array2, callingField);
        String[] differenceString = this.getLengthDifferenceForArrays(array1, array2);
        this.lowestLevelDifferencesList.add(differenceString);
    }

    private void storeExactlyOneNullDifference(Object object1, Object object2, Field callingField) {
        this.log(object1, object2, callingField);
        String[] primitiveDifference = new String[]{object1 == null ? "null" : "not null", object2 == null ? "null" : "not null"};
        this.lowestLevelDifferencesList.add(primitiveDifference);
    }

    private void storeDifferentClassesDifference(Object object1, Object object2, Field callingField) {
        this.log(object1, object2, callingField);
        String[] primitiveDifference = new String[]{object1.getClass().toString(), object2.getClass().toString()};
        this.lowestLevelDifferencesList.add(primitiveDifference);
    }

    private void log(Object object1, Object object2, Field callingField) {
        this.differingFields.add(callingField);
        Object[] objectDifference = new Object[]{object1, object2};
        this.secondLowestLevelDifferenceList.add(objectDifference);
        this.secondLowestLevelDifferenceLocations.add(this.differenceLocationBuffer.toString());
        ArrayList<Object> lowestLevelObjectDifferenceMapEntry = this.secondLowestLevelDifferenceMap.get(object1);
        if (lowestLevelObjectDifferenceMapEntry == null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object2);
            this.secondLowestLevelDifferenceMap.put(object1, arrayList);
        } else {
            lowestLevelObjectDifferenceMapEntry.add(object2);
        }
    }

    private static String[] getPrimitiveDifference(Object object1, Object object2, Field callingField) throws IllegalAccessException {
        String[] primitiveDifference = new String[]{ReflectionTools.getStringRepresentationOfFieldContent(object1, callingField), ReflectionTools.getStringRepresentationOfFieldContent(object2, callingField)};
        return primitiveDifference;
    }

    private static String[] getPrimitiveDifferenceForArrays(Object array1, Object array2, int arrayIndex) {
        String[] primitiveDifference = new String[]{ReflectionTools.getStringRepresentationOfArrayEntry(array1, arrayIndex), ReflectionTools.getStringRepresentationOfArrayEntry(array2, arrayIndex)};
        return primitiveDifference;
    }

    private String[] getLengthDifferenceForArrays(Object array1, Object array2) {
        String[] differenceString = new String[]{"length = " + Array.getLength(array1), "length = " + Array.getLength(array2)};
        return differenceString;
    }

    private String getFieldString(Field field) {
        String fieldString = field.toString();
        int dotIndex = fieldString.lastIndexOf(".");
        return fieldString.substring(dotIndex + 1);
    }

    private boolean handleArrays(Object array1, Object array2, int depthToGo, Field callingField) throws IllegalArgumentException, IllegalAccessException {
        int arrayLength = Array.getLength(array1);
        if (arrayLength != Array.getLength(array2)) {
            this.storeArrayLengthDifference(array1, array2, callingField);
            return false;
        }
        boolean isPrimitiveArray = array1.getClass().getComponentType().isPrimitive();
        boolean equal = true;
        for (int i = 0; i < arrayLength; ++i) {
            boolean entryEqual;
            int oldLocationBufferLength = this.differenceLocationBuffer.length();
            this.differenceLocationBuffer.append("[" + i + "]");
            if (isPrimitiveArray) {
                entryEqual = ReflectionTools.isPrimitiveArrayEntryTheSame(array1, array2, i);
                if (!entryEqual) {
                    this.storePrimitiveDifferenceForArrays(array1, array2, callingField, i);
                }
            } else {
                entryEqual = this.recursivelyCompareObjects(Array.get(array1, i), Array.get(array2, i), depthToGo - 1, callingField);
            }
            if (!entryEqual) {
                equal = false;
            }
            this.differenceLocationBuffer.setLength(oldLocationBufferLength);
        }
        return equal;
    }

    private boolean handleMaps(Object map1, Object map2, int depthToGo, Field callingField) throws IllegalArgumentException, IllegalAccessException {
        Map map1Cast = (Map)map1;
        Map map2Cast = (Map)map2;
        if (map1Cast.size() != map2Cast.size()) {
            return false;
        }
        Object[] keySet1 = map1Cast.keySet().toArray();
        Object[] keySet2 = map2Cast.keySet().toArray();
        boolean equal = true;
        block0: for (int i = 0; i < keySet1.length; ++i) {
            Object key1 = keySet1[i];
            boolean keyFound = false;
            for (int j = 0; j < keySet2.length; ++j) {
                Object value2;
                Object key2 = keySet2[j];
                boolean keyEqual = this.compareKeys(key1, key2, Integer.MAX_VALUE);
                if (!keyEqual) continue;
                keyFound = true;
                Object value1 = map1Cast.get(key1);
                boolean valueEqual = this.recursivelyCompareObjects(value1, value2 = map2Cast.get(key2), depthToGo - 1, callingField);
                if (valueEqual) continue block0;
                equal = false;
                continue block0;
            }
            if (keyFound || !this.isTopLevel()) continue;
            equal = false;
        }
        return equal;
    }

    private boolean compareKeys(Object key1, Object key2, int depthToGo) throws IllegalArgumentException, IllegalAccessException {
        RecursiveObjectComparer keyComparer = new RecursiveObjectComparer(this, depthToGo - 1, Integer.MAX_VALUE);
        boolean equal = keyComparer.compare(key1, key2);
        return equal;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int maxDifferingFields = 5000;
        int nDifferingFields = this.differingFields.size();
        int fieldsToBePrinted = Math.min(nDifferingFields, maxDifferingFields);
        for (int i = 0; i < fieldsToBePrinted; ++i) {
            Field field = this.differingFields.get(i);
            String location = this.secondLowestLevelDifferenceLocations.get(i);
            buf.append("Field: " + field + "\n");
            buf.append("Location: " + location + "\n");
            String[] primitiveDifference = this.lowestLevelDifferencesList.get(i);
            Object[] secondLowestLevelDifference = this.secondLowestLevelDifferenceList.get(i);
            for (int j = 0; j < primitiveDifference.length; ++j) {
                buf.append("   Primitive " + j + ": " + primitiveDifference[j]);
                Object containingObject = secondLowestLevelDifference[j];
                buf.append("   Containing object " + j + ": " + containingObject);
                if (containingObject != null) {
                    buf.append("   Containing object class " + j + ": " + containingObject.getClass());
                }
                buf.append("\n");
            }
        }
        if (fieldsToBePrinted < nDifferingFields) {
            buf.append("Output truncated. First " + maxDifferingFields + " differing fields shown.\n");
        }
        buf.append("\n");
        buf.append("Differing field types:\n");
        LinkedHashSet<Field> differingFieldsSet = new LinkedHashSet<Field>(this.differingFields);
        for (Field field : differingFieldsSet) {
            if (field != null) {
                buf.append(field.toGenericString());
            } else {
                buf.append("null");
            }
            buf.append("\n");
        }
        buf.append("\n");
        buf.append("Total number of differing fields: " + nDifferingFields + "\n");
        return buf.toString();
    }
}

