/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ArrayTools {
    public static double[] parseDoubleArray(String stringSource) throws IOException {
        String line = stringSource;
        ArrayList<Double> retArray = new ArrayList<Double>();
        if (line == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(line.replace("{", "").replace("}", "").replace(" ", "").replace(";", ""), ",");
        while (tokenizer.hasMoreElements()) {
            retArray.add(new Double(Double.parseDouble((String)tokenizer.nextElement())));
        }
        double[] ret = new double[retArray.size()];
        for (int i = 0; i < retArray.size(); ++i) {
            ret[i] = (Double)retArray.get(i);
        }
        return ret;
    }

    public static double[] parseDoubleArray(BufferedReader bufferedReader) throws IOException {
        String line = bufferedReader.readLine();
        return ArrayTools.parseDoubleArray(line);
    }

    public static double[] parseDoubleArrayFromMATLAB(String stringSource) throws IOException {
        String line = stringSource;
        ArrayList<Double> retArray = new ArrayList<Double>();
        if (line == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(line.replace("[", "").replace("]", "").replace(" ", ""), ",");
        while (tokenizer.hasMoreElements()) {
            retArray.add(new Double(Double.parseDouble((String)tokenizer.nextElement())));
        }
        double[] ret = new double[retArray.size()];
        for (int i = 0; i < retArray.size(); ++i) {
            ret[i] = (Double)retArray.get(i);
        }
        return ret;
    }

    public static double[] parseDoubleArrayFromMATLAB(BufferedReader bufferedReader) throws IOException {
        String line = bufferedReader.readLine();
        return ArrayTools.parseDoubleArrayFromMATLAB(line);
    }

    public static double[] parseDoubleArray(DataInputStream dataInputStream) throws IOException {
        int numElements = dataInputStream.readInt();
        double[] ret = new double[numElements];
        for (int i = 0; i < numElements; ++i) {
            ret[i] = dataInputStream.readDouble();
        }
        return ret;
    }

    public static int[] parseIntegerArray(String stringSource) throws IOException {
        ArrayList<Integer> retArray = new ArrayList<Integer>();
        String line = stringSource;
        if (line == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(line.replace("{", "").replace("[", "").replace("}", "").replace("]", "").replace(" ", "").replace(System.getProperty("line.separator"), "").replace("\n", ""), ",");
        while (tokenizer.hasMoreElements()) {
            retArray.add(new Integer(Integer.parseInt((String)tokenizer.nextElement())));
        }
        int[] ret = new int[retArray.size()];
        for (int i = 0; i < retArray.size(); ++i) {
            ret[i] = (Integer)retArray.get(i);
        }
        return ret;
    }

    public static int[] parseIntegerArray(BufferedReader bufferedReader) throws IOException {
        String line = bufferedReader.readLine();
        return ArrayTools.parseIntegerArray(line);
    }

    public static int[] parseIntArray(DataInputStream dataInputStream) throws IOException {
        int numElements = dataInputStream.readInt();
        int[] ret = new int[numElements];
        for (int i = 0; i < numElements; ++i) {
            ret[i] = dataInputStream.readInt();
        }
        return ret;
    }

    public static boolean deltaEquals(double[] a, double[] b, double delta) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i] - b[i]) > delta)) continue;
            return false;
        }
        return true;
    }

    public static boolean deltaEquals(float[] a, float[] b, float delta) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i] - b[i]) > delta)) continue;
            return false;
        }
        return true;
    }

    public static <T> ArrayList<T> getRearrangedArrayListCopy(ArrayList<T> list, int newStartIndex) {
        int i;
        ArrayList<T> ret = new ArrayList<T>();
        int listLength = list.size();
        for (i = newStartIndex; i < listLength; ++i) {
            ret.add(list.get(i));
        }
        for (i = 0; i < newStartIndex; ++i) {
            ret.add(list.get(i));
        }
        return ret;
    }

    public static int getIndexOfMaximumAbsoluteChangeBetweenTicks(double[] values) {
        int length = values.length;
        double maxChange = 0.0;
        int indexOfMaxChange = -1;
        double previousValue = values[0];
        for (int i = 1; i < length; ++i) {
            double nextValue = values[i];
            double absoluteChange = Math.abs(nextValue - previousValue);
            if (absoluteChange > maxChange) {
                maxChange = absoluteChange;
                indexOfMaxChange = i;
            }
            previousValue = nextValue;
        }
        return indexOfMaxChange;
    }

    public static double getMaximumAbsoluteChangeBetweenTicks(double[] values) {
        int length = values.length;
        double maxChange = 0.0;
        double previousValue = values[0];
        for (int i = 1; i < length; ++i) {
            double nextValue = values[i];
            double absoluteChange = Math.abs(nextValue - previousValue);
            if (absoluteChange > maxChange) {
                maxChange = absoluteChange;
            }
            previousValue = nextValue;
        }
        return maxChange;
    }

    public static boolean isContinuous(double[] values, double maxAllowedChange) {
        double maxChange = ArrayTools.getMaximumAbsoluteChangeBetweenTicks(values);
        return maxChange < maxAllowedChange;
    }

    public static void reverse(Object[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            Object oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }

    public static void reverse(float[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            float oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }

    public static void reverse(double[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            double oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }

    public static void reverse(byte[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            byte oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }

    public static void reverse(short[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            short oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }

    public static void reverse(int[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            int oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }

    public static void reverse(long[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            long oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }

    public static void reverse(boolean[] array) {
        int i = 0;
        int mid = array.length >> 1;
        int j = array.length - 1;
        while (i < mid) {
            boolean oldCoefficient_i = array[i];
            array[i] = array[j];
            array[j] = oldCoefficient_i;
            ++i;
            --j;
        }
    }
}

