/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class ReflectionTools {
    private ReflectionTools() {
    }

    public static void printDeclaredFields(Class<?> cls) {
        Field[] fields;
        for (Field field : fields = cls.getDeclaredFields()) {
            System.out.println(field.getName());
        }
    }

    public static <T> void printDeclaredFieldContents(Class<? extends T> cls, T instance) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        for (Field field : fields = cls.getDeclaredFields()) {
            ReflectionTools.printFieldContents(instance, field);
        }
    }

    public static void printAllFieldContents(Object instance) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<Field> allFields = ReflectionTools.getAllFields(instance.getClass());
        for (Field field : allFields) {
            ReflectionTools.printFieldContents(instance, field);
        }
    }

    public static <T> ArrayList<Field> compareDeclaredPrimitives(Class<? extends T> cls, T instance1, T instance2) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<Field> differingFields = new ArrayList<Field>();
        AccessibleObject[] fields = cls.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            if (!((Field)field).getType().isPrimitive() || ReflectionTools.isPrimitiveFieldContentTheSame(instance1, instance2, (Field)field)) continue;
            differingFields.add((Field)field);
        }
        return differingFields;
    }

    public static <T> ArrayList<Field> compareAllPrimitives(T instance1, T instance2) throws IllegalArgumentException, IllegalAccessException {
        ArrayList<Field> allFields = ReflectionTools.getAllFields(instance1.getClass());
        ArrayList<Field> differingFields = new ArrayList<Field>();
        for (Field field : allFields) {
            field.setAccessible(true);
            if (!field.getType().isPrimitive() || ReflectionTools.isPrimitiveFieldContentTheSame(instance1, instance2, field)) continue;
            differingFields.add(field);
        }
        return differingFields;
    }

    public static <T> boolean isPrimitiveFieldContentTheSame(T instance1, T instance2, Field field) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = field.getType();
        if (type == Byte.TYPE) {
            return field.getByte(instance1) == field.getByte(instance2);
        }
        if (type == Short.TYPE) {
            return field.getShort(instance1) == field.getShort(instance2);
        }
        if (type == Integer.TYPE) {
            return field.getInt(instance1) == field.getInt(instance2);
        }
        if (type == Long.TYPE) {
            return field.getLong(instance1) == field.getLong(instance2);
        }
        if (type == Float.TYPE) {
            float float2;
            float float1 = field.getFloat(instance1);
            return float1 == (float2 = field.getFloat(instance2)) || Double.isNaN(float1) && Double.isNaN(float2);
        }
        if (type == Double.TYPE) {
            double double2;
            double double1 = field.getDouble(instance1);
            return double1 == (double2 = field.getDouble(instance2)) || Double.isNaN(double1) && Double.isNaN(double2);
        }
        if (type == Boolean.TYPE) {
            return field.getBoolean(instance1) == field.getBoolean(instance2);
        }
        if (type == Character.TYPE) {
            return field.getChar(instance1) == field.getChar(instance2);
        }
        throw new RuntimeException("Field content is not primitive");
    }

    public static <T> boolean isPrimitiveArrayEntryTheSame(T instance1, T instance2, int index) {
        Class<?> type = instance1.getClass().getComponentType();
        if (type == Byte.TYPE) {
            return Array.getByte(instance1, index) == Array.getByte(instance2, index);
        }
        if (type == Short.TYPE) {
            return Array.getShort(instance1, index) == Array.getShort(instance2, index);
        }
        if (type == Integer.TYPE) {
            return Array.getInt(instance1, index) == Array.getInt(instance2, index);
        }
        if (type == Long.TYPE) {
            return Array.getLong(instance1, index) == Array.getLong(instance2, index);
        }
        if (type == Float.TYPE) {
            float float2;
            float float1 = Array.getFloat(instance1, index);
            return float1 == (float2 = Array.getFloat(instance2, index)) || Double.isNaN(float1) && Double.isNaN(float2);
        }
        if (type == Double.TYPE) {
            double double2;
            double double1 = Array.getDouble(instance1, index);
            return double1 == (double2 = Array.getDouble(instance2, index)) || Double.isNaN(double1) && Double.isNaN(double2);
        }
        if (type == Boolean.TYPE) {
            return Array.getBoolean(instance1, index) == Array.getBoolean(instance2, index);
        }
        if (type == Character.TYPE) {
            return Array.getChar(instance1, index) == Array.getChar(instance2, index);
        }
        throw new RuntimeException("Array component type is not primitive");
    }

    public static boolean isBooleanFieldSet(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return field.getBoolean(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }

    public static boolean isBooleanFieldExists(Class<?> clazz, String fieldName) {
        try {
            clazz.getField(fieldName);
            return true;
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }

    public static String getStringRepresentationOfFieldContent(Object object, Field field) throws IllegalArgumentException, IllegalAccessException {
        String ret = field.get(object).toString();
        return ret;
    }

    public static String getStringRepresentationOfArrayEntry(Object array, int index) {
        return Array.get(array, index).toString();
    }

    public static ArrayList<Field> getAllFields(Class<?> cls) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        while (cls != null) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                allFields.add(field);
            }
            cls = cls.getSuperclass();
        }
        return allFields;
    }

    public static void printFieldContents(Object instance, Field field) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        Class<?> type = field.getType();
        System.out.println(type + " " + field.getName() + " = " + field.get(instance));
    }

    public static <T> List<T> getFieldContentsAssignableFromClass(Object object, Class<T> clazz) {
        ArrayList<Field> fields = ReflectionTools.getAllFields(object.getClass());
        ArrayList<T> fieldContentList = new ArrayList<T>();
        try {
            for (Field field : fields) {
                if (!clazz.isAssignableFrom(field.getType())) continue;
                boolean fieldAccessible = field.isAccessible();
                if (!fieldAccessible) {
                    field.setAccessible(true);
                }
                fieldContentList.add(clazz.cast(field.get(object)));
                field.setAccessible(fieldAccessible);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return fieldContentList;
    }
}

