/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.maps;

public class EnumDoubleMap<K extends Enum<K>> {
    private final double[] vals;

    public EnumDoubleMap(Class<K> keyType) {
        Enum[] enumConstants = (Enum[])keyType.getEnumConstants();
        this.vals = new double[enumConstants.length];
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = Double.NaN;
        }
    }

    public void put(K key, double value) {
        this.vals[((Enum)key).ordinal()] = value;
    }

    public void remove(K key) {
        this.vals[((Enum)key).ordinal()] = Double.NaN;
    }

    public double get(K key) {
        return this.vals[((Enum)key).ordinal()];
    }
}

