/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import us.ihmc.tools.io.HybridDirectory;

public class HybridFile {
    private final Supplier<InputStream> getResourceAsStream;
    private final Supplier<URL> getResource;
    private final Path externalFile;
    private final Path workspaceFile;

    public HybridFile(HybridDirectory directory, String subsequentPathToFile) {
        String pathForResourceLoading = Paths.get(directory.getPathNecessaryForClasspathLoading(), new String[0]).resolve(subsequentPathToFile).toString();
        if (directory.getClassForLoading() == null) {
            this.getResourceAsStream = () -> ClassLoader.getSystemResourceAsStream(pathForResourceLoading);
            this.getResource = () -> ClassLoader.getSystemResource(pathForResourceLoading);
        } else {
            this.getResourceAsStream = () -> directory.getClassForLoading().getResourceAsStream(pathForResourceLoading);
            this.getResource = () -> directory.getClassForLoading().getResource(pathForResourceLoading);
        }
        this.externalFile = directory.getExternalDirectory().resolve(subsequentPathToFile);
        this.workspaceFile = directory.getWorkspaceDirectory().resolve(subsequentPathToFile);
    }

    public InputStream getClasspathResourceAsStream() {
        return this.getResourceAsStream.get();
    }

    public URL getClasspathResource() {
        return this.getResource.get();
    }

    public Path getExternalFile() {
        return this.externalFile;
    }

    public Path getWorkspaceFile() {
        return this.workspaceFile;
    }
}

