/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ThreadFactory;
import javax.swing.JFrame;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.inputDevices.joystick.JoystickComponentNotFoundException;
import us.ihmc.tools.inputDevices.joystick.JoystickCustomizationFilter;
import us.ihmc.tools.inputDevices.joystick.JoystickEventListener;
import us.ihmc.tools.inputDevices.joystick.JoystickModel;
import us.ihmc.tools.inputDevices.joystick.JoystickStatusListener;
import us.ihmc.tools.inputDevices.joystick.JoystickUpdater;
import us.ihmc.tools.inputDevices.joystick.exceptions.JoystickNotFoundException;

public class Joystick {
    private static final ThreadFactory namedThreadFactory = ThreadTools.createNamedThreadFactory((String)Joystick.class.getSimpleName());
    private static ControllerEnvironment controllerEnvironment = null;
    private static final Supplier<ControllerEnvironment> controllerEnvironmentFactory = Joystick.createControllerEnvironmentFactory();
    private final ArrayList<JoystickStatusListener> statusListeners = new ArrayList();
    private final HashSet<Component.Identifier> identifiers = new HashSet();
    protected final Controller joystickController;
    private final JoystickUpdater joystickUpdater;
    private final JoystickModel model;

    private static Supplier<ControllerEnvironment> createControllerEnvironmentFactory() {
        Constructor<?> constructor;
        try {
            constructor = Class.forName("net.java.games.input.DefaultControllerEnvironment").getDeclaredConstructors()[0];
        }
        catch (ClassNotFoundException | SecurityException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        constructor.setAccessible(true);
        return () -> {
            try {
                return (ControllerEnvironment)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        };
    }

    public Joystick() throws JoystickNotFoundException {
        this.joystickController = Joystick.getFirstJoystickFoundOnSystem();
        if (Joystick.getControllers().length > 1) {
            LogTools.warn((String)"More than one joystick found!");
            this.printListOfConnectedJoysticks();
        }
        LogTools.info((String)("Using joystick: " + this.joystickController.getName()));
        this.model = JoystickModel.getModelFromName(this.joystickController.getName());
        this.initializeIdentifiers();
        this.joystickUpdater = new JoystickUpdater(this.joystickController, this.model, this.statusListeners);
        this.startThread();
    }

    public static void rescanControllers() {
        Joystick.destroyControllerEnvironment();
    }

    private static void destroyControllerEnvironment() {
        Thread.getAllStackTraces().keySet().stream().filter(thread -> thread.getClass().getPackage().getName().equals("net.java.games.input")).forEach(jinputThread -> jinputThread.interrupt());
        if (controllerEnvironment != null) {
            controllerEnvironment = null;
        }
    }

    private static Controller[] getControllers() {
        if (controllerEnvironment == null) {
            controllerEnvironment = (ControllerEnvironment)controllerEnvironmentFactory.get();
        }
        return controllerEnvironment.getControllers();
    }

    public Joystick(JoystickModel joystickModel, int indexFoundOnSystem) throws JoystickNotFoundException {
        this.joystickController = Joystick.getJoystickOfModelOnSystem(joystickModel, indexFoundOnSystem);
        LogTools.info((String)("Using joystick: " + this.joystickController.getName()));
        this.model = JoystickModel.getModelFromName(this.joystickController.getName());
        this.initializeIdentifiers();
        this.joystickUpdater = new JoystickUpdater(this.joystickController, this.model, this.statusListeners);
        this.startThread();
    }

    protected Joystick(Controller joystickController) throws IOException {
        this.joystickController = joystickController;
        LogTools.info((String)("Using joystick: " + joystickController.getName()));
        this.model = JoystickModel.getModelFromName(joystickController.getName());
        this.initializeIdentifiers();
        this.joystickUpdater = new JoystickUpdater(joystickController, this.model, this.statusListeners);
        this.startThread();
    }

    private void initializeIdentifiers() {
        for (Component component : this.joystickController.getComponents()) {
            this.identifiers.add(component.getIdentifier());
        }
    }

    private void startThread() {
        Thread updaterThread = namedThreadFactory.newThread(this.joystickUpdater);
        updaterThread.start();
    }

    public void shutdown() {
        LogTools.warn((String)("Joystick (" + this.joystickController.getName() + ") poll thread shutting down"));
        this.joystickUpdater.stopThread();
    }

    public void addJoystickEventListener(JoystickEventListener joystickEventListener) {
        this.joystickUpdater.addListener(joystickEventListener);
    }

    public void addJoystickStatusListener(JoystickStatusListener joystickStatusListener) {
        this.statusListeners.add(joystickStatusListener);
    }

    public void clearEventListeners() {
        this.joystickUpdater.clearListeners();
    }

    public Component findComponent(Component.Identifier identifier) throws JoystickComponentNotFoundException {
        if (this.hasComponent(identifier)) {
            return this.joystickController.getComponent(identifier);
        }
        throw new JoystickComponentNotFoundException(identifier);
    }

    public boolean hasComponent(Component.Identifier identifier) {
        return this.identifiers.contains(identifier);
    }

    public void setPollInterval(int pollIntervalMillis) {
        this.joystickUpdater.setPollIntervalMillis(pollIntervalMillis);
    }

    public void setStandalone() {
        if (SystemUtils.IS_OS_WINDOWS) {
            JFrame frame = new JFrame("Joystick Input Enable Window");
            frame.setSize(480, 320);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(3);
        }
    }

    public void setCustomizationFilter(JoystickCustomizationFilter componentFilter) {
        this.joystickUpdater.setCustomizationFilter(componentFilter);
    }

    public JoystickModel getModel() {
        return this.model;
    }

    private static Controller getFirstJoystickFoundOnSystem() throws JoystickNotFoundException {
        Controller[] controllers;
        for (Controller controller : controllers = Joystick.getControllers()) {
            if (!Joystick.isValidControllerType(controller)) continue;
            return controller;
        }
        throw new JoystickNotFoundException("No joysticks found on system!");
    }

    public void printListOfConnectedJoysticks() {
        Controller[] controllers;
        for (Controller controller : controllers = Joystick.getControllers()) {
            if (!Joystick.isValidControllerType(controller)) continue;
            LogTools.info((String)("Found: " + controller.getName()));
        }
    }

    public static boolean isJoystickComboFoundOnSystem(JoystickModel model1, JoystickModel model2) {
        Controller[] controllers = Joystick.getControllers();
        int occurancesOfModel1 = 0;
        int occurancesOfModel2 = 0;
        for (Controller controller : controllers) {
            if (!Joystick.isValidControllerType(controller)) continue;
            if (JoystickModel.getModelFromName(controller.getName()) == model1) {
                ++occurancesOfModel1;
            }
            if (JoystickModel.getModelFromName(controller.getName()) != model2) continue;
            ++occurancesOfModel2;
        }
        if (model1 == model2) {
            return occurancesOfModel1 >= 2;
        }
        return occurancesOfModel1 >= 1 && occurancesOfModel2 >= 1;
    }

    private static Controller getJoystickOfModelOnSystem(JoystickModel model, int nthToPick) throws JoystickNotFoundException {
        Controller[] controllers = Joystick.getControllers();
        int i = 0;
        for (Controller controller : controllers) {
            if (!Joystick.isValidControllerType(controller) || JoystickModel.getModelFromName(controller.getName()) != model) continue;
            if (i == nthToPick) {
                return controller;
            }
            ++i;
        }
        throw new JoystickNotFoundException("Can't find index " + nthToPick + " of model: " + (Object)((Object)model));
    }

    public static boolean isAJoystickConnectedToSystem() {
        try {
            Joystick.getFirstJoystickFoundOnSystem();
            return true;
        }
        catch (JoystickNotFoundException e) {
            return false;
        }
    }

    private static boolean isValidControllerType(Controller controller) {
        return controller.getType() == Controller.Type.STICK || controller.getType() == Controller.Type.GAMEPAD;
    }

    public static void main(String[] args) {
        try {
            new Joystick();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

