/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick;

import java.io.IOException;
import net.java.games.input.Component;
import net.java.games.input.Event;
import net.java.games.input.test.ControllerReadTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Assertions;
import us.ihmc.commons.RunnableThatThrows;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.inputDevices.joystick.Joystick;
import us.ihmc.tools.inputDevices.joystick.JoystickEventListener;
import us.ihmc.tools.inputDevices.joystick.JoystickModel;
import us.ihmc.tools.inputDevices.joystick.JoystickStatusListener;
import us.ihmc.tools.inputDevices.joystick.exceptions.JoystickNotFoundException;
import us.ihmc.tools.inputDevices.joystick.virtualJoystick.VirtualJoystick;

public class JoystickTest {
    boolean madCatz5Status = false;
    boolean madCatz1Status = false;

    @Test
    public void testCreateJoystick() {
        try {
            Joystick joystick = new Joystick();
            joystick.setPollInterval(100);
            joystick.addJoystickEventListener(new JoystickEventListener(){

                public void processEvent(Event event) {
                    System.out.println(event);
                }
            });
            joystick.addJoystickStatusListener(new JoystickStatusListener(){

                public void updateConnectivity(boolean connected) {
                    System.out.println(connected);
                }
            });
            joystick.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateVirtualJoystick() {
        final Object monitor = new Object();
        try {
            VirtualJoystick virtualJoystick = new VirtualJoystick("VirtualJoystick");
            virtualJoystick.setPollInterval(100);
            virtualJoystick.addJoystickEventListener(new JoystickEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processEvent(Event event) {
                    System.out.println("VirtualJoystick: " + String.valueOf(event));
                    Assert.assertEquals((String)"not X", (Object)Component.Identifier.Axis.X, (Object)event.getComponent().getIdentifier());
                    Assert.assertEquals((String)"not 1.0", (double)1.0, (double)event.getValue(), (double)1.0E-5);
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                }
            });
            virtualJoystick.queueEvent((Component.Identifier)Component.Identifier.Axis.X, 1.0);
            try {
                Object object = monitor;
                synchronized (object) {
                    monitor.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            virtualJoystick.shutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testFindNonExistentJoystick() {
        Assertions.assertExceptionThrown(JoystickNotFoundException.class, (RunnableThatThrows)new RunnableThatThrows(){

            public void run() throws Throwable {
                new Joystick(JoystickModel.SAITEK_X52, 2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled
    @Test
    public void testCreateTwoJoysticks() {
        final Object monitor1 = new Object();
        final Object monitor2 = new Object();
        try {
            Joystick madCatz5 = new Joystick(JoystickModel.MAD_CATZ_FLY5_STICK, 0);
            Joystick madCatz1 = new Joystick(JoystickModel.MAD_CATZ_V1_STICK, 0);
            madCatz5.addJoystickStatusListener(new JoystickStatusListener(){

                public void updateConnectivity(boolean connected) {
                    if (connected != JoystickTest.this.madCatz5Status) {
                        System.out.println("MadCatz5 connected: " + connected);
                        JoystickTest.this.madCatz5Status = connected;
                    }
                }
            });
            madCatz1.addJoystickStatusListener(new JoystickStatusListener(){

                public void updateConnectivity(boolean connected) {
                    if (connected != JoystickTest.this.madCatz1Status) {
                        System.out.println("MadCatz1 connected: " + connected);
                        JoystickTest.this.madCatz1Status = connected;
                    }
                }
            });
            madCatz5.addJoystickEventListener(new JoystickEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processEvent(Event event) {
                    if (JoystickTest.this.madCatz5Status) {
                        System.out.println("MadCatz5: " + event.toString());
                        Object object = monitor1;
                        synchronized (object) {
                            monitor1.notify();
                        }
                    }
                }
            });
            madCatz1.addJoystickEventListener(new JoystickEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void processEvent(Event event) {
                    if (JoystickTest.this.madCatz1Status) {
                        System.out.println("MadCatz1: " + event.toString());
                        Object object = monitor2;
                        synchronized (object) {
                            monitor2.notify();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Object e = monitor1;
            synchronized (e) {
                monitor1.wait();
            }
            e = monitor2;
            synchronized (e) {
                monitor2.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ControllerReadTest.main((String[])new String[0]);
    }
}

