/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.log.LogTools;
import us.ihmc.tools.Timer;
import us.ihmc.tools.TimerSnapshot;
import us.ihmc.tools.TimerSnapshotWithExpiration;
import us.ihmc.tools.thread.MissingThreadTools;

public class TimerTest {
    @Test
    public void testInitialState() {
        Timer timer = new Timer();
        double now = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        Assertions.assertTrue((boolean)Double.isNaN(timer.getElapsedTime()));
        Assertions.assertFalse((boolean)timer.isRunning(now));
        Assertions.assertFalse((boolean)timer.isExpired(now));
        Assertions.assertFalse((boolean)timer.hasBeenSet());
        TimerSnapshot snapshot = timer.createSnapshot();
        Assertions.assertTrue((boolean)Double.isNaN(snapshot.getTimePassedSinceReset()));
        Assertions.assertFalse((boolean)snapshot.isRunning(now));
        Assertions.assertFalse((boolean)snapshot.isExpired(now));
        Assertions.assertFalse((boolean)snapshot.hasBeenSet());
        TimerSnapshotWithExpiration snapshotWithExpiration = timer.createSnapshot(now + 1.0);
        Assertions.assertTrue((boolean)Double.isNaN(snapshotWithExpiration.getTimePassedSinceReset()));
        Assertions.assertFalse((boolean)snapshotWithExpiration.isRunning());
        Assertions.assertFalse((boolean)snapshotWithExpiration.isExpired());
        Assertions.assertFalse((boolean)snapshotWithExpiration.hasBeenSet());
    }

    @Test
    public void testTimer() {
        TimerTest.testTimer(0.001);
        TimerTest.testTimer(0.2);
        TimerTest.testTimer(4.2487234E-5);
        TimerTest.testTimer(1.0);
        TimerTest.testTimer(2.342);
    }

    private static void testTimer(double expirationTime) {
        Timer timer = new Timer();
        Assertions.assertFalse((boolean)timer.isRunning(expirationTime));
        Assertions.assertFalse((boolean)timer.isExpired(expirationTime));
        timer.reset();
        Assertions.assertTrue((boolean)timer.isRunning(expirationTime));
        Assertions.assertFalse((boolean)timer.isExpired(expirationTime));
        MissingThreadTools.sleepAtLeast((double)expirationTime);
        Assertions.assertFalse((boolean)timer.isRunning(expirationTime));
        Assertions.assertTrue((boolean)timer.isExpired(expirationTime));
    }

    @Test
    public void testTimerSleep() {
        TimerTest.testTimerSleep(2.31E-6);
        TimerTest.testTimerSleep(2.0E-4);
        TimerTest.testTimerSleep(0.12);
        TimerTest.testTimerSleep(0.3);
        TimerTest.testTimerSleep(1.0);
        TimerTest.testTimerSleep(1.78);
    }

    private static void testTimerSleep(double expirationTime) {
        Timer timer = new Timer();
        Assertions.assertFalse((boolean)timer.isRunning(expirationTime));
        Assertions.assertFalse((boolean)timer.isExpired(expirationTime));
        timer.reset();
        Assertions.assertTrue((boolean)timer.isRunning(expirationTime));
        Assertions.assertFalse((boolean)timer.isExpired(expirationTime));
        double before = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        timer.sleepUntilExpiration(expirationTime);
        double after = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        boolean isRunning = timer.isRunning(expirationTime);
        boolean isExpired = timer.isExpired(expirationTime);
        LogTools.info((String)"Slept for {} s", (Object)(after - before));
        Assertions.assertFalse((boolean)isRunning);
        Assertions.assertTrue((boolean)isExpired);
    }
}

