/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.tools.Timer;
import us.ihmc.tools.TimerSnapshot;
import us.ihmc.tools.TimerSnapshotWithExpiration;

public class TimerTest {
    @Test
    public void testInitialState() {
        Timer timer = new Timer();
        double now = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        Assertions.assertTrue((boolean)Double.isNaN(timer.getElapsedTime()));
        Assertions.assertFalse((boolean)timer.isRunning(now));
        Assertions.assertFalse((boolean)timer.isExpired(now));
        Assertions.assertFalse((boolean)timer.hasBeenSet());
        TimerSnapshot snapshot = timer.createSnapshot();
        Assertions.assertTrue((boolean)Double.isNaN(snapshot.getTimePassedSinceReset()));
        Assertions.assertFalse((boolean)snapshot.isRunning(now));
        Assertions.assertFalse((boolean)snapshot.isExpired(now));
        Assertions.assertFalse((boolean)snapshot.hasBeenSet());
        TimerSnapshotWithExpiration snapshotWithExpiration = timer.createSnapshot(now + 1.0);
        Assertions.assertTrue((boolean)Double.isNaN(snapshotWithExpiration.getTimePassedSinceReset()));
        Assertions.assertFalse((boolean)snapshotWithExpiration.isRunning());
        Assertions.assertFalse((boolean)snapshotWithExpiration.isExpired());
        Assertions.assertFalse((boolean)snapshotWithExpiration.hasBeenSet());
    }
}

