/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.robotics.TestTools;
import us.ihmc.tools.thread.RestartableThrottledThread;
import us.ihmc.tools.time.FrequencyCalculator;
import us.ihmc.tools.time.FrequencyStatisticPrinter;

public class RestartableThrottledThreadTest {
    private static final String name = "TestRestartableThrottledThread";
    private FrequencyStatisticPrinter frequencyStatisticPrinter;
    private FrequencyCalculator frequencyCalculator;

    @Test
    public void test5HzFrequency() {
        double hertz = 5.0;
        this.frequencyStatisticPrinter = new FrequencyStatisticPrinter();
        this.frequencyCalculator = new FrequencyCalculator();
        RestartableThrottledThread thread = new RestartableThrottledThread(name, hertz, () -> {
            this.frequencyStatisticPrinter.ping();
            this.frequencyCalculator.ping();
        });
        thread.start();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.frequencyStatisticPrinter.destroy();
        TestTools.assertEpsilonEquals((double)hertz, (double)this.frequencyCalculator.getFrequency(), (double)0.5, (String)"Frequency not correct");
    }

    @Test
    public void test10HzFrequency() {
        double hertz = 10.0;
        this.frequencyStatisticPrinter = new FrequencyStatisticPrinter();
        this.frequencyCalculator = new FrequencyCalculator();
        RestartableThrottledThread thread = new RestartableThrottledThread(name, hertz, () -> {
            this.frequencyStatisticPrinter.ping();
            this.frequencyCalculator.ping();
        });
        thread.start();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.frequencyStatisticPrinter.destroy();
        TestTools.assertEpsilonEquals((double)hertz, (double)this.frequencyCalculator.getFrequency(), (double)0.5, (String)"Frequency not correct");
        thread.stop();
    }

    @Test
    public void testStartStopStart() {
        double hertz = 10.0;
        RestartableThrottledThread thread = new RestartableThrottledThread(name, hertz, () -> {
            for (int i = 0; i < 25; ++i) {
                Thread.sleep(i);
            }
        });
        thread.start();
        Assertions.assertTrue((boolean)thread.isRunning());
        Assertions.assertTrue((boolean)thread.isAlive());
        thread.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertFalse((boolean)thread.isRunning());
        Assertions.assertFalse((boolean)thread.isAlive());
        thread.start();
        Assertions.assertTrue((boolean)thread.isRunning());
        Assertions.assertTrue((boolean)thread.isAlive());
        thread.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionHandling() {
        double hertz = 10.0;
        RestartableThrottledThread thread = new RestartableThrottledThread(name, hertz, DefaultExceptionHandler.RUNTIME_EXCEPTION, () -> {
            throw new NullPointerException("This is a test");
        });
        try {
            thread.start();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)true);
        }
        finally {
            Assertions.assertFalse((boolean)thread.isRunning());
            Assertions.assertFalse((boolean)thread.isAlive());
        }
    }
}

