/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.tools.thread.RestartableThread;

public class RestartableThreadTest {
    private static final String name = "TestRestartableThread";

    @Test
    public void testStartStop() {
        RestartableThread thread = new RestartableThread(name, () -> {
            System.out.println("Test Thread Running");
            Thread.sleep(500L);
        });
        thread.start();
        Assertions.assertTrue((boolean)thread.isRunning());
        Assertions.assertTrue((boolean)thread.isAlive());
        thread.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertFalse((boolean)thread.isRunning());
        Assertions.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testStartStopStart() {
        RestartableThread thread = new RestartableThread(name, () -> {
            System.out.println("Test Thread Running");
            Thread.sleep(500L);
        });
        thread.start();
        Assertions.assertTrue((boolean)thread.isRunning());
        Assertions.assertTrue((boolean)thread.isAlive());
        thread.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertFalse((boolean)thread.isRunning());
        Assertions.assertFalse((boolean)thread.isAlive());
        thread.start();
        Assertions.assertTrue((boolean)thread.isRunning());
        Assertions.assertTrue((boolean)thread.isAlive());
        thread.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertFalse((boolean)thread.isRunning());
        Assertions.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testDoubleStart() {
        RestartableThread thread = new RestartableThread(name, () -> {
            System.out.println("Test Thread Running");
            Thread.sleep(500L);
        });
        thread.start();
        Assertions.assertTrue((boolean)thread.isRunning());
        Assertions.assertTrue((boolean)thread.isAlive());
        thread.start();
        Assertions.assertTrue((boolean)thread.isRunning());
        Assertions.assertTrue((boolean)thread.isAlive());
        thread.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertFalse((boolean)thread.isRunning());
        Assertions.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testDoubleStop() {
        RestartableThread thread = new RestartableThread(name, () -> {
            System.out.println("Test Thread Running");
            Thread.sleep(500L);
        });
        thread.start();
        Assertions.assertTrue((boolean)thread.isRunning());
        Assertions.assertTrue((boolean)thread.isAlive());
        thread.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertFalse((boolean)thread.isRunning());
        Assertions.assertFalse((boolean)thread.isAlive());
        thread.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Assertions.assertFalse((boolean)thread.isRunning());
        Assertions.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testStopWithoutStart() {
        RestartableThread thread = new RestartableThread(name, () -> {
            System.out.println("Test Thread Running");
            Thread.sleep(500L);
        });
        thread.stop();
        Assertions.assertFalse((boolean)thread.isRunning());
        Assertions.assertFalse((boolean)thread.isAlive());
    }

    @Test
    public void testExceptionHandling() {
        RestartableThread thread = new RestartableThread(name, DefaultExceptionHandler.RUNTIME_EXCEPTION, () -> {
            throw new NullPointerException("This is a test");
        });
        try {
            thread.start();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)true);
        }
        finally {
            Assertions.assertFalse((boolean)thread.isRunning());
            Assertions.assertFalse((boolean)thread.isAlive());
        }
    }
}

