/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.search.strings.fuzzySearch.comparators;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.search.strings.fuzzySearch.CombinedFuzzySearchResult;
import us.ihmc.tools.search.strings.fuzzySearch.comparators.SortByResultTypeComparator;

public class SortByResultTypeComparatorTest {
    @Test
    public void testCompare() {
        Random random = new Random(1976L);
        SortByResultTypeComparator comparator = new SortByResultTypeComparator();
        CombinedFuzzySearchResult aardvark = new CombinedFuzzySearchResult("Aardvark", CombinedFuzzySearchResult.CombinedFuzzySearchResultType.EXACT_SUBSTRING, new String[0]);
        CombinedFuzzySearchResult burgundy = new CombinedFuzzySearchResult("Burgundy", CombinedFuzzySearchResult.CombinedFuzzySearchResultType.REGEX, new String[0]);
        CombinedFuzzySearchResult sebastopol = new CombinedFuzzySearchResult("Sebastopol", CombinedFuzzySearchResult.CombinedFuzzySearchResultType.FUZZY, new String[0]);
        block5: for (int i = 0; i < 10000; ++i) {
            CombinedFuzzySearchResult.CombinedFuzzySearchResultType randomResultType = SortByResultTypeComparatorTest.generateRandomResultType(random);
            CombinedFuzzySearchResult victorious = new CombinedFuzzySearchResult("Victorious", randomResultType, new String[0]);
            int exactSubstringCompare = comparator.compare(aardvark, victorious);
            int regexCompare = comparator.compare(burgundy, victorious);
            int fuzzyCompare = comparator.compare(sebastopol, victorious);
            switch (randomResultType) {
                case FUZZY: {
                    Assert.assertTrue((exactSubstringCompare < 0 ? 1 : 0) != 0);
                    Assert.assertTrue((regexCompare < 0 ? 1 : 0) != 0);
                    Assert.assertTrue((fuzzyCompare == 0 ? 1 : 0) != 0);
                    continue block5;
                }
                case REGEX: {
                    Assert.assertTrue((exactSubstringCompare < 0 ? 1 : 0) != 0);
                    Assert.assertTrue((regexCompare == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((fuzzyCompare > 0 ? 1 : 0) != 0);
                    continue block5;
                }
                case EXACT_SUBSTRING: {
                    Assert.assertTrue((exactSubstringCompare == 0 ? 1 : 0) != 0);
                    Assert.assertTrue((regexCompare > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((fuzzyCompare > 0 ? 1 : 0) != 0);
                }
            }
        }
    }

    private static CombinedFuzzySearchResult.CombinedFuzzySearchResultType generateRandomResultType(Random random) {
        int numberOfEnums = ((CombinedFuzzySearchResult.CombinedFuzzySearchResultType[])CombinedFuzzySearchResult.CombinedFuzzySearchResultType.class.getEnumConstants()).length;
        return ((CombinedFuzzySearchResult.CombinedFuzzySearchResultType[])CombinedFuzzySearchResult.CombinedFuzzySearchResultType.class.getEnumConstants())[random.nextInt(numberOfEnums)];
    }
}

