/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.reflect;

import java.lang.reflect.Field;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.tools.reflect.StringFieldMatcher;

public class StringFieldMatcherTest {
    @Test
    public void testStringFieldMatcher() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ObjectWithAName barry = new ObjectWithAName("Obama2012", "Prez", 1.5);
        ObjectWithAName mitt = new ObjectWithAName("Romney2012", "Gov", 1.5);
        StringFieldMatcher matcher = new StringFieldMatcher();
        Field fieldToMatch = ObjectWithAName.class.getDeclaredField("name");
        matcher.addStringFieldToMatchExactly(ObjectWithAName.class, fieldToMatch, "Obama2012");
        Assert.assertTrue((boolean)matcher.matches((Object)barry));
        Assert.assertFalse((boolean)matcher.matches((Object)mitt));
        matcher = new StringFieldMatcher();
        matcher.addStringFieldToMatchRegularExpression(ObjectWithAName.class, fieldToMatch, ".*2012");
        Assert.assertTrue((boolean)matcher.matches((Object)barry));
        Assert.assertTrue((boolean)matcher.matches((Object)mitt));
        matcher = new StringFieldMatcher();
        matcher.addStringFieldToMatchRegularExpression(ObjectWithAName.class, fieldToMatch, "Romney.*");
        Field occupationFieldToMatch = ObjectWithAName.class.getDeclaredField("occupation");
        matcher.addStringFieldToMatchRegularExpression(ObjectWithAName.class, occupationFieldToMatch, "Prez");
        Assert.assertTrue((boolean)matcher.matches((Object)barry));
        Assert.assertTrue((boolean)matcher.matches((Object)mitt));
    }

    @Test
    public void testCombine() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ObjectWithAName barry = new ObjectWithAName("Obama2012", "Prez", 1.5);
        ObjectWithAName mitt = new ObjectWithAName("Romney2012", "Gov", 2.5);
        StringFieldMatcher matcherOne = new StringFieldMatcher();
        Field fieldToMatch = ObjectWithAName.class.getDeclaredField("name");
        matcherOne.addStringFieldToMatchExactly(ObjectWithAName.class, fieldToMatch, "Obama2012");
        StringFieldMatcher matcherTwo = new StringFieldMatcher();
        matcherTwo.addStringFieldToMatchExactly(ObjectWithAName.class, fieldToMatch, "Romney2012");
        Assert.assertTrue((boolean)matcherOne.matches((Object)barry));
        Assert.assertTrue((boolean)matcherTwo.matches((Object)mitt));
        Assert.assertFalse((boolean)matcherOne.matches((Object)mitt));
        Assert.assertFalse((boolean)matcherTwo.matches((Object)barry));
        matcherOne.combine(matcherTwo);
        Assert.assertTrue((boolean)matcherOne.matches((Object)barry));
        Assert.assertTrue((boolean)matcherOne.matches((Object)mitt));
    }

    private class ObjectWithAName {
        private final String name;
        private final String occupation;
        private final double value;

        public ObjectWithAName(String name, String occupation, double value) {
            this.name = name;
            this.occupation = occupation;
            this.value = value;
        }

        public String toString() {
            return "name = " + this.name + ", occupation = " + this.occupation + ", value = " + this.value;
        }
    }
}

