/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.appearance;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Random;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceMaterial;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTexture;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTransparent;
import us.ihmc.graphicsDescription.color.MutableColor;

public class YoAppearance {
    public static AppearanceDefinition YoboticsTexture() {
        return YoAppearance.Texture("images/yobotics.jpg");
    }

    public static AppearanceDefinition Texture(String path) {
        return new YoAppearanceTexture(path);
    }

    public static AppearanceDefinition Texture(BufferedImage bufferedImage) {
        return new YoAppearanceTexture(bufferedImage);
    }

    public static AppearanceDefinition EarthTexture() {
        return YoAppearance.Texture("images/earth.jpg");
    }

    public static AppearanceDefinition StoneTexture() {
        return YoAppearance.Texture("images/stone.jpg");
    }

    public static AppearanceDefinition[] getStandardRoyGBivRainbow() {
        AppearanceDefinition[] rainbow = new AppearanceDefinition[]{YoAppearance.Red(), YoAppearance.OrangeRed(), YoAppearance.Yellow(), YoAppearance.Green(), YoAppearance.Blue(), YoAppearance.Indigo(), YoAppearance.Purple()};
        return rainbow;
    }

    public static AppearanceDefinition PlaneMaterial() {
        YoAppearanceMaterial mat = new YoAppearanceMaterial();
        mat.setSpecularColor(0.5f, 0.5f, 0.5f);
        mat.setDiffuseColor(0.2f, 0.4f, 0.5f);
        mat.setShininess(7.5f);
        mat.setAmbientColor(0.17f, 0.5f, 0.7f);
        return mat;
    }

    public static AppearanceDefinition AluminumMaterial() {
        YoAppearanceMaterial mat = new YoAppearanceMaterial();
        mat.setSpecularColor(0.5f, 0.5f, 0.5f);
        mat.setDiffuseColor(0.2f, 0.4f, 0.5f);
        mat.setShininess(7.5f);
        mat.setAmbientColor(0.17f, 0.5f, 0.7f);
        return mat;
    }

    public static AppearanceDefinition BlackMetalMaterial() {
        YoAppearanceMaterial mat = new YoAppearanceMaterial();
        mat.setSpecularColor(0.5f, 0.5f, 0.5f);
        mat.setDiffuseColor(0.2f, 0.4f, 0.5f);
        mat.setShininess(6.0f);
        mat.setAmbientColor(0.16f, 0.18f, 0.2f);
        return mat;
    }

    public static AppearanceDefinition FenceMaterial() {
        YoAppearanceMaterial mat = new YoAppearanceMaterial();
        mat.setSpecularColor(0.4f, 0.4f, 0.4f);
        mat.setDiffuseColor(0.95f, 0.95f, 0.95f);
        mat.setShininess(2.0f);
        mat.setAmbientColor(0.45f, 0.45f, 0.45f);
        return mat;
    }

    public static AppearanceDefinition RGBColor(double red, double green, double blue, double transparency) {
        return new YoAppearanceRGBColor(red, green, blue, transparency);
    }

    public static AppearanceDefinition RGBColor(double red, double green, double blue) {
        return new YoAppearanceRGBColor(red, green, blue, 0.0);
    }

    public static AppearanceDefinition RGBColor(float red, float green, float blue) {
        return new YoAppearanceRGBColor(red, green, blue, 0.0);
    }

    public static AppearanceDefinition RGBColorFrom8BitInts(int red, int green, int blue) {
        return YoAppearance.RGBColor((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0);
    }

    public static AppearanceDefinition RGBColorFromHex(int hex) {
        int red = hex >> 16 & 0xFF;
        int green = hex >> 8 & 0xFF;
        int blue = hex & 0xFF;
        return YoAppearance.RGBColorFrom8BitInts(red, green, blue);
    }

    public static AppearanceDefinition Color(Color color) {
        return YoAppearance.Color(new MutableColor(color));
    }

    public static AppearanceDefinition Color(MutableColor color) {
        return YoAppearance.RGBColor(color.getX(), color.getY(), color.getZ());
    }

    public static AppearanceDefinition AliceBlue() {
        return YoAppearance.RGBColorFromHex(0xF0F8FF);
    }

    public static AppearanceDefinition AntiqueWhite() {
        return YoAppearance.RGBColorFromHex(16444375);
    }

    public static AppearanceDefinition Aqua() {
        return YoAppearance.RGBColorFromHex(65535);
    }

    public static AppearanceDefinition Aquamarine() {
        return YoAppearance.RGBColorFromHex(8388564);
    }

    public static AppearanceDefinition Azure() {
        return YoAppearance.RGBColorFromHex(0xF0FFFF);
    }

    public static AppearanceDefinition Beige() {
        return YoAppearance.RGBColorFromHex(16119260);
    }

    public static AppearanceDefinition Bisque() {
        return YoAppearance.RGBColorFromHex(16770244);
    }

    public static AppearanceDefinition Black() {
        return YoAppearance.RGBColorFromHex(0);
    }

    public static AppearanceDefinition BlanchedAlmond() {
        return YoAppearance.RGBColorFromHex(16772045);
    }

    public static AppearanceDefinition Blue() {
        return YoAppearance.RGBColorFromHex(255);
    }

    public static AppearanceDefinition BlueViolet() {
        return YoAppearance.RGBColorFromHex(9055202);
    }

    public static AppearanceDefinition Brown() {
        return YoAppearance.RGBColorFromHex(0xA52A2A);
    }

    public static AppearanceDefinition BurlyWood() {
        return YoAppearance.RGBColorFromHex(14596231);
    }

    public static AppearanceDefinition CadetBlue() {
        return YoAppearance.RGBColorFromHex(6266528);
    }

    public static AppearanceDefinition Chartreuse() {
        return YoAppearance.RGBColorFromHex(0x7FFF00);
    }

    public static AppearanceDefinition Chocolate() {
        return YoAppearance.RGBColorFromHex(13789470);
    }

    public static AppearanceDefinition Coral() {
        return YoAppearance.RGBColorFromHex(16744272);
    }

    public static AppearanceDefinition CornflowerBlue() {
        return YoAppearance.RGBColorFromHex(6591981);
    }

    public static AppearanceDefinition Cornsilk() {
        return YoAppearance.RGBColorFromHex(16775388);
    }

    public static AppearanceDefinition Crimson() {
        return YoAppearance.RGBColorFromHex(14423100);
    }

    public static AppearanceDefinition Cyan() {
        return YoAppearance.RGBColorFromHex(65535);
    }

    public static AppearanceDefinition DarkBlue() {
        return YoAppearance.RGBColorFromHex(139);
    }

    public static AppearanceDefinition DarkCyan() {
        return YoAppearance.RGBColorFromHex(35723);
    }

    public static AppearanceDefinition DarkGoldenRod() {
        return YoAppearance.RGBColorFromHex(12092939);
    }

    public static AppearanceDefinition DarkGray() {
        return YoAppearance.RGBColorFromHex(0x424242);
    }

    public static AppearanceDefinition DarkGrey() {
        return YoAppearance.RGBColorFromHex(0x424242);
    }

    public static AppearanceDefinition DarkGreen() {
        return YoAppearance.RGBColorFromHex(25600);
    }

    public static AppearanceDefinition DarkKhaki() {
        return YoAppearance.RGBColorFromHex(12433259);
    }

    public static AppearanceDefinition DarkMagenta() {
        return YoAppearance.RGBColorFromHex(0x8B008B);
    }

    public static AppearanceDefinition DarkOliveGreen() {
        return YoAppearance.RGBColorFromHex(5597999);
    }

    public static AppearanceDefinition Darkorange() {
        return YoAppearance.RGBColorFromHex(16747520);
    }

    public static AppearanceDefinition DarkOrchid() {
        return YoAppearance.RGBColorFromHex(10040012);
    }

    public static AppearanceDefinition DarkRed() {
        return YoAppearance.RGBColorFromHex(0x8B0000);
    }

    public static AppearanceDefinition DarkSalmon() {
        return YoAppearance.RGBColorFromHex(15308410);
    }

    public static AppearanceDefinition DarkSeaGreen() {
        return YoAppearance.RGBColorFromHex(9419919);
    }

    public static AppearanceDefinition DarkSlateBlue() {
        return YoAppearance.RGBColorFromHex(4734347);
    }

    public static AppearanceDefinition DarkSlateGray() {
        return YoAppearance.RGBColorFromHex(0x2F4F4F);
    }

    public static AppearanceDefinition DarkSlateGrey() {
        return YoAppearance.RGBColorFromHex(0x2F4F4F);
    }

    public static AppearanceDefinition DarkTurquoise() {
        return YoAppearance.RGBColorFromHex(52945);
    }

    public static AppearanceDefinition DarkViolet() {
        return YoAppearance.RGBColorFromHex(9699539);
    }

    public static AppearanceDefinition DeepPink() {
        return YoAppearance.RGBColorFromHex(16716947);
    }

    public static AppearanceDefinition DeepSkyBlue() {
        return YoAppearance.RGBColorFromHex(49151);
    }

    public static AppearanceDefinition DimGray() {
        return YoAppearance.RGBColorFromHex(0x696969);
    }

    public static AppearanceDefinition DimGrey() {
        return YoAppearance.RGBColorFromHex(0x696969);
    }

    public static AppearanceDefinition DodgerBlue() {
        return YoAppearance.RGBColorFromHex(2003199);
    }

    public static AppearanceDefinition FireBrick() {
        return YoAppearance.RGBColorFromHex(0xB22222);
    }

    public static AppearanceDefinition FloralWhite() {
        return YoAppearance.RGBColorFromHex(0xFFFAF0);
    }

    public static AppearanceDefinition ForestGreen() {
        return YoAppearance.RGBColorFromHex(0x228B22);
    }

    public static AppearanceDefinition Fuchsia() {
        return YoAppearance.RGBColorFromHex(0xFF00FF);
    }

    public static AppearanceDefinition Gainsboro() {
        return YoAppearance.RGBColorFromHex(0xDCDCDC);
    }

    public static AppearanceDefinition GhostWhite() {
        return YoAppearance.RGBColorFromHex(0xF8F8FF);
    }

    public static AppearanceDefinition Gold() {
        return YoAppearance.RGBColorFromHex(16766720);
    }

    public static AppearanceDefinition GoldenRod() {
        return YoAppearance.RGBColorFromHex(14329120);
    }

    public static AppearanceDefinition Gray() {
        return YoAppearance.RGBColorFromHex(0x808080);
    }

    public static AppearanceDefinition Grey() {
        return YoAppearance.RGBColorFromHex(0x808080);
    }

    public static AppearanceDefinition Green() {
        return YoAppearance.RGBColorFromHex(32768);
    }

    public static AppearanceDefinition GreenYellow() {
        return YoAppearance.RGBColorFromHex(11403055);
    }

    public static AppearanceDefinition Glass(double transparency) {
        AppearanceDefinition glass = YoAppearance.SkyBlue();
        YoAppearance.makeTransparent(glass, transparency);
        return glass;
    }

    public static AppearanceDefinition Glass() {
        return YoAppearance.Glass(0.5);
    }

    public static AppearanceDefinition HoneyDew() {
        return YoAppearance.RGBColorFromHex(0xF0FFF0);
    }

    public static AppearanceDefinition HotPink() {
        return YoAppearance.RGBColorFromHex(16738740);
    }

    public static AppearanceDefinition IndianRed() {
        return YoAppearance.RGBColorFromHex(0xCD5C5C);
    }

    public static AppearanceDefinition Indigo() {
        return YoAppearance.RGBColorFromHex(4915330);
    }

    public static AppearanceDefinition Ivory() {
        return YoAppearance.RGBColorFromHex(0xFFFFF0);
    }

    public static AppearanceDefinition Khaki() {
        return YoAppearance.RGBColorFromHex(15787660);
    }

    public static AppearanceDefinition Lavender() {
        return YoAppearance.RGBColorFromHex(15132410);
    }

    public static AppearanceDefinition LavenderBlush() {
        return YoAppearance.RGBColorFromHex(0xFFF0F5);
    }

    public static AppearanceDefinition LawnGreen() {
        return YoAppearance.RGBColorFromHex(8190976);
    }

    public static AppearanceDefinition LemonChiffon() {
        return YoAppearance.RGBColorFromHex(16775885);
    }

    public static AppearanceDefinition LightBlue() {
        return YoAppearance.RGBColorFromHex(11393254);
    }

    public static AppearanceDefinition LightCoral() {
        return YoAppearance.RGBColorFromHex(0xF08080);
    }

    public static AppearanceDefinition LightCyan() {
        return YoAppearance.RGBColorFromHex(0xE0FFFF);
    }

    public static AppearanceDefinition LightGoldenRodYellow() {
        return YoAppearance.RGBColorFromHex(16448210);
    }

    public static AppearanceDefinition LightGray() {
        return YoAppearance.RGBColorFromHex(0xD3D3D3);
    }

    public static AppearanceDefinition LightGrey() {
        return YoAppearance.RGBColorFromHex(0xD3D3D3);
    }

    public static AppearanceDefinition LightGreen() {
        return YoAppearance.RGBColorFromHex(0x90EE90);
    }

    public static AppearanceDefinition LightPink() {
        return YoAppearance.RGBColorFromHex(16758465);
    }

    public static AppearanceDefinition LightSalmon() {
        return YoAppearance.RGBColorFromHex(16752762);
    }

    public static AppearanceDefinition LightSeaGreen() {
        return YoAppearance.RGBColorFromHex(2142890);
    }

    public static AppearanceDefinition LightSkyBlue() {
        return YoAppearance.RGBColorFromHex(8900346);
    }

    public static AppearanceDefinition LightSlateGray() {
        return YoAppearance.RGBColorFromHex(0x778899);
    }

    public static AppearanceDefinition LightSlateGrey() {
        return YoAppearance.RGBColorFromHex(0x778899);
    }

    public static AppearanceDefinition LightSteelBlue() {
        return YoAppearance.RGBColorFromHex(11584734);
    }

    public static AppearanceDefinition LightYellow() {
        return YoAppearance.RGBColorFromHex(0xFFFFE0);
    }

    public static AppearanceDefinition Lime() {
        return YoAppearance.RGBColorFromHex(65280);
    }

    public static AppearanceDefinition LimeGreen() {
        return YoAppearance.RGBColorFromHex(3329330);
    }

    public static AppearanceDefinition Linen() {
        return YoAppearance.RGBColorFromHex(16445670);
    }

    public static AppearanceDefinition Magenta() {
        return YoAppearance.RGBColorFromHex(0xFF00FF);
    }

    public static AppearanceDefinition Maroon() {
        return YoAppearance.RGBColorFromHex(0x800000);
    }

    public static AppearanceDefinition MediumAquaMarine() {
        return YoAppearance.RGBColorFromHex(6737322);
    }

    public static AppearanceDefinition MediumBlue() {
        return YoAppearance.RGBColorFromHex(205);
    }

    public static AppearanceDefinition MediumOrchid() {
        return YoAppearance.RGBColorFromHex(12211667);
    }

    public static AppearanceDefinition MediumPurple() {
        return YoAppearance.RGBColorFromHex(9662683);
    }

    public static AppearanceDefinition MediumSeaGreen() {
        return YoAppearance.RGBColorFromHex(3978097);
    }

    public static AppearanceDefinition MediumSlateBlue() {
        return YoAppearance.RGBColorFromHex(8087790);
    }

    public static AppearanceDefinition MediumSpringGreen() {
        return YoAppearance.RGBColorFromHex(64154);
    }

    public static AppearanceDefinition MediumTurquoise() {
        return YoAppearance.RGBColorFromHex(4772300);
    }

    public static AppearanceDefinition MediumVioletRed() {
        return YoAppearance.RGBColorFromHex(13047173);
    }

    public static AppearanceDefinition MidnightBlue() {
        return YoAppearance.RGBColorFromHex(1644912);
    }

    public static AppearanceDefinition MintCream() {
        return YoAppearance.RGBColorFromHex(0xF5FFFA);
    }

    public static AppearanceDefinition MistyRose() {
        return YoAppearance.RGBColorFromHex(16770273);
    }

    public static AppearanceDefinition Moccasin() {
        return YoAppearance.RGBColorFromHex(16770229);
    }

    public static AppearanceDefinition NavajoWhite() {
        return YoAppearance.RGBColorFromHex(16768685);
    }

    public static AppearanceDefinition Navy() {
        return YoAppearance.RGBColorFromHex(128);
    }

    public static AppearanceDefinition OldLace() {
        return YoAppearance.RGBColorFromHex(16643558);
    }

    public static AppearanceDefinition Olive() {
        return YoAppearance.RGBColorFromHex(0x808000);
    }

    public static AppearanceDefinition OliveDrab() {
        return YoAppearance.RGBColorFromHex(7048739);
    }

    public static AppearanceDefinition Orange() {
        return YoAppearance.RGBColorFromHex(16753920);
    }

    public static AppearanceDefinition OrangeRed() {
        return YoAppearance.RGBColorFromHex(16729344);
    }

    public static AppearanceDefinition Orchid() {
        return YoAppearance.RGBColorFromHex(14315734);
    }

    public static AppearanceDefinition PaleGoldenRod() {
        return YoAppearance.RGBColorFromHex(0xEEE8AA);
    }

    public static AppearanceDefinition PaleGreen() {
        return YoAppearance.RGBColorFromHex(10025880);
    }

    public static AppearanceDefinition PaleTurquoise() {
        return YoAppearance.RGBColorFromHex(0xAFEEEE);
    }

    public static AppearanceDefinition PaleVioletRed() {
        return YoAppearance.RGBColorFromHex(14381203);
    }

    public static AppearanceDefinition PapayaWhip() {
        return YoAppearance.RGBColorFromHex(16773077);
    }

    public static AppearanceDefinition PeachPuff() {
        return YoAppearance.RGBColorFromHex(16767673);
    }

    public static AppearanceDefinition Peru() {
        return YoAppearance.RGBColorFromHex(13468991);
    }

    public static AppearanceDefinition Pink() {
        return YoAppearance.RGBColorFromHex(16761035);
    }

    public static AppearanceDefinition Plum() {
        return YoAppearance.RGBColorFromHex(0xDDA0DD);
    }

    public static AppearanceDefinition PowderBlue() {
        return YoAppearance.RGBColorFromHex(11591910);
    }

    public static AppearanceDefinition Purple() {
        return YoAppearance.RGBColorFromHex(0x800080);
    }

    public static AppearanceDefinition Red() {
        return YoAppearance.RGBColorFromHex(0xFF0000);
    }

    public static AppearanceDefinition RosyBrown() {
        return YoAppearance.RGBColorFromHex(12357519);
    }

    public static AppearanceDefinition RoyalBlue() {
        return YoAppearance.RGBColorFromHex(4286945);
    }

    public static AppearanceDefinition SaddleBrown() {
        return YoAppearance.RGBColorFromHex(9127187);
    }

    public static AppearanceDefinition Salmon() {
        return YoAppearance.RGBColorFromHex(16416882);
    }

    public static AppearanceDefinition SandyBrown() {
        return YoAppearance.RGBColorFromHex(16032864);
    }

    public static AppearanceDefinition SeaGreen() {
        return YoAppearance.RGBColorFromHex(3050327);
    }

    public static AppearanceDefinition SeaShell() {
        return YoAppearance.RGBColorFromHex(0xFFF5EE);
    }

    public static AppearanceDefinition Sienna() {
        return YoAppearance.RGBColorFromHex(10506797);
    }

    public static AppearanceDefinition Silver() {
        return YoAppearance.RGBColorFromHex(0xC0C0C0);
    }

    public static AppearanceDefinition SkyBlue() {
        return YoAppearance.RGBColorFromHex(8900331);
    }

    public static AppearanceDefinition SlateBlue() {
        return YoAppearance.RGBColorFromHex(6970061);
    }

    public static AppearanceDefinition SlateGray() {
        return YoAppearance.RGBColorFromHex(7372944);
    }

    public static AppearanceDefinition SlateGrey() {
        return YoAppearance.RGBColorFromHex(7372944);
    }

    public static AppearanceDefinition Snow() {
        return YoAppearance.RGBColorFromHex(0xFFFAFA);
    }

    public static AppearanceDefinition SpringGreen() {
        return YoAppearance.RGBColorFromHex(65407);
    }

    public static AppearanceDefinition SteelBlue() {
        return YoAppearance.RGBColorFromHex(4620980);
    }

    public static AppearanceDefinition Tan() {
        return YoAppearance.RGBColorFromHex(13808780);
    }

    public static AppearanceDefinition Teal() {
        return YoAppearance.RGBColorFromHex(32896);
    }

    public static AppearanceDefinition Thistle() {
        return YoAppearance.RGBColorFromHex(14204888);
    }

    public static AppearanceDefinition Tomato() {
        return YoAppearance.RGBColorFromHex(16737095);
    }

    public static AppearanceDefinition Turquoise() {
        return YoAppearance.RGBColorFromHex(4251856);
    }

    public static AppearanceDefinition Violet() {
        return YoAppearance.RGBColorFromHex(0xEE82EE);
    }

    public static AppearanceDefinition Wheat() {
        return YoAppearance.RGBColorFromHex(16113331);
    }

    public static AppearanceDefinition White() {
        return YoAppearance.RGBColorFromHex(0xFFFFFF);
    }

    public static AppearanceDefinition WhiteSmoke() {
        return YoAppearance.RGBColorFromHex(0xF5F5F5);
    }

    public static AppearanceDefinition Yellow() {
        return YoAppearance.RGBColorFromHex(0xFFFF00);
    }

    public static AppearanceDefinition YellowGreen() {
        return YoAppearance.RGBColorFromHex(10145074);
    }

    public static AppearanceDefinition Transparent() {
        return new YoAppearanceTransparent();
    }

    public static void makeTransparent(AppearanceDefinition appearance, double f) {
        appearance.setTransparency(f);
    }

    public static AppearanceDefinition randomColor(Random random) {
        double red = random.nextDouble();
        double green = random.nextDouble();
        double blue = random.nextDouble();
        return YoAppearance.RGBColor(red, green, blue);
    }
}

