/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.awt.Color;
import java.util.ArrayList;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicPosition
extends YoGraphic
implements RemoteYoGraphic {
    protected final YoDouble x;
    protected final YoDouble y;
    protected final YoDouble z;
    private final double scale;
    private final GraphicType type;
    private final AppearanceDefinition appearance;
    private final ArrayList<Graphics3DInstruction> linkGraphicInstructions = new ArrayList();
    private Vector3D translationVector = new Vector3D();

    public YoGraphicPosition(String namePrefix, String nameSuffix, YoRegistry registry, double scale, AppearanceDefinition appearance) {
        this(namePrefix + nameSuffix, new YoFramePoint3D(namePrefix, nameSuffix, ReferenceFrame.getWorldFrame(), registry), scale, appearance);
    }

    public YoGraphicPosition(String namePrefix, String nameSuffix, YoRegistry registry, double scale, AppearanceDefinition appearance, GraphicType type) {
        this(namePrefix + nameSuffix, new YoFramePoint3D(namePrefix, nameSuffix, ReferenceFrame.getWorldFrame(), registry), scale, appearance, type);
    }

    public YoGraphicPosition(String name, YoDouble x, YoDouble y, YoDouble z, double scale, AppearanceDefinition appearance) {
        this(name, x, y, z, scale, appearance, GraphicType.BALL);
    }

    public YoGraphicPosition(String name, YoDouble x, YoDouble y, double scale, AppearanceDefinition appearance, GraphicType type) {
        this(name, x, y, null, scale, appearance, type);
    }

    public YoGraphicPosition(String name, YoDouble x, YoDouble y, YoDouble z, double scale, AppearanceDefinition appearance, GraphicType type) {
        super(name);
        this.x = x;
        this.y = y;
        this.z = z;
        this.scale = scale;
        this.type = type;
        this.appearance = appearance;
    }

    public YoGraphicPosition(String name, YoFramePoint3D framePoint, double scale, AppearanceDefinition appearance) {
        this(name, framePoint, scale, appearance, GraphicType.BALL);
    }

    public YoGraphicPosition(String name, YoFramePoint3D framePoint, double scale, AppearanceDefinition appearance, GraphicType type) {
        super(name);
        framePoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.x = framePoint.getYoX();
        this.y = framePoint.getYoY();
        this.z = framePoint.getYoZ();
        this.scale = scale;
        this.type = type;
        this.appearance = appearance;
    }

    public YoGraphicPosition(String name, YoFramePoint2D framePoint, double scale, AppearanceDefinition appearance) {
        this(name, framePoint, scale, appearance, GraphicType.BALL);
    }

    public YoGraphicPosition(String name, YoFramePoint2D framePoint, double scale, AppearanceDefinition appearance, GraphicType type) {
        super(name);
        framePoint.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.x = framePoint.getYoX();
        this.y = framePoint.getYoY();
        this.z = null;
        this.scale = scale;
        this.type = type;
        this.appearance = appearance;
    }

    public void setPositionToNaN() {
        this.setPosition(Double.NaN, Double.NaN, Double.NaN);
    }

    public void setPosition(FramePoint3DReadOnly position) {
        position.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.setPosition((Tuple3DReadOnly)position);
    }

    public void setPosition(Tuple3DReadOnly position) {
        this.setPosition(position.getX(), position.getY(), position.getZ());
    }

    public void getPosition(FramePoint3D positionToPack) {
        positionToPack.setToZero(ReferenceFrame.getWorldFrame());
        this.getPosition((Tuple3DBasics)positionToPack);
    }

    public void setPosition(double x, double y, double z) {
        this.x.set(x);
        this.y.set(y);
        if (this.z != null) {
            this.z.set(z);
        }
    }

    public void getPosition(Tuple3DBasics positionToPack) {
        positionToPack.setX(this.getX());
        positionToPack.setY(this.getY());
        if (this.z != null) {
            positionToPack.setZ(this.getZ());
        } else {
            positionToPack.setZ(0.0);
        }
    }

    public double getX() {
        return this.x.getDoubleValue();
    }

    public double getY() {
        return this.y.getDoubleValue();
    }

    public double getZ() {
        return this.z.getDoubleValue();
    }

    public void setAppearance(AppearanceDefinition appearance) {
        for (int i = 0; i < this.linkGraphicInstructions.size(); ++i) {
            this.linkGraphicInstructions.get(i).setAppearance(appearance);
        }
    }

    public GraphicType getType() {
        return this.type;
    }

    public double getScale() {
        return this.scale;
    }

    public Color getColor() {
        if (this.appearance instanceof YoAppearanceRGBColor) {
            YoAppearanceRGBColor yoAppearanceRGBColor = (YoAppearanceRGBColor)this.appearance;
            Color color = new Color(yoAppearanceRGBColor.getRed(), yoAppearanceRGBColor.getGreen(), yoAppearanceRGBColor.getBlue());
            return color;
        }
        throw new RuntimeException("No color defined");
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.setChangeable(true);
        switch (this.type) {
            case BALL: 
            case SOLID_BALL: 
            case BALL_WITH_CROSS: 
            case BALL_WITH_ROTATED_CROSS: {
                double radius = 1.0;
                this.linkGraphicInstructions.add(linkGraphics.addSphere(radius, this.appearance));
                break;
            }
            case ELLIPSOID: {
                this.linkGraphicInstructions.add(linkGraphics.addEllipsoid(0.5, 1.0, 0.2, this.appearance));
                break;
            }
            case CROSS: {
                double R = 1.0;
                double r = 0.16;
                this.linkGraphicInstructions.add(linkGraphics.addArcTorus(0.0, Math.PI * 2, R, r, this.appearance));
                linkGraphics.rotate(1.5707963267948966, Axis3D.X);
                linkGraphics.translate(0.0, 0.0, -R);
                this.linkGraphicInstructions.add(linkGraphics.addCylinder(2.0 * R, r, this.appearance));
                linkGraphics.identity();
                linkGraphics.rotate(1.5707963267948966, Axis3D.Y);
                linkGraphics.translate(0.0, 0.0, -R);
                this.linkGraphicInstructions.add(linkGraphics.addCylinder(2.0 * R, r, this.appearance));
                break;
            }
            case ROTATED_CROSS: {
                double R = 1.0;
                double r = 0.16;
                this.linkGraphicInstructions.add(linkGraphics.addArcTorus(0.0, Math.PI * 2, R, r, this.appearance));
                linkGraphics.rotate(0.7853981633974483, Axis3D.Z);
                linkGraphics.rotate(1.5707963267948966, Axis3D.X);
                linkGraphics.translate(0.0, 0.0, -R);
                this.linkGraphicInstructions.add(linkGraphics.addCylinder(2.0 * R, r, this.appearance));
                linkGraphics.identity();
                linkGraphics.rotate(0.7853981633974483, Axis3D.Z);
                linkGraphics.rotate(1.5707963267948966, Axis3D.Y);
                linkGraphics.translate(0.0, 0.0, -R);
                this.linkGraphicInstructions.add(linkGraphics.addCylinder(2.0 * R, r, this.appearance));
                break;
            }
            default: {
                throw new RuntimeException("Shouldn't get here. Seems you set an invalid YoGraphicPosition type! type = " + String.valueOf((Object)this.type));
            }
        }
        return linkGraphics;
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3D) {
        transform3D.setIdentity();
        if (Double.isNaN(this.x.getDoubleValue()) || Double.isNaN(this.y.getDoubleValue()) || this.z != null && Double.isNaN(this.z.getDoubleValue())) {
            this.translationVector.set(-1000.0, -1000.0, -1000.0);
            transform3D.setTranslation((Tuple3DReadOnly)this.translationVector);
        } else {
            if (this.z != null) {
                this.translationVector.set(this.x.getDoubleValue(), this.y.getDoubleValue(), this.z.getDoubleValue());
            } else {
                this.translationVector.set(this.x.getDoubleValue(), this.y.getDoubleValue(), 0.0);
            }
            double globalScale = 1.0;
            if (this.globalScaleProvider != null) {
                globalScale = this.globalScaleProvider.getValue();
            }
            transform3D.appendScale(this.scale * globalScale);
            transform3D.setTranslation((Tuple3DReadOnly)this.translationVector);
        }
    }

    @Override
    public YoArtifactPosition createArtifact() {
        return new YoArtifactPosition(this.getName(), this.x, this.y, this.type, this.getColor(), this.scale);
    }

    @Override
    protected boolean containsNaN() {
        if (this.x.isNaN()) {
            return true;
        }
        if (this.y.isNaN()) {
            return true;
        }
        return this.z != null && this.z.isNaN();
    }

    @Override
    public YoVariable[] getVariables() {
        if (this.z != null) {
            return new YoDouble[]{this.x, this.y, this.z};
        }
        return new YoDouble[]{this.x, this.y};
    }

    @Override
    public double[] getConstants() {
        return new double[]{this.scale, this.type.ordinal()};
    }

    @Override
    public AppearanceDefinition getAppearance() {
        return this.appearance;
    }

    public YoVariable getYoX() {
        return this.x;
    }

    public YoVariable getYoY() {
        return this.y;
    }

    public YoVariable getYoZ() {
        return this.z;
    }

    @Override
    public YoGraphicPosition duplicate(YoRegistry newRegistry) {
        YoDouble x = (YoDouble)newRegistry.findVariable(this.x.getFullNameString());
        YoDouble y = (YoDouble)newRegistry.findVariable(this.y.getFullNameString());
        YoDouble z = (YoDouble)newRegistry.findVariable(this.z.getFullNameString());
        return new YoGraphicPosition(this.getName(), x, y, z, this.scale, this.appearance, this.type);
    }

    public static enum GraphicType {
        BALL,
        SOLID_BALL,
        CROSS,
        BALL_WITH_CROSS,
        ROTATED_CROSS,
        BALL_WITH_ROTATED_CROSS,
        DIAMOND,
        DIAMOND_WITH_CROSS,
        SQUARE,
        SQUARE_WITH_CROSS,
        ELLIPSOID;

    }
}

