/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicCylinder
extends YoGraphic
implements RemoteYoGraphic {
    private final YoFramePoint3D base;
    private final YoFrameVector3D vector;
    private double lineThickness;
    private final AppearanceDefinition appearance;
    private Vector3D translationVector = new Vector3D();
    private Vector3D z_rot = new Vector3D();
    private Vector3D y_rot = new Vector3D();
    private Vector3D x_rot = new Vector3D();
    private RotationMatrix rotMatrix = new RotationMatrix();

    public YoGraphicCylinder(String name, YoFramePoint3D startPoint, YoFrameVector3D frameVector, AppearanceDefinition appearance) {
        this(name, startPoint, frameVector, appearance, -1.0);
    }

    public YoGraphicCylinder(String name, YoFramePoint3D startPoint, YoFrameVector3D frameVector, AppearanceDefinition appearance, double lineThickness) {
        this(name, startPoint.getYoX(), startPoint.getYoY(), startPoint.getYoZ(), frameVector.getYoX(), frameVector.getYoY(), frameVector.getYoZ(), appearance, lineThickness);
        if (!startPoint.getReferenceFrame().isWorldFrame() || !frameVector.getReferenceFrame().isWorldFrame()) {
            System.err.println("Warning: Should be in a World Frame to create a YoGraphicCylinder. startPoint = " + String.valueOf(startPoint) + ", frameVector = " + String.valueOf(frameVector));
        }
    }

    public YoGraphicCylinder(String name, YoDouble baseX, YoDouble baseY, YoDouble baseZ, YoDouble x, YoDouble y, YoDouble z, AppearanceDefinition appearance) {
        this(name, baseX, baseY, baseZ, x, y, z, appearance, -1.0);
    }

    public YoGraphicCylinder(String name, YoDouble baseX, YoDouble baseY, YoDouble baseZ, YoDouble x, YoDouble y, YoDouble z, AppearanceDefinition appearance, double lineThickness) {
        super(name);
        this.base = new YoFramePoint3D(baseX, baseY, baseZ, ReferenceFrame.getWorldFrame());
        this.vector = new YoFrameVector3D(x, y, z, ReferenceFrame.getWorldFrame());
        this.lineThickness = lineThickness;
        this.appearance = appearance;
    }

    public void getBasePosition(Point3DBasics point3D) {
        point3D.set((Tuple3DReadOnly)this.base);
    }

    public void getBasePosition(FramePoint3DBasics framePoint3D) {
        framePoint3D.setIncludingFrame((FrameTuple3DReadOnly)this.base);
    }

    public void getVector(Vector3DBasics vector3D) {
        vector3D.set((Tuple3DReadOnly)vector3D);
    }

    public void getVector(FrameVector3DBasics frameVector3D) {
        frameVector3D.setIncludingFrame((FrameTuple3DReadOnly)this.vector);
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3D) {
        transform3D.setIdentity();
        this.z_rot.set((Tuple3DReadOnly)this.vector);
        double length = this.z_rot.length();
        if (length < 1.0E-7) {
            this.z_rot.set(0.0, 0.0, 1.0);
        } else {
            this.z_rot.normalize();
        }
        if (Math.abs(this.z_rot.getX()) <= 0.99) {
            this.x_rot.set(1.0, 0.0, 0.0);
        } else {
            this.x_rot.set(0.0, 1.0, 0.0);
        }
        this.y_rot.cross((Tuple3DReadOnly)this.z_rot, (Tuple3DReadOnly)this.x_rot);
        this.y_rot.normalize();
        this.x_rot.cross((Tuple3DReadOnly)this.y_rot, (Tuple3DReadOnly)this.z_rot);
        this.x_rot.normalize();
        this.rotMatrix.setColumns((Tuple3DReadOnly)this.x_rot, (Tuple3DReadOnly)this.y_rot, (Tuple3DReadOnly)this.z_rot);
        this.translationVector.set((Tuple3DReadOnly)this.base);
        transform3D.setTranslation((Tuple3DReadOnly)this.translationVector);
        transform3D.setLinearTransform((RotationMatrixReadOnly)this.rotMatrix);
        transform3D.appendScale(this.lineThickness, this.lineThickness, length);
    }

    @Override
    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }

    @Override
    protected boolean containsNaN() {
        return this.base.containsNaN() || this.vector.containsNaN();
    }

    @Override
    public YoVariable[] getVariables() {
        return new YoDouble[]{this.base.getYoX(), this.base.getYoY(), this.base.getYoZ(), this.vector.getYoX(), this.vector.getYoY(), this.vector.getYoZ()};
    }

    @Override
    public double[] getConstants() {
        return new double[]{this.lineThickness};
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCylinder(1.0, 1.0, this.appearance);
        return linkGraphics;
    }

    @Override
    public YoGraphicCylinder duplicate(YoRegistry newRegistry) {
        return new YoGraphicCylinder(this.getName(), this.base.duplicate(newRegistry), this.vector.duplicate(newRegistry), this.appearance, this.lineThickness);
    }

    @Override
    public AppearanceDefinition getAppearance() {
        return this.appearance;
    }
}

