/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting.artifact;

import java.awt.BasicStroke;
import java.awt.Color;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;

public class PixelLineArtifact
extends Artifact {
    private final Point2D pointOne = new Point2D();
    private final Point2D pointTwo = new Point2D();
    private BasicStroke basicStroke;

    public PixelLineArtifact(String id, Point2DReadOnly pointOne, Point2DReadOnly pointTwo) {
        this(id, pointOne, pointTwo, Color.BLACK, 1.0f);
    }

    public PixelLineArtifact(String id, Point2DReadOnly pointOne, Point2DReadOnly pointTwo, Color color, float width) {
        super(id);
        this.pointOne.set((Tuple2DReadOnly)pointOne);
        this.pointTwo.set((Tuple2DReadOnly)pointTwo);
        this.basicStroke = new BasicStroke(width);
        this.setColor(color);
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        graphics.setColor(this.getColor());
        graphics.setStroke(this.basicStroke);
        graphics.drawLineSegment(this.pointOne.getX(), this.pointOne.getY(), this.pointTwo.getX(), this.pointTwo.getY());
    }

    @Override
    public void drawHistory(Graphics2DAdapter graphics) {
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
    }

    @Override
    public void takeHistorySnapshot() {
    }

    public void setPointOne(Point2DReadOnly pointOne) {
        this.pointOne.set((Tuple2DReadOnly)pointOne);
    }

    public void setPointTwo(Point2DReadOnly pointTwo) {
        this.pointTwo.set((Tuple2DReadOnly)pointTwo);
    }
}

