/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.appearance;

import java.awt.Color;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTransparency;
import us.ihmc.graphicsDescription.color.MutableColor;

public class YoAppearanceRGBColor
extends YoAppearanceTransparency {
    private final MutableColor color;
    private final Color awtColor;

    public YoAppearanceRGBColor(MutableColor color, double transparency) {
        this.color = new MutableColor(color);
        this.awtColor = new Color(this.color.getX(), this.color.getY(), this.color.getZ(), (float)(1.0 - transparency));
        this.setTransparency(transparency);
    }

    public YoAppearanceRGBColor(Color color, double transparency) {
        this.color = new MutableColor(color);
        this.awtColor = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)(1.0 - transparency));
        this.setTransparency(transparency);
    }

    public YoAppearanceRGBColor(float red, float green, float blue, double transparency) {
        this.color = new MutableColor(red, green, blue);
        this.awtColor = new Color(red, green, blue, (float)(1.0 - transparency));
        this.setTransparency(transparency);
    }

    public YoAppearanceRGBColor(double red, double green, double blue, double transparency) {
        this.color = new MutableColor((float)red, (float)green, (float)blue);
        this.awtColor = new Color((float)red, (float)green, (float)blue, (float)(1.0 - transparency));
        this.setTransparency(transparency);
    }

    public float getRed() {
        return this.color.getX();
    }

    public float getGreen() {
        return this.color.getY();
    }

    public float getBlue() {
        return this.color.getZ();
    }

    @Override
    public MutableColor getColor() {
        return this.color;
    }

    @Override
    public Color getAwtColor() {
        return this.awtColor;
    }

    public String toString() {
        return "YoAppearanceRGBColor{color=" + String.valueOf(this.color) + "}";
    }
}

