/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;

public class ModifiableMeshDataHolder {
    private final RecyclingArrayList<Point3D32> vertices = new RecyclingArrayList(Point3D32.class);
    private final RecyclingArrayList<TexCoord2f> texturePoints = new RecyclingArrayList(TexCoord2f.class);
    private final TIntArrayList triangleIndices = new TIntArrayList();
    private final RecyclingArrayList<Vector3D32> vertexNormals = new RecyclingArrayList(Vector3D32.class);

    public void clear() {
        this.vertices.clear();
        this.texturePoints.clear();
        this.triangleIndices.reset();
        this.vertexNormals.clear();
    }

    public MeshDataHolder createMeshDataHolder() {
        Point3D32[] vertexArray = (Point3D32[])this.vertices.toArray((Object[])new Point3D32[0]);
        TexCoord2f[] texturePointArray = (TexCoord2f[])this.texturePoints.toArray((Object[])new TexCoord2f[0]);
        int[] triangleIndexArray = this.triangleIndices.toArray();
        Vector3D32[] vertexNormalArray = (Vector3D32[])this.vertexNormals.toArray((Object[])new Vector3D32[0]);
        return new MeshDataHolder(vertexArray, texturePointArray, triangleIndexArray, vertexNormalArray);
    }

    /*
     * WARNING - void declaration
     */
    public void add(MeshDataHolder meshDataHolder, boolean updateTriangleIndices) {
        if (meshDataHolder == null) {
            return;
        }
        Point3D32[] otherVertices = meshDataHolder.getVertices();
        if (otherVertices == null || otherVertices.length < 3) {
            return;
        }
        int[] otherTriangleIndices = meshDataHolder.getTriangleIndices();
        if (otherTriangleIndices == null || otherTriangleIndices.length < 3) {
            return;
        }
        if (updateTriangleIndices) {
            void var8_13;
            int n = this.vertices.size();
            int[] nArray = otherTriangleIndices;
            int n2 = nArray.length;
            boolean bl = false;
            while (var8_13 < n2) {
                int triangleIndex = nArray[var8_13];
                this.triangleIndices.add(triangleIndex + n);
                ++var8_13;
            }
        } else {
            this.triangleIndices.add(otherTriangleIndices);
        }
        for (Point3D32 point3D32 : otherVertices) {
            ((Point3D32)this.vertices.add()).set(point3D32);
        }
        for (TexCoord2f texCoord2f : meshDataHolder.getTexturePoints()) {
            ((TexCoord2f)this.texturePoints.add()).set((Tuple2DReadOnly)texCoord2f);
        }
        for (Vector3D32 vector3D32 : meshDataHolder.getVertexNormals()) {
            ((Vector3D32)this.vertexNormals.add()).set(vector3D32);
        }
    }

    public void add(ModifiableMeshDataHolder other, boolean updateTriangleIndices) {
        int i;
        if (updateTriangleIndices) {
            int shift = this.vertices.size();
            for (int i2 = 0; i2 < other.triangleIndices.size(); ++i2) {
                this.triangleIndices.add(other.triangleIndices.get(i2) + shift);
            }
        } else {
            this.triangleIndices.addAll((TIntCollection)other.triangleIndices);
        }
        for (i = 0; i < other.vertices.size(); ++i) {
            ((Point3D32)this.vertices.add()).set((Point3D32)other.vertices.get(i));
        }
        for (i = 0; i < other.texturePoints.size(); ++i) {
            ((TexCoord2f)this.texturePoints.add()).set((Tuple2DReadOnly)other.texturePoints.get(i));
        }
        for (i = 0; i < other.vertexNormals.size(); ++i) {
            ((Vector3D32)this.vertexNormals.add()).set((Vector3D32)other.vertexNormals.get(i));
        }
    }
}

