/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public abstract class YoGraphic {
    private static final boolean USE_JESPERS_BUGGY_HACK_TO_TRY_TO_PUT_YOGRAPHICS_WITH_RESPECT_TO_ROBOT = false;
    private final String name;
    private boolean showGraphicObject = true;
    private final RigidBodyTransform rootTransform = new RigidBodyTransform();
    private final AffineTransform objectTransform;
    private final AffineTransform transform = new AffineTransform();
    protected DoubleProvider globalScaleProvider;

    protected abstract void computeRotationTranslation(AffineTransform var1);

    protected abstract boolean containsNaN();

    public abstract Graphics3DObject getLinkGraphics();

    public abstract Artifact createArtifact();

    public YoGraphic(String name) {
        this.name = name;
        this.objectTransform = new AffineTransform();
    }

    public void setGlobalScaleProvider(DoubleProvider globalScaleProvider) {
        this.globalScaleProvider = globalScaleProvider;
    }

    public void showGraphicObject() {
        this.showGraphicObject = true;
    }

    public void hideGraphicObject() {
        this.showGraphicObject = false;
    }

    public void setVisible(boolean visible) {
        this.showGraphicObject = visible;
    }

    public boolean isGraphicObjectShowing() {
        return this.showGraphicObject;
    }

    public String getName() {
        return this.name;
    }

    public void setRootTransform(RigidBodyTransformReadOnly transform) {
        this.rootTransform.set(transform);
    }

    public final AffineTransform getTransform() {
        if (this.showGraphicObject && !this.containsNaN()) {
            this.computeRotationTranslation(this.objectTransform);
            this.transform.set(this.objectTransform);
        } else {
            this.transform.setToZero();
        }
        return this.transform;
    }

    public void update() {
    }

    public abstract YoGraphic duplicate(YoRegistry var1);

    public String toString() {
        return this.name;
    }
}

