/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics.plotting;

import java.awt.BasicStroke;
import java.awt.Color;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifact;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLineSegment2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoArtifactLineSegment2d
extends YoArtifact {
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private final YoFrameLineSegment2D lineSegment;
    private final Point2D tempFirstEndpoint = new Point2D();
    private final LineSegment2D tempLineSegment = new LineSegment2D();
    private final ConvexPolygon2D tempArrowPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])new double[][]{{0.0, 0.1}, {0.1, 0.0}, {0.1, 0.1}}));
    private final boolean drawArrow;
    private double arrowHeadWidth;
    private double arrowHeadHeight;
    private Vector2D arrowHeadVector;
    private Vector2D arrowHeadLateralVector;

    public YoArtifactLineSegment2d(String name, YoFramePoint2D startPoint, YoFramePoint2D endPoint, Color color, double arrowHeadWidth, double arrowHeadHeight) {
        this(name, startPoint.getYoX(), startPoint.getYoY(), endPoint.getYoX(), endPoint.getYoY(), color, arrowHeadWidth, arrowHeadHeight);
    }

    private YoArtifactLineSegment2d(String name, YoDouble startX, YoDouble startY, YoDouble endX, YoDouble endY, Color color, double arrowHeadWidth, double arrowHeadHeight) {
        this(name, new YoFrameLineSegment2D(startX, startY, endX, endY, ReferenceFrame.getWorldFrame()), color, arrowHeadWidth, arrowHeadHeight);
    }

    public YoArtifactLineSegment2d(String name, YoFramePoint2D start, YoFramePoint2D end, Color color) {
        this(name, new YoFrameLineSegment2D(start.getYoX(), start.getYoY(), end.getYoX(), end.getYoY(), ReferenceFrame.getWorldFrame()), color);
    }

    public YoArtifactLineSegment2d(String name, YoFrameLineSegment2D lineSegment, Color color, double arrowHeadWidth, double arrowHeadHeight) {
        super(name, new double[0], color, new YoVariable[]{lineSegment.getYoFirstEndpointX(), lineSegment.getYoFirstEndpointY(), lineSegment.getYoSecondEndpointX(), lineSegment.getYoSecondEndpointY()});
        this.lineSegment = lineSegment;
        this.drawArrow = true;
        this.instatiateArrowObjects(arrowHeadWidth, arrowHeadHeight);
    }

    public YoArtifactLineSegment2d(String name, YoFrameLineSegment2D lineSegment, Color color) {
        super(name, new double[0], color, new YoVariable[]{lineSegment.getYoFirstEndpointX(), lineSegment.getYoFirstEndpointY(), lineSegment.getYoSecondEndpointX(), lineSegment.getYoSecondEndpointY()});
        this.lineSegment = lineSegment;
        this.drawArrow = false;
    }

    public void instatiateArrowObjects(double arrowHeadWidth, double arrowHeadHeight) {
        this.arrowHeadWidth = arrowHeadWidth;
        this.arrowHeadHeight = arrowHeadHeight;
        this.arrowHeadVector = new Vector2D();
        this.arrowHeadLateralVector = new Vector2D();
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        if (this.lineSegment.getFirstEndpoint().equals((EuclidFrameGeometry)this.lineSegment.getSecondEndpoint())) {
            this.tempFirstEndpoint.set(this.lineSegment.getFirstEndpointX(), this.lineSegment.getFirstEndpointY());
            graphics.drawPoint((Point2DReadOnly)this.tempFirstEndpoint);
        } else {
            this.tempLineSegment.set((LineSegment2DReadOnly)this.lineSegment);
            graphics.drawLineSegment((LineSegment2DReadOnly)this.tempLineSegment);
        }
        if (this.drawArrow) {
            this.arrowHeadVector.set(this.lineSegment.getSecondEndpointX() - this.lineSegment.getFirstEndpointX(), this.lineSegment.getSecondEndpointY() - this.lineSegment.getFirstEndpointY());
            this.arrowHeadVector.normalize();
            this.arrowHeadLateralVector.set(this.arrowHeadVector.getY(), -this.arrowHeadVector.getX());
            this.arrowHeadVector.scale(this.arrowHeadHeight);
            this.arrowHeadLateralVector.scale(this.arrowHeadWidth / 2.0);
            ((Tuple2DBasics)this.tempArrowPolygon.getVertex(0)).set(this.lineSegment.getSecondEndpointX(), this.lineSegment.getSecondEndpointY());
            ((Tuple2DBasics)this.tempArrowPolygon.getVertex(1)).set(this.lineSegment.getSecondEndpointX(), this.lineSegment.getSecondEndpointY());
            ((Tuple2DBasics)this.tempArrowPolygon.getVertex(1)).sub((Tuple2DReadOnly)this.arrowHeadVector);
            ((Tuple2DBasics)this.tempArrowPolygon.getVertex(1)).sub((Tuple2DReadOnly)this.arrowHeadLateralVector);
            ((Tuple2DBasics)this.tempArrowPolygon.getVertex(2)).set(this.lineSegment.getSecondEndpointX(), this.lineSegment.getSecondEndpointY());
            ((Tuple2DBasics)this.tempArrowPolygon.getVertex(2)).sub((Tuple2DReadOnly)this.arrowHeadVector);
            ((Tuple2DBasics)this.tempArrowPolygon.getVertex(2)).add((Tuple2DReadOnly)this.arrowHeadLateralVector);
            graphics.drawPolygonFilled((ConvexPolygon2DReadOnly)this.tempArrowPolygon);
        }
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        graphics.drawLineSegment(graphics.getScreenFrame(), -20.0 + origin.getX(), -5.0 + origin.getY(), 20.0 + origin.getX(), 5.0 + origin.getY());
    }

    @Override
    public void drawHistoryEntry(Graphics2DAdapter graphics, double[] entry) {
        this.tempLineSegment.set(entry[0], entry[1], entry[2], entry[3]);
    }

    @Override
    public YoArtifact duplicate(YoRegistry newRegistry) {
        return new YoArtifactLineSegment2d(this.getName(), this.lineSegment.duplicate(newRegistry), this.color, this.arrowHeadWidth, this.arrowHeadHeight);
    }
}

