/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics.plotting;

import java.awt.BasicStroke;
import java.awt.Color;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifact;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLine2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoArtifactLine2d
extends YoArtifact {
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private final YoFrameLine2D yoFrameLine2d;
    private final Line2D tempLine = new Line2D();

    public YoArtifactLine2d(String name, YoFrameLine2D yoFrameLine2d, Color color) {
        super(name, new double[0], color, new YoVariable[]{yoFrameLine2d.getYoPointX(), yoFrameLine2d.getYoPointY(), yoFrameLine2d.getYoDirectionX(), yoFrameLine2d.getYoDirectionY()});
        this.yoFrameLine2d = yoFrameLine2d;
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        this.tempLine.set((Line2DReadOnly)this.yoFrameLine2d);
        graphics.drawLine((Line2DReadOnly)this.tempLine);
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        graphics.drawLineSegment(graphics.getScreenFrame(), -20.0 + origin.getX(), -5.0 + origin.getY(), 20.0 + origin.getX(), 5.0 + origin.getY());
    }

    @Override
    public void drawHistoryEntry(Graphics2DAdapter graphics, double[] entry) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        this.tempLine.set(entry[0], entry[1], entry[2], entry[3]);
        graphics.drawLine((Line2DReadOnly)this.tempLine);
    }

    @Override
    public YoArtifactLine2d duplicate(YoRegistry newRegistry) {
        return new YoArtifactLine2d(this.getName(), this.yoFrameLine2d.duplicate(newRegistry), this.color);
    }
}

