/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;

public class YoGraphicsList {
    private String label;
    private List<YoGraphic> yoGraphics;

    public YoGraphicsList(String label, List<? extends YoGraphic> yoGraphics) {
        this.checkLabelNonEmpty(label);
        this.label = label;
        this.yoGraphics = new ArrayList<YoGraphic>(yoGraphics);
    }

    public YoGraphicsList(String label, YoGraphic[] yoGraphicsArray) {
        this.checkLabelNonEmpty(label);
        this.label = label;
        ArrayList<YoGraphic> yoGraphics = new ArrayList<YoGraphic>(yoGraphicsArray.length);
        for (YoGraphic yoGraphic : yoGraphicsArray) {
            yoGraphics.add(yoGraphic);
        }
        this.yoGraphics = yoGraphics;
    }

    public void setRootTransform(RigidBodyTransform rootTransform) {
        for (int i = 0; i < this.yoGraphics.size(); ++i) {
            this.yoGraphics.get(i).setRootTransform((RigidBodyTransformReadOnly)rootTransform);
        }
    }

    public YoGraphicsList(String label, YoGraphic yoGraphic) {
        this.checkLabelNonEmpty(label);
        this.label = label;
        ArrayList<YoGraphic> yoGraphics = new ArrayList<YoGraphic>(1);
        yoGraphics.add(yoGraphic);
        this.yoGraphics = yoGraphics;
    }

    public YoGraphicsList(String label) {
        this.checkLabelNonEmpty(label);
        this.label = label;
        this.yoGraphics = new ArrayList<YoGraphic>();
    }

    public String getLabel() {
        return this.label;
    }

    public List<YoGraphic> getYoGraphics() {
        return this.yoGraphics;
    }

    public void add(YoGraphic yoGraphic) {
        this.yoGraphics.add(yoGraphic);
    }

    public void addAll(List<YoGraphic> yoGraphics) {
        this.yoGraphics.addAll(yoGraphics);
    }

    public void hideYoGraphics() {
        int numberOfElements = this.yoGraphics.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphic yoGraphic = this.yoGraphics.get(i);
            yoGraphic.hideGraphicObject();
        }
    }

    public boolean checkAllYoGraphicsAreShowing() {
        int numberOfElements = this.yoGraphics.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphic yoGraphic = this.yoGraphics.get(i);
            if (yoGraphic.isGraphicObjectShowing()) continue;
            return false;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        int numberOfElements = this.yoGraphics.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphic yoGraphic = this.yoGraphics.get(i);
            yoGraphic.setVisible(visible);
        }
    }

    private void checkLabelNonEmpty(String label) {
        if (label.isEmpty()) {
            throw new RuntimeException("Label is empty.");
        }
    }

    public String toString() {
        Object ret = "";
        ret = (String)ret + this.label + ":";
        int numberOfElements = this.yoGraphics.size();
        for (int i = 0; i < numberOfElements; ++i) {
            YoGraphic yoGraphic = this.yoGraphics.get(i);
            ret = (String)ret + "\n" + yoGraphic.toString();
        }
        return ret;
    }
}

