/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting.artifact;

import java.awt.Font;
import java.io.PrintWriter;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;

public class TextArtifact
extends Artifact {
    private double x1;
    private double y1;
    private String text;
    private Font font = Font.getFont("SansSerif");
    private final Point2D tempPoint = new Point2D();

    public TextArtifact(String id, String text, double x1, double y1) {
        super(id);
        this.setLevel(1);
        this.text = text;
        this.x1 = x1;
        this.y1 = y1;
    }

    public void setPosition(double x1, double y1) {
        this.x1 = x1;
        this.y1 = y1;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getX() {
        return this.x1;
    }

    public double getY() {
        return this.y1;
    }

    public void setFontSize(int size) {
        this.font = new Font("SansSerif", 0, size);
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        graphics.setColor(this.color);
        graphics.setFont(this.font);
        this.tempPoint.set(this.x1, this.y1);
        graphics.drawString(this.text, (Point2DReadOnly)this.tempPoint);
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.setColor(this.color);
        graphics.setFont(this.font);
        this.tempPoint.set(origin.getX() - 30.0, origin.getY() + 6.0);
        graphics.drawString(graphics.getScreenFrame(), this.text, (Point2DReadOnly)this.tempPoint);
    }

    public void save(PrintWriter printWriter) {
        printWriter.println(this.x1 + " " + this.y1 + " " + this.id);
    }

    public TextArtifact getCopy() {
        TextArtifact cirlceCopy = new TextArtifact(this.getID(), this.text, this.x1, this.y1);
        cirlceCopy.setColor(this.getColor());
        return cirlceCopy;
    }

    @Override
    public void drawHistory(Graphics2DAdapter graphics) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void takeHistorySnapshot() {
        throw new RuntimeException("Not implemented!");
    }
}

