/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.util.concurrent.atomic.AtomicBoolean;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicTriangle
extends YoGraphic
implements RemoteYoGraphic,
GraphicsUpdatable {
    private final YoFramePoint3D pointOne;
    private final YoFramePoint3D pointTwo;
    private final YoFramePoint3D pointThree;
    private final Graphics3DObject graphics3dObject;
    private final Graphics3DAddMeshDataInstruction instruction;
    private final AppearanceDefinition appearance;
    private final AtomicBoolean hasChanged = new AtomicBoolean(false);

    public YoGraphicTriangle(String name, AppearanceDefinition appearance, YoRegistry registry) {
        this(name, new YoFramePoint3D(name + "0", ReferenceFrame.getWorldFrame(), registry), new YoFramePoint3D(name + "1", ReferenceFrame.getWorldFrame(), registry), new YoFramePoint3D(name + "2", ReferenceFrame.getWorldFrame(), registry), appearance);
    }

    public YoGraphicTriangle(String name, YoFramePoint3D pointOne, YoFramePoint3D pointTwo, YoFramePoint3D pointThree, AppearanceDefinition appearance) {
        super(name);
        this.pointOne = pointOne;
        this.pointTwo = pointTwo;
        this.pointThree = pointThree;
        this.appearance = appearance;
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        this.instruction = this.graphics3dObject.addPolygon(appearance, new Point3DReadOnly[]{pointOne, pointTwo, pointThree});
        YoVariableChangedListener listener = new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                YoGraphicTriangle.this.hasChanged.set(true);
            }
        };
        pointOne.attachVariableChangedListener(listener);
        pointTwo.attachVariableChangedListener(listener);
        pointThree.attachVariableChangedListener(listener);
    }

    public YoGraphicTriangle(String name, YoDouble pointOneX, YoDouble pointOneY, YoDouble pointOneZ, YoDouble pointTwoX, YoDouble pointTwoY, YoDouble pointTwoZ, YoDouble pointThreeX, YoDouble pointThreeY, YoDouble pointThreeZ, AppearanceDefinition appearance) {
        this(name, new YoFramePoint3D(pointOneX, pointOneY, pointOneZ, ReferenceFrame.getWorldFrame()), new YoFramePoint3D(pointTwoX, pointTwoY, pointTwoZ, ReferenceFrame.getWorldFrame()), new YoFramePoint3D(pointThreeX, pointThreeY, pointThreeZ, ReferenceFrame.getWorldFrame()), appearance);
    }

    @Override
    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }

    @Override
    public void update() {
        if (this.hasChanged.getAndSet(false)) {
            if (!(this.pointOne.containsNaN() || this.pointTwo.containsNaN() || this.pointThree.containsNaN())) {
                this.instruction.setMesh(MeshDataGenerator.Polygon(new Point3DReadOnly[]{this.pointOne, this.pointTwo, this.pointThree}));
            } else {
                this.instruction.setMesh(null);
            }
        }
    }

    public void updatePointOne(FramePoint3DReadOnly framePointOne) {
        this.pointOne.set((FrameTuple3DReadOnly)framePointOne);
        this.update();
    }

    public void updatePointTwo(FramePoint3DReadOnly framePointTwo) {
        this.pointTwo.set((FrameTuple3DReadOnly)framePointTwo);
        this.update();
    }

    public void updatePointThree(FramePoint3DReadOnly framePointThree) {
        this.pointThree.set((FrameTuple3DReadOnly)framePointThree);
        this.update();
    }

    public void updatePoints(Point3DReadOnly pointOne, Point3DReadOnly pointTwo, Point3DReadOnly pointThree) {
        this.pointOne.set((Tuple3DReadOnly)pointOne);
        this.pointTwo.set((Tuple3DReadOnly)pointTwo);
        this.pointThree.set((Tuple3DReadOnly)pointThree);
        this.update();
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    @Override
    public YoVariable[] getVariables() {
        YoVariable[] vars = new YoVariable[9];
        int i = 0;
        vars[i++] = this.pointOne.getYoX();
        vars[i++] = this.pointOne.getYoY();
        vars[i++] = this.pointOne.getYoZ();
        vars[i++] = this.pointTwo.getYoX();
        vars[i++] = this.pointTwo.getYoY();
        vars[i++] = this.pointTwo.getYoZ();
        vars[i++] = this.pointThree.getYoX();
        vars[i++] = this.pointThree.getYoY();
        vars[i++] = this.pointThree.getYoZ();
        return vars;
    }

    @Override
    public double[] getConstants() {
        return new double[0];
    }

    @Override
    public AppearanceDefinition getAppearance() {
        return this.appearance;
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3d) {
        transform3d.setIdentity();
    }

    @Override
    protected boolean containsNaN() {
        if (this.pointOne.containsNaN()) {
            return true;
        }
        if (this.pointTwo.containsNaN()) {
            return true;
        }
        return this.pointThree.containsNaN();
    }

    public void setToNaN() {
        this.pointOne.setToNaN();
        this.pointTwo.setToNaN();
        this.pointThree.setToNaN();
        this.update();
    }

    @Override
    public YoGraphicTriangle duplicate(YoRegistry newRegistry) {
        return new YoGraphicTriangle(this.getName(), this.pointOne.duplicate(newRegistry), this.pointTwo.duplicate(newRegistry), this.pointThree.duplicate(newRegistry), this.appearance);
    }
}

