/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTexture;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicAbstractShape;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoGraphicText
extends YoGraphicAbstractShape {
    private final Graphics3DObject graphics3dObject;
    private final Font font = new Font("Lucida Sans", 1, 26);
    private final String text;
    private final Color backgroundColor;
    private final Color textAppearance;

    public YoGraphicText(String name, String text, YoFramePoint3D framePoint, YoFrameYawPitchRoll frameOrientation, double scale, Color backgroundColor, Color textAppearance) {
        super(name, framePoint, frameOrientation, scale);
        this.text = text;
        this.backgroundColor = backgroundColor;
        this.textAppearance = textAppearance;
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        double blockWidth = (double)text.length() * 0.5;
        double blockHeight = 0.5;
        double blockThickness = 0.01;
        double imageScaleFactor = 50.0;
        int imageWidth = (int)(blockWidth * imageScaleFactor);
        int imageHeight = (int)(blockHeight * imageScaleFactor);
        BufferedImage appearance = new BufferedImage(imageWidth, imageHeight, 6);
        Graphics2D g = appearance.createGraphics();
        Rectangle2D bounds = this.font.getStringBounds(text, g.getFontRenderContext());
        g.dispose();
        int textHeight = (int)bounds.getHeight();
        int textWidth = (int)bounds.getWidth();
        imageWidth = textWidth + 10;
        imageHeight = textHeight + 10;
        blockWidth = blockHeight / (double)imageHeight * (double)imageWidth;
        appearance = new BufferedImage(imageWidth, imageHeight, 6);
        g = appearance.createGraphics();
        g.setColor(backgroundColor);
        g.fillRect(0, 0, imageWidth, imageHeight);
        int x = (imageWidth - textWidth) / 2;
        int y = (imageHeight - textHeight) / 2 + textHeight;
        g.setColor(textAppearance);
        g.translate(x, y);
        g.setFont(this.font);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawString(text, 0, 0);
        g.dispose();
        this.graphics3dObject.addCube(blockWidth, blockHeight, blockThickness, new YoAppearanceTexture(appearance));
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    @Override
    public YoGraphic duplicate(YoRegistry newRegistry) {
        return new YoGraphicText(this.getName(), this.text, this.yoFramePoint.duplicate(newRegistry), this.yoFrameYawPitchRoll.duplicate(newRegistry), this.scale, this.backgroundColor, this.textAppearance);
    }
}

