/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics;

import java.awt.Color;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicCoordinateSystem
extends YoGraphic
implements RemoteYoGraphic {
    protected static final AppearanceDefinition DEFAULT_APPEARANCE = YoAppearance.Gray();
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    protected final YoFramePoint3D position;
    protected final YoFrameYawPitchRoll yawPitchRoll;
    protected final YoFrameQuaternion quaternion;
    protected final double scale;
    protected AppearanceDefinition arrowColor = DEFAULT_APPEARANCE;
    private double colorRGB32BitInt = this.arrowColor.getAwtColor().getRGB();
    private double transparency = this.arrowColor.getTransparency();
    private final RigidBodyTransform transformToWorld = new RigidBodyTransform();

    public YoGraphicCoordinateSystem(String namePrefix, String nameSuffix, YoRegistry registry, boolean useYawPitchRoll, double scale) {
        this(namePrefix, nameSuffix, registry, useYawPitchRoll, scale, DEFAULT_APPEARANCE);
    }

    public YoGraphicCoordinateSystem(String namePrefix, String nameSuffix, YoRegistry registry, boolean useYawPitchRoll, double scale, AppearanceDefinition arrowAppearance) {
        this(namePrefix + nameSuffix, new YoFramePoint3D(namePrefix, nameSuffix, worldFrame, registry), useYawPitchRoll ? new YoFrameYawPitchRoll(namePrefix, nameSuffix, worldFrame, registry) : null, useYawPitchRoll ? null : new YoFrameQuaternion(namePrefix, nameSuffix, worldFrame, registry), scale, arrowAppearance);
    }

    public YoGraphicCoordinateSystem(String name, YoFramePose3D yoFramePose, double scale) {
        this(name, yoFramePose, scale, DEFAULT_APPEARANCE);
    }

    public YoGraphicCoordinateSystem(String name, YoFramePose3D yoFramePose, double scale, AppearanceDefinition arrowAppearance) {
        this(name, yoFramePose.getPosition(), yoFramePose.getOrientation(), scale, arrowAppearance);
    }

    public YoGraphicCoordinateSystem(String name, YoFramePoint3D framePoint, YoFrameQuaternion orientation, double scale) {
        this(name, framePoint, orientation, scale, DEFAULT_APPEARANCE);
    }

    public YoGraphicCoordinateSystem(String name, YoFramePoint3D framePoint, YoFrameQuaternion orientation, double scale, AppearanceDefinition arrowAppearance) {
        this(name, framePoint, null, orientation, scale, arrowAppearance);
    }

    public YoGraphicCoordinateSystem(String name, YoFramePoseUsingYawPitchRoll yoFramePose, double scale) {
        this(name, yoFramePose, scale, DEFAULT_APPEARANCE);
    }

    public YoGraphicCoordinateSystem(String name, YoFramePoseUsingYawPitchRoll yoFramePose, double scale, AppearanceDefinition arrowAppearance) {
        this(name, yoFramePose.getPosition(), yoFramePose.getYawPitchRoll(), scale, arrowAppearance);
    }

    public YoGraphicCoordinateSystem(String name, YoFramePoint3D framePoint, YoFrameYawPitchRoll orientation, double scale) {
        this(name, framePoint, orientation, scale, DEFAULT_APPEARANCE);
    }

    public YoGraphicCoordinateSystem(String name, YoFramePoint3D framePoint, YoFrameYawPitchRoll orientation, double scale, AppearanceDefinition arrowAppearance) {
        this(name, framePoint, orientation, null, scale, arrowAppearance);
    }

    protected YoGraphicCoordinateSystem(String name, YoFramePoint3D position, YoFrameYawPitchRoll yawPitchRoll, YoFrameQuaternion quaternion, double scale, AppearanceDefinition arrowAppearance) {
        super(name);
        worldFrame.checkReferenceFrameMatch((ReferenceFrameHolder)position);
        if (yawPitchRoll == null && quaternion == null || yawPitchRoll != null && quaternion != null) {
            throw new IllegalArgumentException("Can only describe the orientation of this shape with either yaw-pitch-roll or quaternion.");
        }
        if (yawPitchRoll != null) {
            worldFrame.checkReferenceFrameMatch((ReferenceFrameHolder)yawPitchRoll);
        }
        if (quaternion != null) {
            worldFrame.checkReferenceFrameMatch((ReferenceFrameHolder)quaternion);
        }
        this.position = position;
        this.yawPitchRoll = yawPitchRoll;
        this.quaternion = quaternion;
        this.scale = scale;
        this.setArrowColor(arrowAppearance);
    }

    static YoGraphicCoordinateSystem createAsRemoteYoGraphic(String name, YoVariable[] yoVariables, double[] constants) {
        return new YoGraphicCoordinateSystem(name, yoVariables, constants);
    }

    protected YoGraphicCoordinateSystem(String name, YoVariable[] yoVariables, double[] constants) {
        super(name);
        int yoIndex = 0;
        YoDouble x = (YoDouble)yoVariables[yoIndex++];
        YoDouble y = (YoDouble)yoVariables[yoIndex++];
        YoDouble z = (YoDouble)yoVariables[yoIndex++];
        this.position = new YoFramePoint3D(x, y, z, worldFrame);
        if (yoVariables.length == 6) {
            YoDouble yaw = (YoDouble)yoVariables[yoIndex++];
            YoDouble pitch = (YoDouble)yoVariables[yoIndex++];
            YoDouble roll = (YoDouble)yoVariables[yoIndex++];
            this.yawPitchRoll = new YoFrameYawPitchRoll(yaw, pitch, roll, worldFrame);
            this.quaternion = null;
        } else if (yoVariables.length == 7) {
            YoDouble qx = (YoDouble)yoVariables[yoIndex++];
            YoDouble qy = (YoDouble)yoVariables[yoIndex++];
            YoDouble qz = (YoDouble)yoVariables[yoIndex++];
            YoDouble qs = (YoDouble)yoVariables[yoIndex++];
            this.yawPitchRoll = null;
            this.quaternion = new YoFrameQuaternion(qx, qy, qz, qs, worldFrame);
        } else {
            throw new RuntimeException("Unexpected number of YoVariables. Expected either 6 or 7 but had: " + yoVariables.length);
        }
        this.scale = constants[0];
        if (constants.length == 3) {
            this.setArrowColor(new YoAppearanceRGBColor(new Color((int)constants[1]), constants[2]));
        }
    }

    public void setToReferenceFrame(ReferenceFrame referenceFrame) {
        if (referenceFrame == null) {
            throw new RuntimeException("referenceFrame == null");
        }
        referenceFrame.getTransformToDesiredFrame(this.transformToWorld, worldFrame);
        this.setTransformToWorld(this.transformToWorld);
    }

    public void setTransformToWorld(RigidBodyTransform transformToWorld) {
        this.position.set((Tuple3DReadOnly)transformToWorld.getTranslation());
        if (this.isUsingYawPitchRoll()) {
            this.yawPitchRoll.set((Orientation3DReadOnly)transformToWorld.getRotation());
        } else {
            this.quaternion.set((Orientation3DReadOnly)transformToWorld.getRotation());
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void getPosition(Tuple3DBasics position) {
        position.set((Tuple3DReadOnly)this.position);
    }

    public void getOrientation(QuaternionBasics quaternionToPack) {
        if (this.isUsingYawPitchRoll()) {
            quaternionToPack.set((Orientation3DReadOnly)this.yawPitchRoll);
        } else {
            quaternionToPack.set((QuaternionReadOnly)this.quaternion);
        }
    }

    public void setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
    }

    public void setPosition(Tuple3DReadOnly position) {
        this.position.set(position);
    }

    public void setPosition(FramePoint3DReadOnly position) {
        this.position.set((FrameTuple3DReadOnly)position);
    }

    public void setOrientation(QuaternionReadOnly orientation) {
        if (this.isUsingYawPitchRoll()) {
            this.yawPitchRoll.set((Orientation3DReadOnly)orientation);
        } else {
            this.quaternion.set(orientation);
        }
    }

    public void setOrientation(FrameQuaternionReadOnly orientation) {
        if (this.isUsingYawPitchRoll()) {
            this.yawPitchRoll.set((FrameOrientation3DReadOnly)orientation);
        } else {
            this.quaternion.set(orientation);
        }
    }

    public void setYawPitchRoll(double yaw, double pitch, double roll) {
        if (this.isUsingYawPitchRoll()) {
            this.yawPitchRoll.setYawPitchRoll(yaw, pitch, roll);
        } else {
            this.quaternion.setYawPitchRoll(yaw, pitch, roll);
        }
    }

    public void setPose(FramePose3DReadOnly pose) {
        this.setPosition(pose.getPosition());
        this.setOrientation(pose.getOrientation());
    }

    public void setArrowColor(AppearanceDefinition arrowColor) {
        this.arrowColor = arrowColor;
        this.colorRGB32BitInt = arrowColor.getAwtColor().getRGB();
        this.transparency = arrowColor.getTransparency();
    }

    public void hide() {
        this.position.setToNaN();
        if (this.isUsingYawPitchRoll()) {
            this.yawPitchRoll.setToNaN();
        } else {
            this.quaternion.setToNaN();
        }
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(1.0, this.arrowColor);
        return linkGraphics;
    }

    @Override
    protected void computeRotationTranslation(AffineTransform transform3D) {
        transform3D.setIdentity();
        double globalScale = 1.0;
        if (this.globalScaleProvider != null) {
            globalScale = this.globalScaleProvider.getValue();
        }
        if (this.isUsingYawPitchRoll()) {
            transform3D.setLinearTransform((Orientation3DReadOnly)this.yawPitchRoll);
        } else {
            transform3D.setLinearTransform((Orientation3DReadOnly)this.quaternion);
        }
        transform3D.appendScale(this.scale * globalScale);
        transform3D.setTranslation((Tuple3DReadOnly)this.position);
    }

    @Override
    public boolean containsNaN() {
        if (this.position.containsNaN()) {
            return true;
        }
        if (this.isUsingYawPitchRoll()) {
            return this.yawPitchRoll.containsNaN();
        }
        return this.quaternion.containsNaN();
    }

    @Override
    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }

    public YoDouble[] getVariables() {
        YoDouble[] vars = new YoDouble[this.isUsingYawPitchRoll() ? 6 : 7];
        int i = 0;
        vars[i++] = this.position.getYoX();
        vars[i++] = this.position.getYoY();
        vars[i++] = this.position.getYoZ();
        if (this.isUsingYawPitchRoll()) {
            vars[i++] = this.yawPitchRoll.getYoYaw();
            vars[i++] = this.yawPitchRoll.getYoPitch();
            vars[i++] = this.yawPitchRoll.getYoRoll();
        } else {
            vars[i++] = this.quaternion.getYoQx();
            vars[i++] = this.quaternion.getYoQy();
            vars[i++] = this.quaternion.getYoQz();
            vars[i++] = this.quaternion.getYoQs();
        }
        return vars;
    }

    @Override
    public double[] getConstants() {
        return new double[]{this.scale, this.colorRGB32BitInt, this.transparency};
    }

    @Override
    public YoGraphicCoordinateSystem duplicate(YoRegistry newRegistry) {
        if (this.isUsingYawPitchRoll()) {
            return new YoGraphicCoordinateSystem(this.getName(), this.position.duplicate(newRegistry), this.yawPitchRoll.duplicate(newRegistry), this.scale, this.arrowColor);
        }
        return new YoGraphicCoordinateSystem(this.getName(), this.position.duplicate(newRegistry), this.quaternion.duplicate(newRegistry), this.scale, this.arrowColor);
    }

    @Override
    public AppearanceDefinition getAppearance() {
        return this.arrowColor;
    }

    public boolean isUsingYawPitchRoll() {
        return this.yawPitchRoll != null;
    }
}

