/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting.artifact;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;

public class CircleArtifact
extends Artifact {
    private static final BasicStroke STROKE = new BasicStroke(1.0f);
    private static final double LEGEND_RADIUS = 20.0;
    private double x;
    private double y;
    private double diameter;
    private boolean fill = true;
    private final Point2D tempPoint = new Point2D();
    private final Vector2D tempRadii = new Vector2D();

    public CircleArtifact(String id, double x, double y, double diameter, boolean fill) {
        super(id);
        this.setLevel(1);
        this.x = x;
        this.y = y;
        this.diameter = diameter;
        this.fill = fill;
    }

    public CircleArtifact(String string, double x2, double y2, double d, boolean b, Color color) {
        this(string, x2, y2, d, b);
        this.setColor(color);
    }

    public void setPosition(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setDiameter(double diameter) {
        this.diameter = diameter;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        this.tempPoint.set(this.x, this.y);
        this.tempRadii.set(this.diameter / 2.0, this.diameter / 2.0);
        if (this.fill) {
            graphics.drawOvalFilled((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.tempRadii);
        } else {
            graphics.drawOval((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.tempRadii);
        }
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        this.tempPoint.set(origin);
        this.tempRadii.set(20.0, 20.0);
        if (this.fill) {
            graphics.drawOvalFilled(graphics.getScreenFrame(), (Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.tempRadii);
        } else {
            graphics.drawOval(graphics.getScreenFrame(), (Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.tempRadii);
        }
    }

    public void save(PrintWriter printWriter) {
        printWriter.println(this.x + " " + this.y + " " + this.diameter + " " + this.fill + " " + this.id);
    }

    public static CircleArtifact load(BufferedReader bufferedReader) {
        CircleArtifact circleArtifact = null;
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                return null;
            }
            StringTokenizer s = new StringTokenizer(line, " ");
            double x = Double.parseDouble(s.nextToken());
            double y = Double.parseDouble(s.nextToken());
            double diameter = Double.parseDouble(s.nextToken());
            boolean fill = Boolean.parseBoolean(s.nextToken());
            String id = s.nextToken();
            circleArtifact = new CircleArtifact(id, x, y, diameter, fill);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return circleArtifact;
    }

    public CircleArtifact getCopy() {
        CircleArtifact cirlceCopy = new CircleArtifact(this.getID(), this.x, this.y, this.diameter, this.fill);
        cirlceCopy.setColor(this.getColor());
        return cirlceCopy;
    }

    @Override
    public void drawHistory(Graphics2DAdapter graphics) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void takeHistorySnapshot() {
        throw new RuntimeException("Not implemented!");
    }
}

