/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics.plotting;

import java.awt.BasicStroke;
import java.awt.Color;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifact;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoArtifactPosition
extends YoArtifact {
    private static final int LEGEND_RADIUS = 20;
    private static final BasicStroke STROKE = new BasicStroke(1.2f);
    private final YoFramePoint2D point;
    private final Vector2D radii = new Vector2D();
    private final YoGraphicPosition.GraphicType graphicType;
    private final Point2D tempPoint = new Point2D();
    private final Vector2D legendRadii = new Vector2D();

    public YoArtifactPosition(String namePrefix, String nameSuffix, YoGraphicPosition.GraphicType type, Color color, double radius, YoRegistry registry) {
        this(namePrefix + nameSuffix, new YoDouble(namePrefix + "X" + nameSuffix, registry), new YoDouble(namePrefix + "Y" + nameSuffix, registry), type, color, radius);
    }

    public YoArtifactPosition(String name, YoDouble x, YoDouble y, YoGraphicPosition.GraphicType type, Color color, double radius) {
        this(name, new YoFramePoint2D(x, y, ReferenceFrame.getWorldFrame()), type, color, radius);
    }

    public YoArtifactPosition(String name, YoFramePoint2D point, YoGraphicPosition.GraphicType type, Color color, double radius) {
        super(name, new double[]{radius, type.ordinal()}, color, new YoVariable[]{point.getYoX(), point.getYoY()});
        this.point = point;
        this.graphicType = type;
        this.radii.set(radius, radius);
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        this.legendRadii.set(20.0, 20.0);
        switch (this.graphicType) {
            case BALL: {
                graphics.drawOval(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case SOLID_BALL: {
                graphics.drawOvalFilled(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case CROSS: {
                graphics.drawCross(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case BALL_WITH_CROSS: {
                graphics.drawCircleWithCross(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case ROTATED_CROSS: {
                graphics.drawRotatedCross(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case BALL_WITH_ROTATED_CROSS: {
                graphics.drawCircleWithRotatedCross(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case DIAMOND: {
                graphics.drawDiamond(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case DIAMOND_WITH_CROSS: {
                graphics.drawDiamondWithCross(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case SQUARE: {
                graphics.drawRectangle(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case SQUARE_WITH_CROSS: {
                graphics.drawSquareWithCross(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
                break;
            }
            case ELLIPSOID: {
                this.legendRadii.set(24.0, 16.0);
                graphics.drawOval(graphics.getScreenFrame(), (Point2DReadOnly)origin, (Vector2DReadOnly)this.legendRadii);
            }
        }
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        this.tempPoint.set((Tuple2DReadOnly)this.point);
        this.drawLocal(graphics);
    }

    @Override
    public void drawHistoryEntry(Graphics2DAdapter graphics, double[] entry) {
        this.tempPoint.set(entry[0], entry[1]);
        this.drawLocal(graphics);
    }

    private void drawLocal(Graphics2DAdapter graphics) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        if (Double.isNaN(this.tempPoint.getX()) || Double.isNaN(this.tempPoint.getY())) {
            return;
        }
        switch (this.graphicType) {
            case BALL: {
                graphics.drawOval((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case SOLID_BALL: {
                graphics.drawOvalFilled((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case CROSS: {
                graphics.drawCross((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case BALL_WITH_CROSS: {
                graphics.drawCircleWithCross((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case ROTATED_CROSS: {
                graphics.drawRotatedCross((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case BALL_WITH_ROTATED_CROSS: {
                graphics.drawCircleWithRotatedCross((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case DIAMOND: {
                graphics.drawDiamond((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case DIAMOND_WITH_CROSS: {
                graphics.drawDiamondWithCross((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case SQUARE: {
                graphics.drawSquare((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case SQUARE_WITH_CROSS: {
                graphics.drawSquareWithCross((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                break;
            }
            case ELLIPSOID: {
                double radius = this.radii.getX();
                this.radii.setX(this.radii.getX() * 1.2);
                this.radii.setY(this.radii.getY() * 0.8);
                graphics.drawOval((Point2DReadOnly)this.tempPoint, (Vector2DReadOnly)this.radii);
                this.radii.set(radius, radius);
            }
        }
    }

    public YoDouble getYoX() {
        return this.point.getYoX();
    }

    public YoDouble getYoY() {
        return this.point.getYoY();
    }

    public void setPosition(Point2DReadOnly point2D) {
        this.point.set((Tuple2DReadOnly)point2D);
    }

    @Override
    public YoArtifact duplicate(YoRegistry newRegistry) {
        return new YoArtifactPosition(this.getName(), this.point.duplicate(newRegistry), this.graphicType, this.color, this.radii.getX());
    }
}

