/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics.plotting;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifact;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoArtifactPolygon
extends YoArtifact {
    private final YoFrameConvexPolygon2D convexPolygon;
    private final ConvexPolygon2D tempConvexPolygon = new ConvexPolygon2D();
    private final boolean fill;
    private final BasicStroke stroke;
    private final Point2D legendStringPosition = new Point2D();
    private final int lineWidth;
    private final boolean dashedLine;

    public YoArtifactPolygon(String name, YoFrameConvexPolygon2D yoConvexPolygon2d, Color color, boolean fill) {
        this(name, yoConvexPolygon2d, color, fill, 2, false);
    }

    public YoArtifactPolygon(String name, YoFrameConvexPolygon2D yoConvexPolygon2d, Color color, boolean fill, int lineWidth) {
        this(name, yoConvexPolygon2d, color, fill, lineWidth, false);
    }

    public YoArtifactPolygon(String name, YoFrameConvexPolygon2D yoConvexPolygon2d, Color color, boolean fill, boolean dashedLine) {
        this(name, yoConvexPolygon2d, color, fill, 2, dashedLine);
    }

    public YoArtifactPolygon(String name, YoFrameConvexPolygon2D yoConvexPolygon2d, Color color, boolean fill, int lineWidth, boolean dashedLine) {
        super(name, new double[]{fill ? 1.0 : 0.0}, color, new YoVariable[0]);
        this.convexPolygon = yoConvexPolygon2d;
        this.fill = fill;
        this.lineWidth = lineWidth;
        this.dashedLine = dashedLine;
        if (!dashedLine) {
            this.stroke = new BasicStroke(lineWidth);
        } else {
            float[] dashArray = new float[]{10.0f};
            this.stroke = new BasicStroke(lineWidth, 2, 0, 10.0f, dashArray, 0.0f);
        }
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
        graphics.setColor(this.color);
        String name = "Polygon";
        Rectangle2D textDimensions = graphics.getFontMetrics().getStringBounds(name, graphics.getGraphicsContext());
        this.legendStringPosition.set(origin.getX() - textDimensions.getWidth() / 2.0, origin.getY() + textDimensions.getHeight() / 2.0);
        graphics.drawString(graphics.getScreenFrame(), name, (Point2DReadOnly)this.legendStringPosition);
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        graphics.setColor(this.color);
        graphics.setStroke(this.stroke);
        this.tempConvexPolygon.clear();
        for (int i = 0; i < this.convexPolygon.getNumberOfVertices(); ++i) {
            this.tempConvexPolygon.addVertex((Point2DReadOnly)this.convexPolygon.getVertexBuffer().get(i));
        }
        this.tempConvexPolygon.update();
        if (this.fill) {
            graphics.drawPolygonFilled((ConvexPolygon2DReadOnly)this.tempConvexPolygon);
        } else {
            graphics.drawPolygon((ConvexPolygon2DReadOnly)this.tempConvexPolygon);
        }
    }

    @Override
    public void drawHistoryEntry(Graphics2DAdapter graphics, double[] entry) {
    }

    @Override
    public YoVariable[] getVariables() {
        YoVariable[] vars = new YoVariable[1 + 2 * this.convexPolygon.getMaxNumberOfVertices()];
        int i = 0;
        vars[i++] = this.convexPolygon.getYoNumberOfVertices();
        for (YoFramePoint2D p : this.convexPolygon.getVertexBuffer()) {
            vars[i++] = p.getYoX();
            vars[i++] = p.getYoY();
        }
        return vars;
    }

    @Override
    public YoArtifact duplicate(YoRegistry newRegistry) {
        return new YoArtifactPolygon(this.getName(), this.convexPolygon.duplicate(newRegistry), this.color, this.fill, this.lineWidth, this.dashedLine);
    }
}

