/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.yoGraphics.plotting;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.plotting.PlotterInterface;

public class ArtifactList {
    private String label;
    private List<Artifact> artifacts;

    public ArtifactList(String label, List<Artifact> artifacts) {
        this.label = label;
        this.updateLabels(artifacts);
        this.artifacts = artifacts;
    }

    public ArtifactList(String label, Artifact[] artifactArray) {
        this.label = label;
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(artifactArray.length);
        for (Artifact artifact : artifactArray) {
            artifacts.add(artifact);
        }
        this.artifacts = artifacts;
        this.updateLabels(artifacts);
    }

    public ArtifactList(String label, Artifact artifact) {
        this.label = label;
        this.updateLabel(artifact);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(1);
        artifacts.add(artifact);
        this.artifacts = artifacts;
    }

    public ArtifactList(String label) {
        this.label = label;
        this.artifacts = new ArrayList<Artifact>();
    }

    private void updateLabels(List<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            this.updateLabel(artifact);
        }
    }

    private void updateLabel(Artifact artifact) {
        artifact.setLabel(this.label);
    }

    public String getLabel() {
        return this.label;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void add(Artifact artifact) {
        this.updateLabel(artifact);
        this.artifacts.add(artifact);
    }

    public void addAll(List<Artifact> artifacts) {
        this.updateLabels(artifacts);
        this.artifacts.addAll(artifacts);
    }

    public void addArtifactsToPlotter(PlotterInterface plotter) {
        for (Artifact artifact : this.artifacts) {
            plotter.addArtifact(artifact);
        }
    }

    public void setVisible(boolean visible) {
        if (this.artifacts != null) {
            int numberOfElements = this.artifacts.size();
            for (int i = 0; i < numberOfElements; ++i) {
                Artifact artifact = this.artifacts.get(i);
                artifact.setVisible(visible);
            }
        }
    }

    public void hideArtifacts() {
        if (this.artifacts != null) {
            int numberOfElements = this.artifacts.size();
            for (int i = 0; i < numberOfElements; ++i) {
                Artifact artifact = this.artifacts.get(i);
                artifact.setVisible(false);
            }
        }
    }
}

