/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription.plotting.artifact;

import java.awt.BasicStroke;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.graphicsDescription.plotting.Graphics2DAdapter;
import us.ihmc.graphicsDescription.plotting.Plotter2DAdapter;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;

public class LineArtifact
extends Artifact {
    private static final BasicStroke STROKE = new BasicStroke(1.0f);
    private final Point2D point1 = new Point2D();
    private final Point2D point2 = new Point2D(0.01, 0.01);
    private final LineSegment2D tempLineSegment = new LineSegment2D();

    public LineArtifact(String id) {
        super(id);
    }

    public LineArtifact(String id, Line2DReadOnly line) {
        super(id);
        this.setLine(line);
    }

    public LineArtifact(String id, Point2DReadOnly point1, Point2DReadOnly point2) {
        super(id);
        this.point1.set((Tuple2DReadOnly)point1);
        this.point2.set((Tuple2DReadOnly)point2);
    }

    public void setLine(Line2DReadOnly line) {
        line.getTwoPointsOnLine((Point2DBasics)this.point1, (Point2DBasics)this.point2);
    }

    public void setPoints(Point2DReadOnly point1, Point2DReadOnly point2) {
        this.point1.set((Tuple2DReadOnly)point1);
        this.point2.set((Tuple2DReadOnly)point2);
    }

    public void setPoints(Point2DReadOnly point, Vector2DReadOnly vector) {
        this.point1.set((Tuple2DReadOnly)point);
        this.point2.add((Tuple2DReadOnly)this.point1, (Tuple2DReadOnly)vector);
    }

    @Override
    public void draw(Graphics2DAdapter graphics) {
        graphics.setColor(this.color);
        graphics.setStroke(STROKE);
        if (this.point1.equals((Tuple2DReadOnly)this.point2)) {
            graphics.drawPoint((Point2DReadOnly)this.point1);
        } else {
            this.tempLineSegment.set((Point2DReadOnly)this.point1, (Point2DReadOnly)this.point2);
            graphics.drawLineSegment((LineSegment2DReadOnly)this.tempLineSegment);
        }
    }

    @Override
    public void drawLegend(Plotter2DAdapter graphics, Point2D origin) {
    }

    @Override
    public void drawHistory(Graphics2DAdapter graphics) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void takeHistorySnapshot() {
        throw new RuntimeException("Not implemented!");
    }
}

