/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.graphicsDescription;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;

public class MeshDataGenerator {
    private static final float TwoPi = (float)Math.PI * 2;
    private static final float HalfPi = 1.5707964f;
    private static final float SQRT3 = (float)Math.sqrt(3.0);
    private static final float SQRT6 = (float)Math.sqrt(6.0);
    private static final float HALF_SQRT3 = SQRT3 / 2.0f;
    private static final float THIRD_SQRT3 = SQRT3 / 3.0f;
    private static final float FOURTH_SQRT3 = SQRT3 / 4.0f;
    private static final float SIXTH_SQRT3 = SQRT3 / 6.0f;
    private static final float THIRD_SQRT6 = SQRT6 / 3.0f;
    private static final float FOURTH_SQRT6 = SQRT6 / 4.0f;
    private static final float ONE_THIRD = 0.33333334f;
    private static final float TETRAHEDRON_FACE_EDGE_FACE_ANGLE = (float)Math.acos(0.3333333432674408);
    private static final float TETRAHEDRON_SINE_FACE_EDGE_FACE_ANGLE = (float)Math.sin(TETRAHEDRON_FACE_EDGE_FACE_ANGLE);

    private MeshDataGenerator() {
    }

    public static MeshDataHolder Sphere(double radius, int latitudeN, int longitudeN) {
        return MeshDataGenerator.Sphere((float)radius, latitudeN, longitudeN);
    }

    public static MeshDataHolder Sphere(float radius, int latitudeN, int longitudeN) {
        return MeshDataGenerator.Ellipsoid(radius, radius, radius, latitudeN, longitudeN);
    }

    public static MeshDataHolder Ellipsoid(double xRadius, double yRadius, double zRadius, int latitudeN, int longitudeN) {
        return MeshDataGenerator.Ellipsoid((float)xRadius, (float)yRadius, (float)zRadius, latitudeN, longitudeN);
    }

    public static MeshDataHolder Ellipsoid(float xRadius, float yRadius, float zRadius, int latitudeN, int longitudeN) {
        Point3D32[] points = new Point3D32[(latitudeN - 1) * longitudeN + 2];
        Vector3D32[] normals = new Vector3D32[(latitudeN - 1) * longitudeN + 2];
        TexCoord2f[] textPoints = new TexCoord2f[(latitudeN - 1) * longitudeN + 2];
        for (int longitudeIndex = 0; longitudeIndex < longitudeN; ++longitudeIndex) {
            float longitudeAngle = (float)Math.PI * 2 * ((float)longitudeIndex / (float)longitudeN);
            float cosLongitude = (float)Math.cos(longitudeAngle);
            float sinLongitude = (float)Math.sin(longitudeAngle);
            for (int latitudeIndex = 1; latitudeIndex < latitudeN; ++latitudeIndex) {
                float latitudeAngle = (float)(-1.5707963705062866 + Math.PI * (double)((float)latitudeIndex / (float)latitudeN));
                float cosLatitude = (float)Math.cos(latitudeAngle);
                float sinLatitude = (float)Math.sin(latitudeAngle);
                int currentIndex = (latitudeIndex - 1) * longitudeN + longitudeIndex;
                float normalX = cosLongitude * cosLatitude;
                float normalY = sinLongitude * cosLatitude;
                float normalZ = sinLatitude;
                float vertexX = xRadius * normalX;
                float vertexY = yRadius * normalY;
                float vertexZ = zRadius * normalZ;
                points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
                normals[currentIndex] = new Vector3D32(normalX, normalY, normalZ);
                float textureX = longitudeAngle / ((float)Math.PI * 2);
                float textureY = (float)(0.5 * (double)sinLatitude + 0.5);
                textPoints[currentIndex] = new TexCoord2f(textureX, textureY);
            }
        }
        int southPoleIndex = (latitudeN - 1) * longitudeN;
        points[southPoleIndex] = new Point3D32(0.0f, 0.0f, -zRadius);
        normals[southPoleIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[southPoleIndex] = new TexCoord2f(0.5f, 0.0f);
        int northPoleIndex = (latitudeN - 1) * longitudeN + 1;
        points[northPoleIndex] = new Point3D32(0.0f, 0.0f, zRadius);
        normals[northPoleIndex] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[northPoleIndex] = new TexCoord2f(1.0f, 1.0f);
        int numberOfTriangles = 2 * (latitudeN - 1) * longitudeN + 2 * longitudeN;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int latitudeIndex = 0; latitudeIndex < latitudeN - 2; ++latitudeIndex) {
            for (int longitudeIndex = 0; longitudeIndex < longitudeN; ++longitudeIndex) {
                int nextLongitudeIndex = (longitudeIndex + 1) % longitudeN;
                int nextLatitudeIndex = latitudeIndex + 1;
                triangleIndices[index++] = latitudeIndex * longitudeN + longitudeIndex;
                triangleIndices[index++] = latitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + longitudeIndex;
                triangleIndices[index++] = latitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + longitudeIndex;
            }
        }
        int longitudeIndex = 0;
        while (longitudeIndex < longitudeN) {
            int nextLongitudeIndex = (longitudeIndex + 1) % longitudeN;
            triangleIndices[index++] = southPoleIndex;
            triangleIndices[index++] = nextLongitudeIndex;
            triangleIndices[index++] = longitudeIndex++;
        }
        for (longitudeIndex = 0; longitudeIndex < longitudeN; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % longitudeN;
            triangleIndices[index++] = northPoleIndex;
            triangleIndices[index++] = (latitudeN - 2) * longitudeN + longitudeIndex;
            triangleIndices[index++] = (latitudeN - 2) * longitudeN + nextLongitudeIndex;
        }
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder Polygon(List<? extends Point3DReadOnly> ccwOrderedConvexPolygonPoints) {
        return MeshDataGenerator.Polygon(ccwOrderedConvexPolygonPoints, ccwOrderedConvexPolygonPoints.size());
    }

    public static MeshDataHolder Polygon(List<? extends Point3DReadOnly> ccwOrderedConvexPolygonPoints, int numberOfVertices) {
        Point3D32[] points = new Point3D32[numberOfVertices];
        for (int i = 0; i < numberOfVertices; ++i) {
            points[i] = new Point3D32((Tuple3DReadOnly)ccwOrderedConvexPolygonPoints.get(i));
        }
        return MeshDataGenerator.Polygon((Point3DReadOnly[])points);
    }

    public static MeshDataHolder Polygon(Point2DReadOnly ... ccwOrderedConvexPolygonPoints) {
        Point3D32[] points = new Point3D32[ccwOrderedConvexPolygonPoints.length];
        for (int i = 0; i < ccwOrderedConvexPolygonPoints.length; ++i) {
            Point2DReadOnly vertex = ccwOrderedConvexPolygonPoints[i];
            points[i] = new Point3D32((float)vertex.getX(), (float)vertex.getY(), 0.0f);
        }
        return MeshDataGenerator.Polygon((Point3DReadOnly[])points);
    }

    public static MeshDataHolder Polygon(RigidBodyTransformReadOnly polygonTransformToWorld, List<? extends Point2DReadOnly> ccwOrderedConvexPolygonPoints) {
        Point3D32[] points = new Point3D32[ccwOrderedConvexPolygonPoints.size()];
        int reverseIndex = ccwOrderedConvexPolygonPoints.size();
        for (int i = 0; i < ccwOrderedConvexPolygonPoints.size(); ++i) {
            Point2DReadOnly vertex = ccwOrderedConvexPolygonPoints.get(--reverseIndex);
            points[i] = new Point3D32(vertex.getX32(), vertex.getY32(), 0.0f);
            polygonTransformToWorld.transform((Point3DBasics)points[i]);
        }
        return MeshDataGenerator.Polygon((Point3DReadOnly[])points);
    }

    public static MeshDataHolder Polygon(ConvexPolygon2DReadOnly convexPolygon) {
        Point3D32[] points = new Point3D32[convexPolygon.getNumberOfVertices()];
        int reverseIndex = convexPolygon.getNumberOfVertices();
        for (int i = 0; i < convexPolygon.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon.getVertexBufferView().get(--reverseIndex);
            points[i] = new Point3D32((float)vertex.getX(), (float)vertex.getY(), 0.0f);
        }
        return MeshDataGenerator.Polygon((Point3DReadOnly[])points);
    }

    public static MeshDataHolder Polygon(RigidBodyTransformReadOnly polygonTransformToWorld, ConvexPolygon2DReadOnly convexPolygon) {
        Point3D32[] points = new Point3D32[convexPolygon.getNumberOfVertices()];
        int reverseIndex = convexPolygon.getNumberOfVertices();
        for (int i = 0; i < convexPolygon.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon.getVertexBufferView().get(--reverseIndex);
            points[i] = new Point3D32((float)vertex.getX(), (float)vertex.getY(), 0.0f);
            polygonTransformToWorld.transform((Point3DBasics)points[i]);
        }
        return MeshDataGenerator.Polygon((Point3DReadOnly[])points);
    }

    public static MeshDataHolder Polygon(Point3DReadOnly ... ccwOrderedConvexPolygonPoints) {
        Point3D32[] vertices = MeshDataGenerator.makePoint3fArrayFromPoint3dArray(ccwOrderedConvexPolygonPoints);
        int numberOfTriangles = vertices.length - 2;
        if (numberOfTriangles <= 0) {
            return null;
        }
        TexCoord2f[] textPoints = MeshDataGenerator.generateInterpolatedTexturePoints(vertices.length);
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        int j = 2;
        while (j < vertices.length) {
            triangleIndices[index++] = 0;
            triangleIndices[index++] = j - 1;
            triangleIndices[index++] = j++;
        }
        Vector3D32[] normals = MeshDataGenerator.findNormalsPerVertex(triangleIndices, (Point3DReadOnly[])vertices);
        return new MeshDataHolder(vertices, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder ExtrudedPolygon(ConvexPolygon2DReadOnly convexPolygon2d, double extrusionHeight) {
        Point2D[] points = new Point2D[convexPolygon2d.getNumberOfVertices()];
        int reverseIndex = convexPolygon2d.getNumberOfVertices();
        for (int i = 0; i < convexPolygon2d.getNumberOfVertices(); ++i) {
            points[i] = new Point2D((Tuple2DReadOnly)convexPolygon2d.getVertexBufferView().get(--reverseIndex));
        }
        return MeshDataGenerator.ExtrudedPolygon((Point2DReadOnly[])points, extrusionHeight);
    }

    public static MeshDataHolder ExtrudedPolygon(List<? extends Point2DReadOnly> ccwOrderedConvexPolygonPoints, double extrusionHeight) {
        Point2D[] points = new Point2D[ccwOrderedConvexPolygonPoints.size()];
        int i = 0;
        for (Point2DReadOnly point2DReadOnly : ccwOrderedConvexPolygonPoints) {
            points[i++] = new Point2D((Tuple2DReadOnly)point2DReadOnly);
        }
        return MeshDataGenerator.ExtrudedPolygon((Point2DReadOnly[])points, extrusionHeight);
    }

    public static MeshDataHolder ExtrudedPolygon(Point2DReadOnly[] ccwOrderedConvexPolygonPoints, double extrusionHeight) {
        return MeshDataGenerator.ExtrudedPolygon(ccwOrderedConvexPolygonPoints, extrusionHeight, 0.0);
    }

    public static MeshDataHolder ExtrudedPolygon(Point2DReadOnly[] ccwOrderedConvexPolygonPoints, double extrusionHeight, double heightOffset) {
        int i;
        if (ccwOrderedConvexPolygonPoints == null || ccwOrderedConvexPolygonPoints.length == 0) {
            return null;
        }
        if (extrusionHeight < 0.0) {
            heightOffset += extrusionHeight;
            extrusionHeight = -extrusionHeight;
        }
        int N = ccwOrderedConvexPolygonPoints.length;
        Point3D32[] vertices = new Point3D32[4 * N];
        Vector3D32[] normals = new Vector3D32[4 * N];
        TexCoord2f[] texturePoints = new TexCoord2f[4 * N];
        Point2D average = new Point2D();
        for (Point2DReadOnly polygonPoint : ccwOrderedConvexPolygonPoints) {
            average.add((Tuple2DReadOnly)polygonPoint);
        }
        average.scale(1.0 / (double)N);
        for (int i2 = 0; i2 < N; ++i2) {
            float vertexX = (float)ccwOrderedConvexPolygonPoints[i2].getX();
            float vertexY = (float)ccwOrderedConvexPolygonPoints[i2].getY();
            float normalX = vertexX - (float)average.getX();
            float normalY = vertexY - (float)average.getY();
            float normalLength = (float)Math.sqrt(normalX * normalX + normalY * normalY);
            normalX /= normalLength;
            normalY /= normalLength;
            vertices[i2] = new Point3D32(vertexX, vertexY, (float)heightOffset);
            normals[i2] = new Vector3D32(0.0f, 0.0f, -1.0f);
            texturePoints[i2] = new TexCoord2f();
            vertices[i2 + N] = new Point3D32(vertexX, vertexY, (float)(extrusionHeight + heightOffset));
            normals[i2 + N] = new Vector3D32(0.0f, 0.0f, 1.0f);
            texturePoints[i2 + N] = new TexCoord2f();
            vertices[i2 + 2 * N] = new Point3D32(vertexX, vertexY, (float)heightOffset);
            normals[i2 + 2 * N] = new Vector3D32(normalX, normalY, 0.0f);
            texturePoints[i2 + 2 * N] = new TexCoord2f();
            vertices[i2 + 3 * N] = new Point3D32(vertexX, vertexY, (float)(extrusionHeight + heightOffset));
            normals[i2 + 3 * N] = new Vector3D32(normalX, normalY, 0.0f);
            texturePoints[i2 + 3 * N] = new TexCoord2f();
        }
        int numberOfTriangles = 4 * N - 2;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (i = 1; i < N; ++i) {
            triangleIndices[index++] = (i + 1) % N;
            triangleIndices[index++] = i;
            triangleIndices[index++] = 0;
            triangleIndices[index++] = N;
            triangleIndices[index++] = i + N;
            triangleIndices[index++] = (i + 1) % N + N;
        }
        for (i = 0; i < N; ++i) {
            triangleIndices[index++] = i + 2 * N;
            triangleIndices[index++] = (i + 1) % N + 2 * N;
            triangleIndices[index++] = i + 3 * N;
            triangleIndices[index++] = (i + 1) % N + 2 * N;
            triangleIndices[index++] = (i + 1) % N + 3 * N;
            triangleIndices[index++] = i + 3 * N;
        }
        return new MeshDataHolder(vertices, texturePoints, triangleIndices, normals);
    }

    public static MeshDataHolder HemiEllipsoid(double xRadius, double yRadius, double zRadius, int latitudeN, int longitudeN) {
        return MeshDataGenerator.HemiEllipsoid((float)xRadius, (float)yRadius, (float)zRadius, latitudeN, longitudeN);
    }

    public static MeshDataHolder HemiEllipsoid(float xRadius, float yRadius, float zRadius, int latitudeN, int longitudeN) {
        int longitudeIndex;
        float longitudeAngle;
        int longitudeIndex2;
        Point3D32[] points = new Point3D32[(latitudeN + 1) * longitudeN + 2];
        Vector3D32[] normals = new Vector3D32[(latitudeN + 1) * longitudeN + 2];
        TexCoord2f[] textPoints = new TexCoord2f[(latitudeN + 1) * longitudeN + 2];
        for (longitudeIndex2 = 0; longitudeIndex2 < longitudeN; ++longitudeIndex2) {
            longitudeAngle = (float)Math.PI * 2 * ((float)longitudeIndex2 / (float)longitudeN);
            for (int latitudeIndex = 0; latitudeIndex < latitudeN; ++latitudeIndex) {
                float latitudeAngle = 1.5707964f * ((float)latitudeIndex / (float)latitudeN);
                float cosLongitude = (float)Math.cos(longitudeAngle);
                float sinLongitude = (float)Math.sin(longitudeAngle);
                float cosLatitude = (float)Math.cos(latitudeAngle);
                float sinLatitude = (float)Math.sin(latitudeAngle);
                int currentIndex = latitudeIndex * longitudeN + longitudeIndex2;
                float normalX = cosLongitude * cosLatitude;
                float normalY = sinLongitude * cosLatitude;
                float normalZ = sinLatitude;
                float vertexX = xRadius * normalX;
                float vertexY = yRadius * normalY;
                float vertexZ = zRadius * normalZ;
                points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
                normals[currentIndex] = new Vector3D32(normalX, normalY, normalZ);
                float textureX = longitudeAngle / ((float)Math.PI * 2);
                float textureY = (float)(0.5 * (double)sinLatitude + 0.5);
                textPoints[currentIndex] = new TexCoord2f(textureX, textureY);
            }
        }
        for (longitudeIndex2 = 0; longitudeIndex2 < longitudeN; ++longitudeIndex2) {
            longitudeAngle = (float)Math.PI * 2 * ((float)longitudeIndex2 / (float)longitudeN);
            int currentIndex = latitudeN * longitudeN + longitudeIndex2;
            float vertexX = (float)((double)xRadius * Math.cos(longitudeAngle));
            float vertexY = (float)((double)yRadius * Math.sin(longitudeAngle));
            float vertexZ = 0.0f;
            points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
            normals[currentIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
            float textureX = longitudeAngle / ((float)Math.PI * 2);
            textPoints[currentIndex] = new TexCoord2f(textureX, 0.5f);
        }
        int northPoleIndex = (latitudeN + 1) * longitudeN;
        points[northPoleIndex] = new Point3D32(0.0f, 0.0f, zRadius);
        normals[northPoleIndex] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[northPoleIndex] = new TexCoord2f(1.0f, 1.0f);
        int bottomCenterIndex = (latitudeN + 1) * longitudeN + 1;
        points[bottomCenterIndex] = new Point3D32(0.0f, 0.0f, 0.0f);
        normals[bottomCenterIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[bottomCenterIndex] = new TexCoord2f(0.5f, 0.5f);
        int numberOfTriangles = 2 * latitudeN * longitudeN + 2 * longitudeN;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int latitudeIndex = 0; latitudeIndex < latitudeN - 1; ++latitudeIndex) {
            for (int longitudeIndex3 = 0; longitudeIndex3 < longitudeN; ++longitudeIndex3) {
                int nextLongitudeIndex = (longitudeIndex3 + 1) % longitudeN;
                int nextLatitudeIndex = latitudeIndex + 1;
                triangleIndices[index++] = latitudeIndex * longitudeN + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + longitudeIndex3;
            }
        }
        for (longitudeIndex = 0; longitudeIndex < longitudeN; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % longitudeN;
            triangleIndices[index++] = northPoleIndex;
            triangleIndices[index++] = (latitudeN - 1) * longitudeN + longitudeIndex;
            triangleIndices[index++] = (latitudeN - 1) * longitudeN + nextLongitudeIndex;
        }
        for (longitudeIndex = 0; longitudeIndex < longitudeN; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % longitudeN;
            triangleIndices[index++] = latitudeN * longitudeN + nextLongitudeIndex;
            triangleIndices[index++] = latitudeN * longitudeN + longitudeIndex;
            triangleIndices[index++] = bottomCenterIndex;
        }
        int[] pStripCounts = new int[numberOfTriangles];
        Arrays.fill(pStripCounts, 3);
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder Cylinder(double radius, double height, int N) {
        return MeshDataGenerator.Cylinder((float)radius, (float)height, N);
    }

    public static MeshDataHolder Cylinder(float radius, float height, int N) {
        Point3D32[] points = new Point3D32[4 * N + 2];
        Vector3D32[] normals = new Vector3D32[4 * N + 2];
        TexCoord2f[] textPoints = new TexCoord2f[4 * N + 2];
        for (int i = 0; i < N; ++i) {
            double angle = (float)i * ((float)Math.PI * 2) / (float)N;
            float cosAngle = (float)Math.cos(angle);
            float sinAngle = (float)Math.sin(angle);
            float vertexX = radius * cosAngle;
            float vertexY = radius * sinAngle;
            points[i] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[i] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i + N] = new Point3D32(vertexX, vertexY, height);
            normals[i + N] = new Vector3D32(0.0f, 0.0f, 1.0f);
            textPoints[i + N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i + 2 * N] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i + 2 * N] = new Vector3D32(cosAngle, sinAngle, 0.0f);
            textPoints[i + 2 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i + 3 * N] = new Point3D32(vertexX, vertexY, height);
            normals[i + 3 * N] = new Vector3D32(cosAngle, sinAngle, 0.0f);
            textPoints[i + 3 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
        }
        points[4 * N] = new Point3D32(0.0f, 0.0f, 0.0f);
        normals[4 * N] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[4 * N] = new TexCoord2f(0.5f, 0.5f);
        points[4 * N + 1] = new Point3D32(0.0f, 0.0f, height);
        normals[4 * N + 1] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[4 * N + 1] = new TexCoord2f(0.5f, 0.5f);
        int numberOfTriangles = 4 * N;
        int[] triangleIndices = new int[6 * numberOfTriangles];
        int index = 0;
        int i = 0;
        while (i < N) {
            triangleIndices[index++] = (i + 1) % N;
            triangleIndices[index++] = i++;
            triangleIndices[index++] = 4 * N;
        }
        for (i = 0; i < N; ++i) {
            triangleIndices[index++] = 4 * N + 1;
            triangleIndices[index++] = i + N;
            triangleIndices[index++] = (i + 1) % N + N;
        }
        for (i = 0; i < N; ++i) {
            triangleIndices[index++] = i + 2 * N;
            triangleIndices[index++] = (i + 1) % N + 2 * N;
            triangleIndices[index++] = i + 3 * N;
            triangleIndices[index++] = (i + 1) % N + 2 * N;
            triangleIndices[index++] = (i + 1) % N + 3 * N;
            triangleIndices[index++] = i + 3 * N;
        }
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder Cone(double height, double radius, int N) {
        return MeshDataGenerator.Cone((float)height, (float)radius, N);
    }

    public static MeshDataHolder Cone(float height, float radius, int N) {
        Point3D32[] vertices = new Point3D32[3 * N + 1];
        Vector3D32[] normals = new Vector3D32[3 * N + 1];
        TexCoord2f[] textureCoordinates = new TexCoord2f[3 * N + 1];
        float slopeAngle = (float)Math.atan2(radius, height);
        float cosSlopeAngle = (float)Math.cos(slopeAngle);
        float sinSlopeAngle = (float)Math.sin(slopeAngle);
        for (int i = 0; i < N; ++i) {
            double angle = (float)i * ((float)Math.PI * 2) / (float)N;
            float cosAngle = (float)Math.cos(angle);
            float sinAngle = (float)Math.sin(angle);
            float vertexX = radius * cosAngle;
            float vertexY = radius * sinAngle;
            vertices[i] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textureCoordinates[i] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            vertices[i + N] = new Point3D32(vertexX, vertexY, 0.0f);
            normals[i + N] = new Vector3D32(cosSlopeAngle * cosAngle, cosSlopeAngle * sinAngle, sinSlopeAngle);
            textureCoordinates[i + N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            vertices[i + 2 * N] = new Point3D32(0.0f, 0.0f, height);
            normals[i + 2 * N] = new Vector3D32(cosSlopeAngle * cosAngle, cosSlopeAngle * sinAngle, sinSlopeAngle);
            textureCoordinates[i + 2 * N] = new TexCoord2f(0.5f, 0.5f);
        }
        int bottomCenterIndex = 3 * N;
        vertices[bottomCenterIndex] = new Point3D32(0.0f, 0.0f, 0.0f);
        normals[bottomCenterIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textureCoordinates[bottomCenterIndex] = new TexCoord2f(0.5f, 0.5f);
        int numberOfTriangles = 2 * N;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int i = 0; i < N; ++i) {
            triangleIndices[index++] = bottomCenterIndex;
            triangleIndices[index++] = (i + 1) % N;
            triangleIndices[index++] = i;
            triangleIndices[index++] = i + N;
            triangleIndices[index++] = (i + 1) % N + N;
            triangleIndices[index++] = i + 2 * N;
        }
        return new MeshDataHolder(vertices, textureCoordinates, triangleIndices, normals);
    }

    public static MeshDataHolder GenTruncatedCone(double height, double xBaseRadius, double yBaseRadius, double xTopRadius, double yTopRadius, int N) {
        return MeshDataGenerator.GenTruncatedCone((float)height, (float)xBaseRadius, (float)yBaseRadius, (float)xTopRadius, (float)yTopRadius, N);
    }

    public static MeshDataHolder GenTruncatedCone(float height, float xBaseRadius, float yBaseRadius, float xTopRadius, float yTopRadius, int N) {
        Point3D32[] points = new Point3D32[4 * N + 2];
        Vector3D32[] normals = new Vector3D32[4 * N + 2];
        TexCoord2f[] textPoints = new TexCoord2f[4 * N + 2];
        for (int i = 0; i < N; ++i) {
            double angle = (float)i * ((float)Math.PI * 2) / (float)N;
            float cosAngle = (float)Math.cos(angle);
            float sinAngle = (float)Math.sin(angle);
            float baseX = xBaseRadius * cosAngle;
            float baseY = yBaseRadius * sinAngle;
            float topX = xTopRadius * cosAngle;
            float topY = yTopRadius * sinAngle;
            points[i] = new Point3D32(baseX, baseY, 0.0f);
            normals[i] = new Vector3D32(0.0f, 0.0f, -1.0f);
            textPoints[i] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i + N] = new Point3D32(topX, topY, height);
            normals[i + N] = new Vector3D32(0.0f, 0.0f, 1.0f);
            textPoints[i + N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            float currentBaseRadius = (float)Math.sqrt(baseX * baseX + baseY * baseY);
            float currentTopRadius = (float)Math.sqrt(topX * topX + topY * topY);
            float openingAngle = (float)Math.atan((currentBaseRadius - currentTopRadius) / height);
            float baseAngle = (float)Math.atan2(baseY, baseX);
            float topAngle = (float)Math.atan2(topY, topX);
            points[i + 2 * N] = new Point3D32(baseX, baseY, 0.0f);
            normals[i + 2 * N] = new Vector3D32((float)(Math.cos(baseAngle) * Math.cos(openingAngle)), (float)(Math.sin(baseAngle) * Math.cos(openingAngle)), (float)Math.sin(openingAngle));
            textPoints[i + 2 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
            points[i + 3 * N] = new Point3D32(topX, topY, height);
            normals[i + 3 * N] = new Vector3D32((float)(Math.cos(topAngle) * Math.cos(openingAngle)), (float)(Math.sin(topAngle) * Math.cos(openingAngle)), (float)Math.sin(openingAngle));
            textPoints[i + 3 * N] = new TexCoord2f(0.5f * cosAngle + 0.5f, 0.5f * sinAngle + 0.5f);
        }
        points[4 * N] = new Point3D32(0.0f, 0.0f, 0.0f);
        normals[4 * N] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[4 * N] = new TexCoord2f(0.5f, 0.5f);
        points[4 * N + 1] = new Point3D32(0.0f, 0.0f, height);
        normals[4 * N + 1] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[4 * N + 1] = new TexCoord2f(0.5f, 0.5f);
        int numberOfTriangles = 4 * N;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int i = 0; i < N; ++i) {
            triangleIndices[index++] = 4 * N;
            triangleIndices[index++] = (i + 1) % N;
            triangleIndices[index++] = i;
            triangleIndices[index++] = 4 * N + 1;
            triangleIndices[index++] = i + N;
            triangleIndices[index++] = (i + 1) % N + N;
            triangleIndices[index++] = i + 2 * N;
            triangleIndices[index++] = (i + 1) % N + 2 * N;
            triangleIndices[index++] = i + 3 * N;
            triangleIndices[index++] = (i + 1) % N + 2 * N;
            triangleIndices[index++] = (i + 1) % N + 3 * N;
            triangleIndices[index++] = i + 3 * N;
        }
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder ArcTorus(double startAngle, double endAngle, double majorRadius, double minorRadius, int N) {
        return MeshDataGenerator.ArcTorus((float)startAngle, (float)endAngle, (float)majorRadius, (float)minorRadius, N);
    }

    public static MeshDataHolder ArcTorus(float startAngle, float endAngle, float majorRadius, float minorRadius, int N) {
        float texX;
        float pZ;
        float pY;
        float pX;
        float centerY;
        float centerX;
        float torusSpanAngle = endAngle - startAngle;
        boolean isClosed = MathTools.epsilonEquals((double)torusSpanAngle, (double)6.2831854820251465, (double)0.001);
        int majorN = N;
        int minorN = N;
        float stepAngle = (endAngle - startAngle) / (float)(isClosed ? majorN : majorN - 1);
        int numberOfVertices = isClosed ? majorN * minorN : majorN * minorN + 2 * (N + 1);
        Point3D32[] points = new Point3D32[numberOfVertices];
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        TexCoord2f[] textPoints = new TexCoord2f[numberOfVertices];
        for (int majorIndex = 0; majorIndex < majorN; ++majorIndex) {
            float majorAngle = startAngle + (float)majorIndex * stepAngle;
            float cosMajorAngle = (float)Math.cos(majorAngle);
            float sinMajorAngle = (float)Math.sin(majorAngle);
            centerX = majorRadius * cosMajorAngle;
            centerY = majorRadius * sinMajorAngle;
            float texY = (float)majorIndex / (float)majorN;
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int currentIndex = majorIndex * minorN + minorIndex;
                float minorAngle = (float)minorIndex * 2.0f * (float)Math.PI / (float)minorN;
                float cosMinorAngle = (float)Math.cos(minorAngle);
                float sinMinorAngle = (float)Math.sin(minorAngle);
                pX = centerX + minorRadius * cosMajorAngle * cosMinorAngle;
                pY = centerY + minorRadius * sinMajorAngle * cosMinorAngle;
                pZ = minorRadius * sinMinorAngle;
                points[currentIndex] = new Point3D32(pX, pY, pZ);
                normals[currentIndex] = new Vector3D32(cosMajorAngle * cosMinorAngle, sinMajorAngle * cosMinorAngle, sinMinorAngle);
                texX = (float)minorIndex / (float)minorN;
                textPoints[currentIndex] = new TexCoord2f(texX, texY);
            }
        }
        int lastMajorIndex = isClosed ? majorN : majorN - 1;
        int numberOfTriangles = 2 * lastMajorIndex * minorN;
        if (!isClosed) {
            numberOfTriangles += 2 * minorN;
        }
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (int majorIndex = 0; majorIndex < lastMajorIndex; ++majorIndex) {
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int nextMajorIndex = (majorIndex + 1) % majorN;
                int nextMinorIndex = (minorIndex + 1) % minorN;
                triangleIndices[index++] = nextMajorIndex * minorN + minorIndex;
                triangleIndices[index++] = nextMajorIndex * minorN + nextMinorIndex;
                triangleIndices[index++] = majorIndex * minorN + nextMinorIndex;
                triangleIndices[index++] = nextMajorIndex * minorN + minorIndex;
                triangleIndices[index++] = majorIndex * minorN + nextMinorIndex;
                triangleIndices[index++] = majorIndex * minorN + minorIndex;
            }
        }
        if (!isClosed) {
            float cosStartAngle = (float)Math.cos(startAngle);
            float sinStartAngle = (float)Math.sin(startAngle);
            centerX = majorRadius * cosStartAngle;
            centerY = majorRadius * sinStartAngle;
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int currentIndex = majorN * minorN + minorIndex;
                float minorAngle = (float)minorIndex * 2.0f * (float)Math.PI / (float)minorN;
                float cosMinorAngle = (float)Math.cos(minorAngle);
                float sinMinorAngle = (float)Math.sin(minorAngle);
                pX = centerX + minorRadius * cosStartAngle * cosMinorAngle;
                pY = centerY + minorRadius * sinStartAngle * cosMinorAngle;
                pZ = minorRadius * sinMinorAngle;
                points[currentIndex] = new Point3D32(pX, pY, pZ);
                normals[currentIndex] = new Vector3D32(sinStartAngle, -cosStartAngle, 0.0f);
                texX = (float)minorIndex / (float)minorN;
                textPoints[currentIndex] = new TexCoord2f(texX, 0.0f);
            }
            int firstEndCenterIndex = numberOfVertices - 2;
            points[firstEndCenterIndex] = new Point3D32(centerX, centerY, 0.0f);
            normals[firstEndCenterIndex] = new Vector3D32(sinStartAngle, -cosStartAngle, 0.0f);
            textPoints[firstEndCenterIndex] = new TexCoord2f(0.0f, 0.0f);
            float cosEndAngle = (float)Math.cos(endAngle);
            float sinEndAngle = (float)Math.sin(endAngle);
            centerX = majorRadius * cosEndAngle;
            centerY = majorRadius * sinEndAngle;
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int currentIndex = (majorN + 1) * minorN + minorIndex;
                float minorAngle = (float)minorIndex * 2.0f * (float)Math.PI / (float)minorN;
                float cosMinorAngle = (float)Math.cos(minorAngle);
                float sinMinorAngle = (float)Math.sin(minorAngle);
                pX = centerX + minorRadius * cosEndAngle * cosMinorAngle;
                pY = centerY + minorRadius * sinEndAngle * cosMinorAngle;
                pZ = minorRadius * sinMinorAngle;
                points[currentIndex] = new Point3D32(pX, pY, pZ);
                normals[currentIndex] = new Vector3D32(-sinEndAngle, cosEndAngle, 0.0f);
                texX = (float)minorIndex / (float)minorN;
                textPoints[currentIndex] = new TexCoord2f(texX, 1.0f);
            }
            int secondEndCenterIndex = numberOfVertices - 1;
            points[secondEndCenterIndex] = new Point3D32(centerX, centerY, 0.0f);
            normals[secondEndCenterIndex] = new Vector3D32(-sinEndAngle, cosEndAngle, 0.0f);
            textPoints[secondEndCenterIndex] = new TexCoord2f(0.0f, 1.0f);
            for (int minorIndex = 0; minorIndex < minorN; ++minorIndex) {
                int nextMinorIndex = (minorIndex + 1) % minorN;
                triangleIndices[index++] = firstEndCenterIndex;
                triangleIndices[index++] = majorN * minorN + minorIndex;
                triangleIndices[index++] = majorN * minorN + nextMinorIndex;
                triangleIndices[index++] = secondEndCenterIndex;
                triangleIndices[index++] = (majorN + 1) * minorN + nextMinorIndex;
                triangleIndices[index++] = (majorN + 1) * minorN + minorIndex;
            }
        }
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder Cube(double lx, double ly, double lz, boolean centered) {
        return MeshDataGenerator.Cube(lx, ly, lz, centered, null);
    }

    public static MeshDataHolder Cube(double lx, double ly, double lz, boolean centered, boolean[] textureFaces) {
        return MeshDataGenerator.Cube((float)lx, (float)ly, (float)lz, centered, textureFaces);
    }

    public static MeshDataHolder Cube(float lx, float ly, float lz, boolean centered, boolean[] textureFaces) {
        Point3D32[] points = new Point3D32[24];
        Vector3D32[] normals = new Vector3D32[24];
        TexCoord2f[] textPoints = new TexCoord2f[24];
        float za = centered ? -lz / 2.0f : 0.0f;
        float zb = centered ? lz / 2.0f : lz;
        points[0] = new Point3D32(-lx / 2.0f, -ly / 2.0f, za);
        normals[0] = new Vector3D32(0.0f, 0.0f, -1.0f);
        points[1] = new Point3D32(lx / 2.0f, -ly / 2.0f, za);
        normals[1] = new Vector3D32(0.0f, 0.0f, -1.0f);
        points[2] = new Point3D32(lx / 2.0f, ly / 2.0f, za);
        normals[2] = new Vector3D32(0.0f, 0.0f, -1.0f);
        points[3] = new Point3D32(-lx / 2.0f, ly / 2.0f, za);
        normals[3] = new Vector3D32(0.0f, 0.0f, -1.0f);
        points[4] = new Point3D32(-lx / 2.0f, -ly / 2.0f, zb);
        normals[4] = new Vector3D32(0.0f, 0.0f, 1.0f);
        points[5] = new Point3D32(lx / 2.0f, -ly / 2.0f, zb);
        normals[5] = new Vector3D32(0.0f, 0.0f, 1.0f);
        points[6] = new Point3D32(lx / 2.0f, ly / 2.0f, zb);
        normals[6] = new Vector3D32(0.0f, 0.0f, 1.0f);
        points[7] = new Point3D32(-lx / 2.0f, ly / 2.0f, zb);
        normals[7] = new Vector3D32(0.0f, 0.0f, 1.0f);
        points[8] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[8] = new Vector3D32(0.0f, 1.0f, 0.0f);
        points[9] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[9] = new Vector3D32(0.0f, 1.0f, 0.0f);
        points[10] = new Point3D32((Tuple3DReadOnly)points[6]);
        normals[10] = new Vector3D32(0.0f, 1.0f, 0.0f);
        points[11] = new Point3D32((Tuple3DReadOnly)points[7]);
        normals[11] = new Vector3D32(0.0f, 1.0f, 0.0f);
        points[12] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[12] = new Vector3D32(0.0f, -1.0f, 0.0f);
        points[13] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[13] = new Vector3D32(0.0f, -1.0f, 0.0f);
        points[14] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[14] = new Vector3D32(0.0f, -1.0f, 0.0f);
        points[15] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[15] = new Vector3D32(0.0f, -1.0f, 0.0f);
        points[16] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[16] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        points[17] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[17] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        points[18] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[18] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        points[19] = new Point3D32((Tuple3DReadOnly)points[7]);
        normals[19] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        points[20] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[20] = new Vector3D32(1.0f, 0.0f, 0.0f);
        points[21] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[21] = new Vector3D32(1.0f, 0.0f, 0.0f);
        points[22] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[22] = new Vector3D32(1.0f, 0.0f, 0.0f);
        points[23] = new Point3D32((Tuple3DReadOnly)points[6]);
        normals[23] = new Vector3D32(1.0f, 0.0f, 0.0f);
        if (textureFaces == null || textureFaces[0]) {
            textPoints[0] = new TexCoord2f(0.0f, 0.0f);
            textPoints[1] = new TexCoord2f(0.0f, 1.0f);
            textPoints[2] = new TexCoord2f(1.0f, 1.0f);
            textPoints[3] = new TexCoord2f(1.0f, 0.0f);
        } else {
            textPoints[0] = new TexCoord2f(0.0f, 0.0f);
            textPoints[1] = new TexCoord2f(0.0f, 0.0f);
            textPoints[2] = new TexCoord2f(0.0f, 0.0f);
            textPoints[3] = new TexCoord2f(0.0f, 0.0f);
        }
        if (textureFaces == null || textureFaces[1]) {
            textPoints[7] = new TexCoord2f(0.0f, 0.0f);
            textPoints[4] = new TexCoord2f(1.0f, 0.0f);
            textPoints[5] = new TexCoord2f(1.0f, 1.0f);
            textPoints[6] = new TexCoord2f(0.0f, 1.0f);
        } else {
            textPoints[7] = new TexCoord2f(0.0f, 0.0f);
            textPoints[4] = new TexCoord2f(0.0f, 0.0f);
            textPoints[5] = new TexCoord2f(0.0f, 0.0f);
            textPoints[6] = new TexCoord2f(0.0f, 0.0f);
        }
        if (textureFaces == null || textureFaces[2]) {
            textPoints[8] = new TexCoord2f(0.0f, 0.0f);
            textPoints[9] = new TexCoord2f(1.0f, 0.0f);
            textPoints[10] = new TexCoord2f(0.0f, 1.0f);
            textPoints[11] = new TexCoord2f(1.0f, 1.0f);
        } else {
            textPoints[8] = new TexCoord2f(0.0f, 0.0f);
            textPoints[9] = new TexCoord2f(0.0f, 0.0f);
            textPoints[10] = new TexCoord2f(0.0f, 0.0f);
            textPoints[11] = new TexCoord2f(0.0f, 0.0f);
        }
        if (textureFaces == null || textureFaces[3]) {
            textPoints[12] = new TexCoord2f(0.0f, 0.0f);
            textPoints[13] = new TexCoord2f(1.0f, 0.0f);
            textPoints[14] = new TexCoord2f(0.0f, 1.0f);
            textPoints[15] = new TexCoord2f(1.0f, 1.0f);
        } else {
            textPoints[12] = new TexCoord2f(0.0f, 0.0f);
            textPoints[13] = new TexCoord2f(0.0f, 0.0f);
            textPoints[14] = new TexCoord2f(0.0f, 0.0f);
            textPoints[15] = new TexCoord2f(0.0f, 0.0f);
        }
        if (textureFaces == null || textureFaces[4]) {
            textPoints[17] = new TexCoord2f(0.0f, 0.0f);
            textPoints[19] = new TexCoord2f(0.0f, 1.0f);
            textPoints[18] = new TexCoord2f(1.0f, 1.0f);
            textPoints[16] = new TexCoord2f(1.0f, 0.0f);
        } else {
            textPoints[17] = new TexCoord2f(0.0f, 0.0f);
            textPoints[19] = new TexCoord2f(0.0f, 0.0f);
            textPoints[18] = new TexCoord2f(0.0f, 0.0f);
            textPoints[16] = new TexCoord2f(0.0f, 0.0f);
        }
        if (textureFaces == null || textureFaces[5]) {
            textPoints[20] = new TexCoord2f(0.0f, 0.0f);
            textPoints[22] = new TexCoord2f(0.0f, 1.0f);
            textPoints[23] = new TexCoord2f(1.0f, 1.0f);
            textPoints[21] = new TexCoord2f(1.0f, 0.0f);
        } else {
            textPoints[20] = new TexCoord2f(0.0f, 0.0f);
            textPoints[22] = new TexCoord2f(0.0f, 0.0f);
            textPoints[23] = new TexCoord2f(0.0f, 0.0f);
            textPoints[21] = new TexCoord2f(0.0f, 0.0f);
        }
        int numberOfTriangles = 12;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 10;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 9;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 15;
        triangleIndices[index++] = 14;
        triangleIndices[index++] = 13;
        triangleIndices[index++] = 14;
        triangleIndices[index++] = 12;
        triangleIndices[index++] = 13;
        triangleIndices[index++] = 16;
        triangleIndices[index++] = 19;
        triangleIndices[index++] = 17;
        triangleIndices[index++] = 16;
        triangleIndices[index++] = 18;
        triangleIndices[index++] = 19;
        triangleIndices[index++] = 20;
        triangleIndices[index++] = 23;
        triangleIndices[index++] = 22;
        triangleIndices[index++] = 20;
        triangleIndices[index++] = 21;
        triangleIndices[index++] = 23;
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder FlatRectangle(double xMin, double yMin, double xMax, double yMax, double z) {
        return MeshDataGenerator.FlatRectangle((float)xMin, (float)yMin, (float)xMax, (float)yMax, (float)z);
    }

    public static MeshDataHolder FlatRectangle(float xMin, float yMin, float xMax, float yMax, float z) {
        Point3D32[] points = new Point3D32[4];
        Vector3D32[] normals = new Vector3D32[4];
        TexCoord2f[] textPoints = new TexCoord2f[4];
        points[0] = new Point3D32(xMin, yMin, z);
        points[1] = new Point3D32(xMax, yMin, z);
        points[2] = new Point3D32(xMax, yMax, z);
        points[3] = new Point3D32(xMin, yMax, z);
        textPoints[0] = new TexCoord2f(0.0f, 0.0f);
        textPoints[1] = new TexCoord2f(1.0f, 0.0f);
        textPoints[2] = new TexCoord2f(1.0f, 1.0f);
        textPoints[3] = new TexCoord2f(0.0f, 1.0f);
        normals[0] = new Vector3D32(0.0f, 0.0f, 1.0f);
        normals[1] = new Vector3D32(0.0f, 0.0f, 1.0f);
        normals[2] = new Vector3D32(0.0f, 0.0f, 1.0f);
        normals[3] = new Vector3D32(0.0f, 0.0f, 1.0f);
        int[] triangleIndices = new int[6];
        int index = 0;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 1;
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder Wedge(double lx, double ly, double lz) {
        return MeshDataGenerator.Wedge((float)lx, (float)ly, (float)lz);
    }

    public static MeshDataHolder Wedge(float lx, float ly, float lz) {
        Point3D32[] points = new Point3D32[18];
        Vector3D32[] normals = new Vector3D32[18];
        TexCoord2f[] textPoints = new TexCoord2f[18];
        points[0] = new Point3D32(-lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[0] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[0] = new TexCoord2f(0.0f, 0.0f);
        points[1] = new Point3D32(lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[1] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[1] = new TexCoord2f(1.0f, 0.0f);
        points[2] = new Point3D32(lx / 2.0f, ly / 2.0f, 0.0f);
        normals[2] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[2] = new TexCoord2f(1.0f, 1.0f);
        points[3] = new Point3D32(-lx / 2.0f, ly / 2.0f, 0.0f);
        normals[3] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[3] = new TexCoord2f(0.0f, 1.0f);
        points[4] = new Point3D32(lx / 2.0f, -ly / 2.0f, lz);
        normals[4] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[4] = new TexCoord2f(0.0f, 1.0f);
        points[5] = new Point3D32(lx / 2.0f, ly / 2.0f, lz);
        normals[5] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[5] = new TexCoord2f(1.0f, 1.0f);
        points[6] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[6] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[6] = new TexCoord2f(textPoints[2]);
        points[7] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[7] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[7] = new TexCoord2f(textPoints[1]);
        float wedgeAngle = (float)Math.atan2(lz, lx);
        points[8] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[8] = new Vector3D32(-((float)Math.sin(wedgeAngle)), (float)Math.cos(wedgeAngle), 0.0f);
        textPoints[8] = new TexCoord2f(textPoints[0]);
        points[9] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[9] = new Vector3D32(-((float)Math.sin(wedgeAngle)), (float)Math.cos(wedgeAngle), 0.0f);
        textPoints[9] = new TexCoord2f(textPoints[4]);
        points[10] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[10] = new Vector3D32(-((float)Math.sin(wedgeAngle)), (float)Math.cos(wedgeAngle), 0.0f);
        textPoints[10] = new TexCoord2f(textPoints[5]);
        points[11] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[11] = new Vector3D32(-((float)Math.sin(wedgeAngle)), (float)Math.cos(wedgeAngle), 0.0f);
        textPoints[11] = new TexCoord2f(textPoints[3]);
        points[12] = new Point3D32((Tuple3DReadOnly)points[0]);
        normals[12] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[12] = new TexCoord2f(textPoints[0]);
        points[13] = new Point3D32((Tuple3DReadOnly)points[1]);
        normals[13] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[13] = new TexCoord2f(textPoints[1]);
        points[14] = new Point3D32((Tuple3DReadOnly)points[4]);
        normals[14] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[14] = new TexCoord2f(textPoints[4]);
        points[15] = new Point3D32((Tuple3DReadOnly)points[2]);
        normals[15] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[15] = new TexCoord2f(textPoints[2]);
        points[16] = new Point3D32((Tuple3DReadOnly)points[3]);
        normals[16] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[16] = new TexCoord2f(textPoints[3]);
        points[17] = new Point3D32((Tuple3DReadOnly)points[5]);
        normals[17] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[17] = new TexCoord2f(textPoints[5]);
        int numberOfTriangles = 8;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 9;
        triangleIndices[index++] = 10;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 10;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 12;
        triangleIndices[index++] = 13;
        triangleIndices[index++] = 14;
        triangleIndices[index++] = 15;
        triangleIndices[index++] = 16;
        triangleIndices[index++] = 17;
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder PyramidCube(double lx, double ly, double lz, double lh) {
        return MeshDataGenerator.PyramidCube((float)lx, (float)ly, (float)lz, (float)lh);
    }

    public static MeshDataHolder PyramidCube(float lx, float ly, float lz, float lh) {
        Point3D32[] points = new Point3D32[40];
        Vector3D32[] normals = new Vector3D32[40];
        TexCoord2f[] textPoints = new TexCoord2f[40];
        points[0] = new Point3D32(-lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[0] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[0] = new TexCoord2f(0.5f, 0.5f);
        points[1] = new Point3D32(-lx / 2.0f, -ly / 2.0f, lz);
        normals[1] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[1] = new TexCoord2f(0.5f, 0.5f);
        points[2] = new Point3D32(-lx / 2.0f, ly / 2.0f, lz);
        normals[2] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[2] = new TexCoord2f(0.5f, 0.75f);
        points[3] = new Point3D32(-lx / 2.0f, ly / 2.0f, 0.0f);
        normals[3] = new Vector3D32(-1.0f, 0.0f, 0.0f);
        textPoints[3] = new TexCoord2f(0.5f, 0.75f);
        points[4] = new Point3D32(lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[4] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[4] = new TexCoord2f(0.75f, 0.5f);
        points[5] = new Point3D32(lx / 2.0f, -ly / 2.0f, lz);
        normals[5] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[5] = new TexCoord2f(0.75f, 0.5f);
        points[6] = new Point3D32(lx / 2.0f, ly / 2.0f, lz);
        normals[6] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[6] = new TexCoord2f(0.75f, 0.75f);
        points[7] = new Point3D32(lx / 2.0f, ly / 2.0f, 0.0f);
        normals[7] = new Vector3D32(1.0f, 0.0f, 0.0f);
        textPoints[7] = new TexCoord2f(0.75f, 0.75f);
        points[8] = new Point3D32(-lx / 2.0f, ly / 2.0f, 0.0f);
        normals[8] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[8] = new TexCoord2f(0.5f, 0.75f);
        points[9] = new Point3D32(-lx / 2.0f, ly / 2.0f, lz);
        normals[9] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[9] = new TexCoord2f(0.5f, 0.75f);
        points[10] = new Point3D32(lx / 2.0f, ly / 2.0f, lz);
        normals[10] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[10] = new TexCoord2f(0.75f, 0.75f);
        points[11] = new Point3D32(lx / 2.0f, ly / 2.0f, 0.0f);
        normals[11] = new Vector3D32(0.0f, 1.0f, 0.0f);
        textPoints[11] = new TexCoord2f(0.75f, 0.75f);
        points[12] = new Point3D32(-lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[12] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[12] = new TexCoord2f(0.5f, 0.5f);
        points[13] = new Point3D32(-lx / 2.0f, -ly / 2.0f, lz);
        normals[13] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[13] = new TexCoord2f(0.5f, 0.5f);
        points[14] = new Point3D32(lx / 2.0f, -ly / 2.0f, lz);
        normals[14] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[14] = new TexCoord2f(0.75f, 0.5f);
        points[15] = new Point3D32(lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[15] = new Vector3D32(0.0f, -1.0f, 0.0f);
        textPoints[15] = new TexCoord2f(0.75f, 0.5f);
        float frontBackAngle = (float)Math.atan2((double)lx / 2.0, lh);
        float leftRightAngle = (float)Math.atan2((double)ly / 2.0, lh);
        points[16] = new Point3D32(0.0f, 0.0f, lz + lh);
        normals[16] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[16] = new TexCoord2f(0.675f, 0.675f);
        points[17] = new Point3D32(-lx / 2.0f, -ly / 2.0f, lz);
        normals[17] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[17] = new TexCoord2f(0.5f, 0.5f);
        points[18] = new Point3D32(-lx / 2.0f, ly / 2.0f, lz);
        normals[18] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[18] = new TexCoord2f(0.5f, 0.75f);
        points[19] = new Point3D32(0.0f, 0.0f, lz + lh);
        normals[19] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[19] = new TexCoord2f(0.675f, 0.675f);
        points[20] = new Point3D32(lx / 2.0f, -ly / 2.0f, lz);
        normals[20] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[20] = new TexCoord2f(0.75f, 0.5f);
        points[21] = new Point3D32(lx / 2.0f, ly / 2.0f, lz);
        normals[21] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, (float)Math.sin(frontBackAngle));
        textPoints[21] = new TexCoord2f(0.75f, 0.75f);
        points[22] = new Point3D32(0.0f, 0.0f, lz + lh);
        normals[22] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), (float)Math.sin(leftRightAngle));
        textPoints[22] = new TexCoord2f(0.675f, 0.675f);
        points[23] = new Point3D32(-lx / 2.0f, ly / 2.0f, lz);
        normals[23] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), (float)Math.sin(leftRightAngle));
        textPoints[23] = new TexCoord2f(0.5f, 0.75f);
        points[24] = new Point3D32(lx / 2.0f, ly / 2.0f, lz);
        normals[24] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), (float)Math.sin(leftRightAngle));
        textPoints[24] = new TexCoord2f(0.75f, 0.75f);
        points[25] = new Point3D32(0.0f, 0.0f, lz + lh);
        normals[25] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), (float)Math.sin(leftRightAngle));
        textPoints[25] = new TexCoord2f(0.675f, 0.675f);
        points[26] = new Point3D32(-lx / 2.0f, -ly / 2.0f, lz);
        normals[26] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), (float)Math.sin(leftRightAngle));
        textPoints[26] = new TexCoord2f(0.5f, 0.5f);
        points[27] = new Point3D32(lx / 2.0f, -ly / 2.0f, lz);
        normals[27] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), (float)Math.sin(leftRightAngle));
        textPoints[27] = new TexCoord2f(0.75f, 0.5f);
        points[28] = new Point3D32(0.0f, 0.0f, -lh);
        normals[28] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[28] = new TexCoord2f(0.675f, 0.675f);
        points[29] = new Point3D32(-lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[29] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[29] = new TexCoord2f(0.5f, 0.5f);
        points[30] = new Point3D32(-lx / 2.0f, ly / 2.0f, 0.0f);
        normals[30] = new Vector3D32(-((float)Math.cos(frontBackAngle)), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[30] = new TexCoord2f(0.5f, 0.75f);
        points[31] = new Point3D32(0.0f, 0.0f, -lh);
        normals[31] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[31] = new TexCoord2f(0.675f, 0.675f);
        points[32] = new Point3D32(lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[32] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[32] = new TexCoord2f(0.75f, 0.5f);
        points[33] = new Point3D32(lx / 2.0f, ly / 2.0f, 0.0f);
        normals[33] = new Vector3D32((float)Math.cos(frontBackAngle), 0.0f, -((float)Math.sin(frontBackAngle)));
        textPoints[33] = new TexCoord2f(0.75f, 0.75f);
        points[34] = new Point3D32(0.0f, 0.0f, -lh);
        normals[34] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), -((float)Math.sin(leftRightAngle)));
        textPoints[34] = new TexCoord2f(0.675f, 0.675f);
        points[35] = new Point3D32(-lx / 2.0f, ly / 2.0f, 0.0f);
        normals[35] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), -((float)Math.sin(leftRightAngle)));
        textPoints[35] = new TexCoord2f(0.5f, 0.75f);
        points[36] = new Point3D32(lx / 2.0f, ly / 2.0f, 0.0f);
        normals[36] = new Vector3D32(0.0f, (float)Math.cos(leftRightAngle), -((float)Math.sin(leftRightAngle)));
        textPoints[36] = new TexCoord2f(0.75f, 0.75f);
        points[37] = new Point3D32(0.0f, 0.0f, -lh);
        normals[37] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), -((float)Math.sin(leftRightAngle)));
        textPoints[37] = new TexCoord2f(0.675f, 0.675f);
        points[38] = new Point3D32(-lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[38] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), -((float)Math.sin(leftRightAngle)));
        textPoints[38] = new TexCoord2f(0.5f, 0.5f);
        points[39] = new Point3D32(lx / 2.0f, -ly / 2.0f, 0.0f);
        normals[39] = new Vector3D32(0.0f, -((float)Math.cos(leftRightAngle)), -((float)Math.sin(leftRightAngle)));
        textPoints[39] = new TexCoord2f(0.75f, 0.5f);
        int numberOfTriangles = 16;
        int[] polygonIndices = new int[3 * numberOfTriangles];
        int index = 0;
        polygonIndices[index++] = 0;
        polygonIndices[index++] = 1;
        polygonIndices[index++] = 2;
        polygonIndices[index++] = 0;
        polygonIndices[index++] = 2;
        polygonIndices[index++] = 3;
        polygonIndices[index++] = 4;
        polygonIndices[index++] = 6;
        polygonIndices[index++] = 5;
        polygonIndices[index++] = 4;
        polygonIndices[index++] = 7;
        polygonIndices[index++] = 6;
        polygonIndices[index++] = 8;
        polygonIndices[index++] = 9;
        polygonIndices[index++] = 10;
        polygonIndices[index++] = 8;
        polygonIndices[index++] = 10;
        polygonIndices[index++] = 11;
        polygonIndices[index++] = 12;
        polygonIndices[index++] = 14;
        polygonIndices[index++] = 13;
        polygonIndices[index++] = 12;
        polygonIndices[index++] = 15;
        polygonIndices[index++] = 14;
        polygonIndices[index++] = 16;
        polygonIndices[index++] = 18;
        polygonIndices[index++] = 17;
        polygonIndices[index++] = 19;
        polygonIndices[index++] = 20;
        polygonIndices[index++] = 21;
        polygonIndices[index++] = 22;
        polygonIndices[index++] = 24;
        polygonIndices[index++] = 23;
        polygonIndices[index++] = 25;
        polygonIndices[index++] = 26;
        polygonIndices[index++] = 27;
        polygonIndices[index++] = 28;
        polygonIndices[index++] = 29;
        polygonIndices[index++] = 30;
        polygonIndices[index++] = 31;
        polygonIndices[index++] = 33;
        polygonIndices[index++] = 32;
        polygonIndices[index++] = 36;
        polygonIndices[index++] = 34;
        polygonIndices[index++] = 35;
        polygonIndices[index++] = 37;
        polygonIndices[index++] = 39;
        polygonIndices[index++] = 38;
        return new MeshDataHolder(points, textPoints, polygonIndices, normals);
    }

    public static MeshDataHolder Line(LineSegment3DReadOnly lineSegment3d, double width) {
        return MeshDataGenerator.Line(lineSegment3d.getFirstEndpoint(), lineSegment3d.getSecondEndpoint(), width);
    }

    public static MeshDataHolder Line(Point3DReadOnly point0, Point3DReadOnly point1, double width) {
        return MeshDataGenerator.Line(point0.getX(), point0.getY(), point0.getZ(), point1.getX(), point1.getY(), point1.getZ(), width);
    }

    public static MeshDataHolder Line(double x0, double y0, double z0, double x1, double y1, double z1, double width) {
        return MeshDataGenerator.Line((float)x0, (float)y0, (float)z0, (float)x1, (float)y1, (float)z1, (float)width);
    }

    public static MeshDataHolder Line(float x0, float y0, float z0, float x1, float y1, float z1, float width) {
        float vz;
        float vy;
        float vx;
        int i;
        float pitch;
        float yaw;
        Vector3D32 lineDirection = new Vector3D32(x1 - x0, y1 - y0, z1 - z0);
        float lineLength = (float)lineDirection.length();
        lineDirection.scale((double)(1.0f / lineLength));
        MeshDataHolder line = MeshDataGenerator.Cube(width, width, lineLength, false, null);
        Point3D32[] vertices = line.getVertices();
        Vector3D32[] normals = line.getVertexNormals();
        if (Math.abs(lineDirection.getZ()) < 0.9999999) {
            yaw = (float)Math.atan2(lineDirection.getY(), lineDirection.getX());
            double xyLength = Math.sqrt(lineDirection.getX() * lineDirection.getX() + lineDirection.getY() * lineDirection.getY());
            pitch = (float)Math.atan2(xyLength, lineDirection.getZ());
        } else {
            yaw = 0.0f;
            pitch = lineDirection.getZ() >= 0.0 ? 0.0f : (float)Math.PI;
        }
        float cYaw = (float)Math.cos(yaw);
        float sYaw = (float)Math.sin(yaw);
        float cPitch = (float)Math.cos(pitch);
        float sPitch = (float)Math.sin(pitch);
        float rxx = cYaw * cPitch;
        float rxy = -sYaw;
        float rxz = cYaw * sPitch;
        float ryx = sYaw * cPitch;
        float ryy = cYaw;
        float ryz = sYaw * sPitch;
        float rzx = -sPitch;
        float rzz = cPitch;
        for (i = 0; i < vertices.length; ++i) {
            Point3D32 vertex = vertices[i];
            vx = vertex.getX32();
            vy = vertex.getY32();
            vz = vertex.getZ32();
            vertex.setX(x0 + rxx * vx + rxy * vy + rxz * vz);
            vertex.setY(y0 + ryx * vx + ryy * vy + ryz * vz);
            vertex.setZ(z0 + rzx * vx + rzz * vz);
        }
        for (i = 0; i < normals.length; ++i) {
            Vector3D32 normal = normals[i];
            vx = normal.getX32();
            vy = normal.getY32();
            vz = normal.getZ32();
            normal.setX(rxx * vx + rxy * vy + rxz * vz);
            normal.setY(ryx * vx + ryy * vy + ryz * vz);
            normal.setZ(rzx * vx + rzz * vz);
        }
        return line;
    }

    public static MeshDataHolder Capsule(double height, double xRadius, double yRadius, double zRadius, int latitudeN, int longitudeN) {
        return MeshDataGenerator.Capsule((float)height, (float)xRadius, (float)yRadius, (float)zRadius, latitudeN, longitudeN);
    }

    public static MeshDataHolder Capsule(float height, float xRadius, float yRadius, float zRadius, int latitudeN, int longitudeN) {
        int longitudeIndex;
        int nextLatitudeIndex;
        int latitudeIndex;
        if (latitudeN % 2 != 0) {
            throw new RuntimeException("Sorry but latitudeN must be even for now in MeshDataGenerator.Capsule(). Please change or fix Capsule");
        }
        if (longitudeN % 2 != 0) {
            throw new RuntimeException("Sorry but latitudeN must be even for now in MeshDataGenerator.Capsule(). Please change or fix Capsule");
        }
        int numberOfVertices = latitudeN * longitudeN + 2;
        Point3D32[] points = new Point3D32[numberOfVertices];
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        TexCoord2f[] textPoints = new TexCoord2f[numberOfVertices];
        float halfHeight = 0.5f * height;
        for (int longitudeIndex2 = 0; longitudeIndex2 < longitudeN; ++longitudeIndex2) {
            float textureY;
            float textureX;
            float vertexZ;
            float vertexY;
            float vertexX;
            float normalZ;
            float normalY;
            float normalX;
            int currentIndex;
            float sinLatitude;
            float cosLatitude;
            float sinLongitude;
            float cosLongitude;
            float latitudeAngle;
            int latitudeIndex2;
            float longitudeAngle = (float)Math.PI * 2 * ((float)longitudeIndex2 / (float)longitudeN);
            for (latitudeIndex2 = 0; latitudeIndex2 < latitudeN / 2; ++latitudeIndex2) {
                latitudeAngle = 1.5707964f * (2.0f * (float)latitudeIndex2 / (float)latitudeN);
                cosLongitude = (float)Math.cos(longitudeAngle);
                sinLongitude = (float)Math.sin(longitudeAngle);
                cosLatitude = (float)Math.cos(latitudeAngle);
                sinLatitude = (float)Math.sin(latitudeAngle);
                currentIndex = latitudeIndex2 * longitudeN + longitudeIndex2;
                normalX = cosLongitude * cosLatitude;
                normalY = sinLongitude * cosLatitude;
                normalZ = sinLatitude;
                vertexX = xRadius * normalX;
                vertexY = yRadius * normalY;
                vertexZ = zRadius * normalZ + halfHeight;
                points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
                normals[currentIndex] = new Vector3D32(normalX, normalY, normalZ);
                textureX = longitudeAngle / ((float)Math.PI * 2);
                textureY = (float)(0.5 * (double)sinLatitude + 0.5);
                textPoints[currentIndex] = new TexCoord2f(textureX, textureY);
            }
            longitudeAngle = (float)Math.PI * 2 * ((float)longitudeIndex2 / (float)longitudeN);
            for (latitudeIndex2 = 0; latitudeIndex2 < latitudeN / 2; ++latitudeIndex2) {
                latitudeAngle = -(1.5707964f * (2.0f * (float)latitudeIndex2 / (float)latitudeN));
                cosLongitude = (float)Math.cos(longitudeAngle);
                sinLongitude = (float)Math.sin(longitudeAngle);
                cosLatitude = (float)Math.cos(latitudeAngle);
                sinLatitude = (float)Math.sin(latitudeAngle);
                currentIndex = (latitudeN / 2 + latitudeIndex2) * longitudeN + longitudeIndex2;
                normalX = cosLongitude * cosLatitude;
                normalY = sinLongitude * cosLatitude;
                normalZ = sinLatitude;
                vertexX = xRadius * normalX;
                vertexY = yRadius * normalY;
                vertexZ = zRadius * normalZ - halfHeight;
                points[currentIndex] = new Point3D32(vertexX, vertexY, vertexZ);
                normals[currentIndex] = new Vector3D32(normalX, normalY, normalZ);
                textureX = longitudeAngle / ((float)Math.PI * 2);
                textureY = (float)(0.5 * (double)sinLatitude + 0.5);
                textPoints[currentIndex] = new TexCoord2f(textureX, textureY);
            }
        }
        int northPoleIndex = latitudeN * longitudeN;
        points[northPoleIndex] = new Point3D32(0.0f, 0.0f, zRadius + halfHeight);
        normals[northPoleIndex] = new Vector3D32(0.0f, 0.0f, 1.0f);
        textPoints[northPoleIndex] = new TexCoord2f(1.0f, 1.0f);
        int southPoleIndex = latitudeN * longitudeN + 1;
        points[southPoleIndex] = new Point3D32(0.0f, 0.0f, -zRadius - halfHeight);
        normals[southPoleIndex] = new Vector3D32(0.0f, 0.0f, -1.0f);
        textPoints[southPoleIndex] = new TexCoord2f(0.5f, 1.0f);
        int numberOfTriangles = 2 * latitudeN * longitudeN + 1 * longitudeN;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        for (latitudeIndex = 0; latitudeIndex < latitudeN / 2 - 1; ++latitudeIndex) {
            for (int longitudeIndex3 = 0; longitudeIndex3 < longitudeN; ++longitudeIndex3) {
                int nextLongitudeIndex = (longitudeIndex3 + 1) % longitudeN;
                nextLatitudeIndex = latitudeIndex + 1;
                triangleIndices[index++] = latitudeIndex * longitudeN + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + longitudeIndex3;
                triangleIndices[index++] = latitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + longitudeIndex3;
            }
        }
        for (longitudeIndex = 0; longitudeIndex < longitudeN; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % longitudeN;
            triangleIndices[index++] = northPoleIndex;
            triangleIndices[index++] = (latitudeN / 2 - 1) * longitudeN + longitudeIndex;
            triangleIndices[index++] = (latitudeN / 2 - 1) * longitudeN + nextLongitudeIndex;
        }
        for (latitudeIndex = latitudeN / 2; latitudeIndex < latitudeN - 1; ++latitudeIndex) {
            for (int longitudeIndex4 = 0; longitudeIndex4 < longitudeN; ++longitudeIndex4) {
                int nextLongitudeIndex = (longitudeIndex4 + 1) % longitudeN;
                nextLatitudeIndex = latitudeIndex + 1;
                triangleIndices[index++] = latitudeIndex * longitudeN + longitudeIndex4;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + longitudeIndex4;
                triangleIndices[index++] = latitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = latitudeIndex * longitudeN + nextLongitudeIndex;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + longitudeIndex4;
                triangleIndices[index++] = nextLatitudeIndex * longitudeN + nextLongitudeIndex;
            }
        }
        for (longitudeIndex = 0; longitudeIndex < longitudeN; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % longitudeN;
            triangleIndices[index++] = southPoleIndex;
            triangleIndices[index++] = (latitudeN - 1) * longitudeN + nextLongitudeIndex;
            triangleIndices[index++] = (latitudeN - 1) * longitudeN + longitudeIndex;
        }
        for (longitudeIndex = 0; longitudeIndex < longitudeN; ++longitudeIndex) {
            int nextLongitudeIndex = (longitudeIndex + 1) % longitudeN;
            int upperLatitudeIndex = 0;
            int lowerLatitudeIndex = latitudeN / 2;
            triangleIndices[index++] = lowerLatitudeIndex * longitudeN + longitudeIndex;
            triangleIndices[index++] = lowerLatitudeIndex * longitudeN + nextLongitudeIndex;
            triangleIndices[index++] = upperLatitudeIndex * longitudeN + nextLongitudeIndex;
            triangleIndices[index++] = lowerLatitudeIndex * longitudeN + longitudeIndex;
            triangleIndices[index++] = upperLatitudeIndex * longitudeN + nextLongitudeIndex;
            triangleIndices[index++] = upperLatitudeIndex * longitudeN + longitudeIndex;
        }
        int[] pStripCounts = new int[numberOfTriangles];
        Arrays.fill(pStripCounts, 3);
        return new MeshDataHolder(points, textPoints, triangleIndices, normals);
    }

    public static MeshDataHolder Tetrahedron(double edgeLength) {
        return MeshDataGenerator.Tetrahedron((float)edgeLength);
    }

    public static MeshDataHolder Tetrahedron(float edgeLength) {
        float height = THIRD_SQRT6 * edgeLength;
        float topHeight = FOURTH_SQRT6 * edgeLength;
        float baseHeight = topHeight - height;
        float halfEdgeLength = 0.5f * edgeLength;
        float cosFaceEdgeFace = 0.33333334f;
        float sinFaceEdgeFace = TETRAHEDRON_SINE_FACE_EDGE_FACE_ANGLE;
        float cosEdgeVertexEdge = 0.5f;
        float sinEdgeVertexEdge = HALF_SQRT3;
        Point3D32 topVertex = new Point3D32(0.0f, 0.0f, topHeight);
        Point3D32 baseVertex0 = new Point3D32(edgeLength * THIRD_SQRT3, 0.0f, baseHeight);
        Point3D32 baseVertex1 = new Point3D32(-edgeLength * SIXTH_SQRT3, halfEdgeLength, baseHeight);
        Point3D32 baseVertex2 = new Point3D32(-edgeLength * SIXTH_SQRT3, -halfEdgeLength, baseHeight);
        TexCoord2f baseTex0 = new TexCoord2f(0.5f, 1.0f);
        TexCoord2f baseTex1 = new TexCoord2f(0.75f, 1.0f - FOURTH_SQRT3);
        TexCoord2f baseTex2 = new TexCoord2f(0.25f, 1.0f - FOURTH_SQRT3);
        Vector3D32 frontNormal = new Vector3D32(-sinFaceEdgeFace, 0.0f, cosFaceEdgeFace);
        Vector3D32 rightNormal = new Vector3D32(sinFaceEdgeFace * sinEdgeVertexEdge, sinFaceEdgeFace * cosEdgeVertexEdge, cosFaceEdgeFace);
        Vector3D32 leftNormal = new Vector3D32(sinFaceEdgeFace * sinEdgeVertexEdge, -sinFaceEdgeFace * cosEdgeVertexEdge, cosFaceEdgeFace);
        Vector3D32 baseNormal = new Vector3D32(0.0f, 0.0f, -1.0f);
        int numberOfVertices = 12;
        Point3D32[] vertices = new Point3D32[numberOfVertices];
        TexCoord2f[] texCoords = new TexCoord2f[numberOfVertices];
        Vector3D32[] normals = new Vector3D32[numberOfVertices];
        vertices[0] = new Point3D32((Tuple3DReadOnly)baseVertex2);
        texCoords[0] = new TexCoord2f(baseTex2);
        normals[0] = new Vector3D32((Tuple3DReadOnly)frontNormal);
        vertices[1] = new Point3D32((Tuple3DReadOnly)baseVertex1);
        texCoords[1] = new TexCoord2f(baseTex1);
        normals[1] = new Vector3D32((Tuple3DReadOnly)frontNormal);
        vertices[2] = new Point3D32((Tuple3DReadOnly)topVertex);
        texCoords[2] = new TexCoord2f(0.5f, 1.0f - HALF_SQRT3);
        normals[2] = new Vector3D32((Tuple3DReadOnly)frontNormal);
        vertices[3] = new Point3D32((Tuple3DReadOnly)baseVertex1);
        texCoords[3] = new TexCoord2f(baseTex1);
        normals[3] = new Vector3D32((Tuple3DReadOnly)rightNormal);
        vertices[4] = new Point3D32((Tuple3DReadOnly)baseVertex0);
        texCoords[4] = new TexCoord2f(baseTex0);
        normals[4] = new Vector3D32((Tuple3DReadOnly)rightNormal);
        vertices[5] = new Point3D32((Tuple3DReadOnly)topVertex);
        texCoords[5] = new TexCoord2f(1.0f, 1.0f);
        normals[5] = new Vector3D32((Tuple3DReadOnly)rightNormal);
        vertices[6] = new Point3D32((Tuple3DReadOnly)baseVertex0);
        texCoords[6] = new TexCoord2f(baseTex0);
        normals[6] = new Vector3D32((Tuple3DReadOnly)leftNormal);
        vertices[7] = new Point3D32((Tuple3DReadOnly)baseVertex2);
        texCoords[7] = new TexCoord2f(baseTex2);
        normals[7] = new Vector3D32((Tuple3DReadOnly)leftNormal);
        vertices[8] = new Point3D32((Tuple3DReadOnly)topVertex);
        texCoords[8] = new TexCoord2f(0.0f, 1.0f);
        normals[8] = new Vector3D32((Tuple3DReadOnly)leftNormal);
        vertices[9] = new Point3D32((Tuple3DReadOnly)baseVertex0);
        texCoords[9] = new TexCoord2f(baseTex0);
        normals[9] = new Vector3D32((Tuple3DReadOnly)baseNormal);
        vertices[10] = new Point3D32((Tuple3DReadOnly)baseVertex1);
        texCoords[10] = new TexCoord2f(baseTex1);
        normals[10] = new Vector3D32((Tuple3DReadOnly)baseNormal);
        vertices[11] = new Point3D32((Tuple3DReadOnly)baseVertex2);
        texCoords[11] = new TexCoord2f(baseTex2);
        normals[11] = new Vector3D32((Tuple3DReadOnly)baseNormal);
        int numberOfTriangles = 4;
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        triangleIndices[index++] = 0;
        triangleIndices[index++] = 2;
        triangleIndices[index++] = 1;
        triangleIndices[index++] = 3;
        triangleIndices[index++] = 5;
        triangleIndices[index++] = 4;
        triangleIndices[index++] = 6;
        triangleIndices[index++] = 8;
        triangleIndices[index++] = 7;
        triangleIndices[index++] = 9;
        triangleIndices[index++] = 11;
        triangleIndices[index++] = 10;
        return new MeshDataHolder(vertices, texCoords, triangleIndices, normals);
    }

    private static TexCoord2f[] generateInterpolatedTexturePoints(int numPoints) {
        TexCoord2f[] textPoints = new TexCoord2f[numPoints];
        double distanceBetweenPoints = 4.0 / (double)numPoints;
        float[] xSides = new float[]{0.0f, 0.0f, 1.0f, 1.0f};
        float[] ySides = new float[]{0.0f, 1.0f, 1.0f, 0.0f};
        for (int i = 0; i < textPoints.length; ++i) {
            float positionAlongPerimeter = (float)distanceBetweenPoints * (float)i;
            float positionAlongSide = (float)((double)positionAlongPerimeter - Math.floor(positionAlongPerimeter));
            int side = (int)Math.floor(positionAlongPerimeter) % 4;
            int secondPoint = (side + 1) % 4;
            float texCoordX = positionAlongSide * xSides[secondPoint] + (1.0f - positionAlongSide) * xSides[side];
            float texCoordY = positionAlongSide * ySides[secondPoint] + (1.0f - positionAlongSide) * ySides[side];
            textPoints[i] = new TexCoord2f(texCoordX, texCoordY);
        }
        return textPoints;
    }

    private static Point3D32[] makePoint3fArrayFromPoint3dArray(Point3DReadOnly[] pPoints) {
        Point3D32[] points3f = new Point3D32[pPoints.length];
        int i = 0;
        for (Point3DReadOnly point3d : pPoints) {
            points3f[i++] = new Point3D32((Tuple3DReadOnly)point3d);
        }
        return points3f;
    }

    public static Vector3D32[] findNormalsPerVertex(int[] indices, Point3DReadOnly[] vertices) {
        LinkedHashMap<Integer, LinkedHashSet<Integer>> participatingFacesPerVertex = new LinkedHashMap<Integer, LinkedHashSet<Integer>>();
        for (int i = 0; i < indices.length; ++i) {
            LinkedHashSet<Integer> vertexFacesSet = (LinkedHashSet<Integer>)participatingFacesPerVertex.get(indices[i]);
            if (vertexFacesSet == null) {
                vertexFacesSet = new LinkedHashSet<Integer>();
                participatingFacesPerVertex.put(indices[i], vertexFacesSet);
            }
            vertexFacesSet.add(i / 3);
        }
        Vector3D32[] normalsPerFace = MeshDataGenerator.findNormalsPerFace(indices, vertices);
        int pos = 0;
        Vector3D32[] normalsPerVertex = new Vector3D32[vertices.length];
        for (int vertexIndex = 0; vertexIndex < vertices.length; ++vertexIndex) {
            Set participatingFaceIndices = (Set)participatingFacesPerVertex.get(vertexIndex);
            if (participatingFaceIndices == null) continue;
            Vector3D32 vertexNormal = new Vector3D32();
            Iterator iterator = participatingFaceIndices.iterator();
            while (iterator.hasNext()) {
                int face = (Integer)iterator.next();
                vertexNormal.add((Tuple3DReadOnly)normalsPerFace[face]);
            }
            float faces = participatingFaceIndices.size();
            vertexNormal.scale((double)(1.0f / faces));
            normalsPerVertex[pos++] = vertexNormal;
        }
        return normalsPerVertex;
    }

    private static Vector3D32[] findNormalsPerFace(int[] indices, Point3DReadOnly[] vertices) {
        Vector3D32[] normalsPerFace = new Vector3D32[indices.length / 3];
        Vector3D32 firstVector = new Vector3D32();
        Vector3D32 secondVector = new Vector3D32();
        Point3DReadOnly[] faceVertices = new Point3DReadOnly[3];
        for (int face = 0; face < normalsPerFace.length; ++face) {
            normalsPerFace[face] = new Vector3D32();
            for (int i = 0; i < faceVertices.length; ++i) {
                faceVertices[i] = vertices[indices[face * 3 + i]];
            }
            firstVector.set((Tuple3DReadOnly)faceVertices[2]);
            firstVector.sub((Tuple3DReadOnly)faceVertices[0]);
            secondVector.set((Tuple3DReadOnly)faceVertices[2]);
            secondVector.sub((Tuple3DReadOnly)faceVertices[1]);
            normalsPerFace[face].cross((Tuple3DReadOnly)firstVector, (Tuple3DReadOnly)secondVector);
            normalsPerFace[face].normalize();
        }
        return normalsPerFace;
    }

    public static MeshDataHolder createFromVerticesAndStripCounts(Point3DReadOnly[] vertices, int[] polygonStripCounts) {
        Point3D32[] verticesWithFloats = new Point3D32[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            verticesWithFloats[i] = new Point3D32((Tuple3DReadOnly)vertices[i]);
        }
        return MeshDataGenerator.createFromVerticesAndStripCounts(verticesWithFloats, polygonStripCounts);
    }

    public static MeshDataHolder createFromVerticesAndStripCounts(Point3D32[] vertices, int[] polygonStripCounts) {
        int[] polygonIndices = new int[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            polygonIndices[i] = i;
        }
        TexCoord2f[] textPoints = new TexCoord2f[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            textPoints[i] = new TexCoord2f();
        }
        ArrayList<Integer> triangleIndices = new ArrayList<Integer>();
        int polygonIndicesStart = 0;
        for (int pointsForThisPolygon : polygonStripCounts) {
            int[] splitIntoTriangles;
            int[] polygon = new int[pointsForThisPolygon];
            for (int i = 0; i < pointsForThisPolygon; ++i) {
                polygon[i] = polygonIndices[polygonIndicesStart + i];
            }
            for (int i : splitIntoTriangles = MeshDataGenerator.splitPolygonIntoTriangles(polygon)) {
                triangleIndices.add(i);
            }
            polygonIndicesStart += pointsForThisPolygon;
        }
        int[] indices = new int[triangleIndices.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)triangleIndices.get(i);
        }
        Vector3D32[] normals = MeshDataGenerator.findNormalsPerVertex(indices, (Point3DReadOnly[])vertices);
        return new MeshDataHolder(vertices, textPoints, indices, normals);
    }

    private static int[] splitPolygonIntoTriangles(int[] polygonIndices) {
        if (polygonIndices.length <= 3) {
            return polygonIndices;
        }
        int[] ret = new int[3 * (polygonIndices.length - 2)];
        int i = 0;
        for (int j = 2; j < polygonIndices.length; ++j) {
            ret[i++] = polygonIndices[0];
            ret[i++] = polygonIndices[j - 1];
            ret[i++] = polygonIndices[j];
        }
        return ret;
    }
}

