/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.convexOptimization.QpOASESCWrapper;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ConstrainedQPSolver;

public class OASESConstrainedQPSolver
extends ConstrainedQPSolver {
    double maxCPUTime = Double.POSITIVE_INFINITY;
    double currentCPUTime;
    int maxWorkingSetChange = 10000;
    int currentWorkingSetChange;
    QpOASESCWrapper qpWrapper = new QpOASESCWrapper();

    public OASESConstrainedQPSolver() {
        this(1, 1);
    }

    public OASESConstrainedQPSolver(int nvar, int ncon) {
    }

    @Override
    public boolean supportBoxConstraints() {
        return true;
    }

    @Override
    public int solve(DMatrixRMaj Q, DMatrixRMaj f, DMatrixRMaj Aeq, DMatrixRMaj beq, DMatrixRMaj Ain, DMatrixRMaj bin, DMatrixRMaj x, boolean initialize) throws NoConvergenceException {
        return this.solve(Q, f, Aeq, beq, Ain, bin, null, null, x, initialize);
    }

    @Override
    public int solve(DMatrixRMaj Q, DMatrixRMaj f, DMatrixRMaj Aeq, DMatrixRMaj beq, DMatrixRMaj Ain, DMatrixRMaj bin, DMatrixRMaj lb, DMatrixRMaj ub, DMatrixRMaj x, boolean initialize) throws NoConvergenceException {
        this.qpWrapper.setMaxCpuTime(this.maxCPUTime);
        this.qpWrapper.setMaxWorkingSetChanges(this.maxWorkingSetChange);
        this.qpWrapper.solve(Q, f, Aeq, beq, Ain, bin, lb, ub, x, initialize);
        int iter = this.qpWrapper.getLastWorkingSetChanges();
        this.currentCPUTime = this.qpWrapper.getLastCpuTime();
        this.currentWorkingSetChange = this.qpWrapper.getLastWorkingSetChanges();
        return iter;
    }
}

