/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;

public abstract class AbstractActiveSetQPSolver {
    protected DMatrixRMaj linearEqualityConstraintA;
    protected DMatrixRMaj linearEqualityConstraintATranspose;
    protected DMatrixRMaj linearEqualityConstraintB;
    protected DMatrixRMaj linearInequalityConstraintA;
    protected DMatrixRMaj linearInequalityConstraintB;
    protected DMatrixRMaj activeSetA;
    protected DMatrixRMaj activeSetB;
    protected DMatrixRMaj quadraticCostGMatrix;
    protected DMatrixRMaj quadraticCostFVector;
    protected double quadraticCostScalar;
    protected int numberOfVariablesToSolve = -1;
    protected boolean[] linearInequalityActiveSet;
    DMatrixRMaj obj = new DMatrixRMaj(1, 1);
    boolean isNullFieldSet = false;

    public int getNumEqualityConstraints() {
        return this.linearEqualityConstraintA.numRows;
    }

    public void setQuadraticCostFunction(double[][] quadraticCostFunctionWMatrix, double[] quadraticCostFunctionGVector, double quadraticCostScalar) {
        this.assertCorrectSize(quadraticCostFunctionWMatrix);
        this.assertCorrectSize(quadraticCostFunctionGVector);
        this.setQuadraticCostFunction(new DMatrixRMaj(quadraticCostFunctionWMatrix), MatrixTools.createVector((double[])quadraticCostFunctionGVector), quadraticCostScalar);
    }

    public void setQuadraticCostFunction(DMatrixRMaj costQuadraticMatrix, DMatrixRMaj costLinearVector, double quadraticCostScalar) {
        this.setAndAssertCorrectNumberOfVariablesToSolve(costQuadraticMatrix.numCols);
        this.setAndAssertCorrectNumberOfVariablesToSolve(costQuadraticMatrix.numRows);
        this.setAndAssertCorrectNumberOfVariablesToSolve(costLinearVector.numRows);
        DMatrixRMaj symCostQuadraticMatrix = new DMatrixRMaj(costQuadraticMatrix);
        CommonOps_DDRM.transpose((DMatrixRMaj)symCostQuadraticMatrix);
        CommonOps_DDRM.add((DMatrixD1)costQuadraticMatrix, (DMatrixD1)symCostQuadraticMatrix, (DMatrixD1)symCostQuadraticMatrix);
        CommonOps_DDRM.scale((double)0.5, (DMatrixD1)symCostQuadraticMatrix);
        this.quadraticCostGMatrix = symCostQuadraticMatrix;
        this.quadraticCostFVector = costLinearVector;
        this.quadraticCostScalar = quadraticCostScalar;
    }

    public void setLinearEqualityConstraints(double[][] linearEqualityConstraintsAMatrix, double[] linearEqualityConstraintsBVector) {
        this.assertCorrectColumnSize(linearEqualityConstraintsAMatrix);
        if (linearEqualityConstraintsAMatrix.length != linearEqualityConstraintsBVector.length) {
            throw new RuntimeException();
        }
        this.setLinearEqualityConstraints(new DMatrixRMaj(linearEqualityConstraintsAMatrix), MatrixTools.createVector((double[])linearEqualityConstraintsBVector));
    }

    public void setLinearEqualityConstraints(DMatrixRMaj linearEqualityConstraintsAMatrix, DMatrixRMaj linearEqualityConstraintsBVector) {
        this.setAndAssertCorrectNumberOfVariablesToSolve(linearEqualityConstraintsAMatrix.numCols);
        this.linearEqualityConstraintB = linearEqualityConstraintsBVector;
        this.linearEqualityConstraintA = linearEqualityConstraintsAMatrix;
        this.linearEqualityConstraintATranspose = CommonOps_DDRM.transpose((DMatrixRMaj)this.linearEqualityConstraintA, null);
    }

    public void setLinearInequalityConstraints(double[][] linearInequalityConstraintPVectors, double[] linearInequalityConstraintFs) {
        this.assertCorrectColumnSize(linearInequalityConstraintPVectors);
        if (linearInequalityConstraintPVectors.length != linearInequalityConstraintFs.length) {
            throw new RuntimeException();
        }
        this.setLinearInequalityConstraints(new DMatrixRMaj(linearInequalityConstraintPVectors), MatrixTools.createVector((double[])linearInequalityConstraintFs));
    }

    public void setLinearInequalityConstraints(DMatrixRMaj inequalityA, DMatrixRMaj inequalityB) {
        this.linearInequalityConstraintA = inequalityA;
        this.linearInequalityConstraintB = inequalityB;
        this.linearInequalityActiveSet = new boolean[inequalityA.getNumRows()];
        this.setAndAssertCorrectNumberOfVariablesToSolve(this.linearInequalityConstraintA.numCols);
    }

    protected int getActiveSetSize() {
        if (this.linearInequalityActiveSet == null) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < this.linearInequalityActiveSet.length; ++i) {
            if (!this.linearInequalityActiveSet[i]) continue;
            ++ret;
        }
        return ret;
    }

    protected int getLinearEqualityConstraintsSize() {
        if (this.linearEqualityConstraintA == null) {
            return 0;
        }
        return this.linearEqualityConstraintA.numRows;
    }

    protected int getLinearInequalityConstraintsSize() {
        if (this.linearInequalityConstraintA == null) {
            return 0;
        }
        return this.linearInequalityConstraintA.numRows;
    }

    private void assertCorrectSize(double[][] matrix) {
        if (this.numberOfVariablesToSolve == -1) {
            this.numberOfVariablesToSolve = matrix.length;
        }
        if (matrix.length != this.numberOfVariablesToSolve) {
            throw new RuntimeException("matrix.length = " + matrix.length + " != numberOfVariablesToSolve = " + this.numberOfVariablesToSolve);
        }
        if (matrix[0].length != this.numberOfVariablesToSolve) {
            throw new RuntimeException("matrix[0].length = " + matrix[0].length + " != numberOfVariablesToSolve = " + this.numberOfVariablesToSolve);
        }
    }

    private void assertCorrectColumnSize(double[][] matrix) {
        if (this.numberOfVariablesToSolve == -1) {
            this.numberOfVariablesToSolve = matrix[0].length;
        }
        if (matrix[0].length != this.numberOfVariablesToSolve) {
            throw new RuntimeException("matrix[0].length = " + matrix[0].length + " != numberOfVariablesToSolve = " + this.numberOfVariablesToSolve);
        }
    }

    protected void setAndAssertCorrectNumberOfVariablesToSolve(int n) {
        if (this.numberOfVariablesToSolve == -1) {
            this.numberOfVariablesToSolve = n;
        }
        if (n != this.numberOfVariablesToSolve) {
            throw new RuntimeException("incorrect NumberOfVariables size");
        }
    }

    private void assertCorrectSize(double[] vector) {
        if (this.numberOfVariablesToSolve == -1) {
            this.numberOfVariablesToSolve = vector.length;
        }
        if (vector.length != this.numberOfVariablesToSolve) {
            throw new RuntimeException("vector.length = " + vector.length + " != numberOfVariablesToSolve = " + this.numberOfVariablesToSolve);
        }
    }

    public abstract double[] solve();

    protected static void setPartialMatrix(double[][] fromMatrix, int startRow, int startColumn, DMatrixRMaj toMatrix) {
        for (int i = 0; i < fromMatrix.length; ++i) {
            for (int j = 0; j < fromMatrix[0].length; ++j) {
                toMatrix.set(startRow + i, startColumn + j, fromMatrix[i][j]);
            }
        }
    }

    protected static void setPartialVector(double[] fromVector, int startRow, DMatrixRMaj toVector) {
        for (int i = 0; i < fromVector.length; ++i) {
            toVector.set(startRow + i, 0, fromVector[i]);
        }
    }

    public void setLinearInequalityActiveSet(boolean[] linearInequalityActiveSet) {
        if (this.linearInequalityActiveSet.length != linearInequalityActiveSet.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < linearInequalityActiveSet.length; ++i) {
            this.linearInequalityActiveSet[i] = linearInequalityActiveSet[i];
        }
    }

    public double getObjectiveCost(DMatrixRMaj x) {
        MatrixTools.multQuad((DMatrix1Row)x, (DMatrix1Row)this.quadraticCostGMatrix, (DMatrixRMaj)this.obj);
        CommonOps_DDRM.scale((double)0.5, (DMatrixD1)this.obj);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.quadraticCostFVector, (DMatrix1Row)x, (DMatrix1Row)this.obj);
        return this.obj.get(0, 0) + 0.5 * this.quadraticCostScalar;
    }

    public void displayProblem() {
        this.setZeroSizeMatrixForNullFields();
        System.out.println("----------------------------------------------------------------------------------------------------");
        System.out.println("equalityA:" + this.linearEqualityConstraintA);
        System.out.println("equalityB:" + this.linearEqualityConstraintB);
        System.out.println("inequalityA:" + this.linearInequalityConstraintA);
        System.out.println("inequalityB:" + this.linearInequalityConstraintB);
        System.out.println("costQuadQ:" + this.quadraticCostGMatrix);
        System.out.println("costLinearF:" + this.quadraticCostFVector);
        System.out.println("costLinearScalar:" + this.quadraticCostScalar);
        System.out.println("----------------------------------------------------------------------------------------------------");
    }

    public void setZeroSizeMatrixForNullFields() {
        if (this.isNullFieldSet) {
            return;
        }
        assert (this.numberOfVariablesToSolve > 0);
        if (this.linearEqualityConstraintA == null) {
            this.linearEqualityConstraintA = new DMatrixRMaj(0, this.numberOfVariablesToSolve);
            this.linearEqualityConstraintATranspose = new DMatrixRMaj(this.numberOfVariablesToSolve, 0);
            this.linearEqualityConstraintB = new DMatrixRMaj(0, 1);
        }
        if (this.linearInequalityConstraintA == null) {
            this.linearInequalityConstraintA = new DMatrixRMaj(0, this.numberOfVariablesToSolve);
            this.linearInequalityConstraintB = new DMatrixRMaj(0, 1);
        }
        if (this.quadraticCostGMatrix == null) {
            this.quadraticCostGMatrix = new DMatrixRMaj(this.numberOfVariablesToSolve, this.numberOfVariablesToSolve);
        }
        if (this.quadraticCostFVector == null) {
            this.quadraticCostFVector = new DMatrixRMaj(this.numberOfVariablesToSolve, 1);
        }
    }
}

