/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.convexOptimization.quadraticProgram;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.convexOptimization.quadraticProgram.SimpleEfficientActiveSetQPSolver;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeMatrix;

public class SimpleEfficientActiveSetQPSolverWithInactiveVariables
extends SimpleEfficientActiveSetQPSolver
implements ActiveSetQPSolverWithInactiveVariablesInterface {
    private final NativeMatrix originalQuadraticCostQMatrix = new NativeMatrix(0, 0);
    private final NativeMatrix originalQuadraticCostQVector = new NativeMatrix(0, 0);
    private final NativeMatrix originalLinearEqualityConstraintsAMatrix = new NativeMatrix(0, 0);
    private final NativeMatrix originalLinearEqualityConstraintsBVector = new NativeMatrix(0, 0);
    private final NativeMatrix originalLinearInequalityConstraintsCMatrixO = new NativeMatrix(0, 0);
    private final NativeMatrix originalLinearInequalityConstraintsDVectorO = new NativeMatrix(0, 0);
    private final NativeMatrix originalVariableLowerBounds = new NativeMatrix(0, 0);
    private final NativeMatrix originalVariableUpperBounds = new NativeMatrix(0, 0);
    private final DMatrixRMaj activeVariables = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj activeVariableSolution = new DMatrixRMaj(0, 0);

    private void setMatricesFromOriginal() {
        this.quadraticCostQMatrix.set(this.originalQuadraticCostQMatrix);
        this.quadraticCostQVector.set(this.originalQuadraticCostQVector);
        this.linearEqualityConstraintsAMatrix.set(this.originalLinearEqualityConstraintsAMatrix);
        this.linearEqualityConstraintsBVector.set(this.originalLinearEqualityConstraintsBVector);
        this.linearInequalityConstraintsCMatrixO.set(this.originalLinearInequalityConstraintsCMatrixO);
        this.linearInequalityConstraintsDVectorO.set(this.originalLinearInequalityConstraintsDVectorO);
        this.variableLowerBounds.set(this.originalVariableLowerBounds);
        this.variableUpperBounds.set(this.originalVariableUpperBounds);
    }

    private void removeInactiveVariables() {
        this.setMatricesFromOriginal();
        for (int variableIndex = this.activeVariables.getNumRows() - 1; variableIndex >= 0; --variableIndex) {
            if (this.activeVariables.get(variableIndex) == 1.0) continue;
            this.quadraticCostQMatrix.removeRow(variableIndex);
            this.quadraticCostQMatrix.removeColumn(variableIndex);
            this.quadraticCostQVector.removeRow(variableIndex);
            if (this.linearEqualityConstraintsAMatrix.getNumElements() > 0) {
                this.linearEqualityConstraintsAMatrix.removeColumn(variableIndex);
            }
            if (this.linearInequalityConstraintsCMatrixO.getNumElements() > 0) {
                this.linearInequalityConstraintsCMatrixO.removeColumn(variableIndex);
            }
            if (this.variableLowerBounds.getNumElements() > 0) {
                this.variableLowerBounds.removeRow(variableIndex);
            }
            if (this.variableUpperBounds.getNumElements() <= 0) continue;
            this.variableUpperBounds.removeRow(variableIndex);
        }
        int numVars = this.quadraticCostQMatrix.getNumRows();
        if (this.linearEqualityConstraintsAMatrix.getNumElements() == 0) {
            this.linearEqualityConstraintsAMatrix.reshape(0, numVars);
        }
        if (this.linearInequalityConstraintsCMatrixO.getNumElements() == 0) {
            this.linearInequalityConstraintsCMatrixO.reshape(0, numVars);
        }
        SimpleEfficientActiveSetQPSolverWithInactiveVariables.removeZeroRowsFromConstraints(this.linearEqualityConstraintsAMatrix, this.linearEqualityConstraintsBVector);
        SimpleEfficientActiveSetQPSolverWithInactiveVariables.removeZeroRowsFromConstraints(this.linearInequalityConstraintsCMatrixO, this.linearInequalityConstraintsDVectorO);
    }

    private static void removeZeroRowsFromConstraints(NativeMatrix matrix, NativeMatrix vector) {
        for (int rowIndex = vector.getNumRows() - 1; rowIndex >= 0; --rowIndex) {
            double sumOfRowElements = 0.0;
            for (int columnIndex = 0; columnIndex < matrix.getNumCols(); ++columnIndex) {
                sumOfRowElements += Math.abs(matrix.get(rowIndex, columnIndex));
            }
            boolean isZeroRow = MathTools.epsilonEquals((double)sumOfRowElements, (double)0.0, (double)1.0E-12);
            if (!isZeroRow) continue;
            matrix.removeRow(rowIndex);
            vector.removeRow(rowIndex);
        }
    }

    private void copyActiveVariableSolutionToAllVariables(DMatrix solutionToPack, DMatrixRMaj activeVariableSolution) {
        if (MatrixTools.containsNaN((DMatrix1Row)activeVariableSolution)) {
            for (int i = 0; i < solutionToPack.getNumRows(); ++i) {
                solutionToPack.set(i, 0, Double.NaN);
            }
            return;
        }
        int activeVariableIndex = 0;
        for (int variableIndex = 0; variableIndex < solutionToPack.getNumRows(); ++variableIndex) {
            if (this.activeVariables.get(variableIndex) != 1.0) {
                solutionToPack.set(variableIndex, 0, 0.0);
                continue;
            }
            solutionToPack.set(variableIndex, 0, activeVariableSolution.get(activeVariableIndex, 0));
            ++activeVariableIndex;
        }
    }

    @Override
    public void setLowerBounds(DMatrix variableLowerBounds) {
        if (variableLowerBounds.getNumRows() != this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableLowerBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.originalVariableLowerBounds.set((Matrix)variableLowerBounds);
    }

    @Override
    public void setUpperBounds(DMatrix variableUpperBounds) {
        if (variableUpperBounds.getNumRows() != this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variableUpperBounds.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.originalVariableUpperBounds.set((Matrix)variableUpperBounds);
    }

    @Override
    public void setQuadraticCostFunction(DMatrix costQuadraticMatrix, DMatrix costLinearVector, double quadraticCostScalar) {
        if (costLinearVector.getNumCols() != 1) {
            throw new RuntimeException("costLinearVector.getNumCols() != 1");
        }
        if (costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()");
        }
        if (costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()");
        }
        this.costQuadraticMatrix.set((Matrix)costQuadraticMatrix);
        this.symmetricCostQuadraticMatrix.transpose(this.costQuadraticMatrix);
        this.symmetricCostQuadraticMatrix.add(this.costQuadraticMatrix, this.symmetricCostQuadraticMatrix);
        this.symmetricCostQuadraticMatrix.scale(0.5);
        this.originalQuadraticCostQMatrix.set(this.symmetricCostQuadraticMatrix);
        this.originalQuadraticCostQVector.set((Matrix)costLinearVector);
        this.quadraticCostScalar = quadraticCostScalar;
        this.setAllVariablesActive();
    }

    @Override
    public double getObjectiveCost(DMatrixRMaj x) {
        this.nativexSolutionMatrix.set(x);
        this.computedObjectiveFunctionValue.multQuad(this.nativexSolutionMatrix, this.originalQuadraticCostQMatrix);
        this.computedObjectiveFunctionValue.scale(0.5);
        this.computedObjectiveFunctionValue.multAddTransA(this.originalQuadraticCostQVector, this.nativexSolutionMatrix);
        return this.computedObjectiveFunctionValue.get(0, 0) + this.quadraticCostScalar;
    }

    @Override
    public void setLinearEqualityConstraints(DMatrix linearEqualityConstraintsAMatrix, DMatrix linearEqualityConstraintsBVector) {
        if (linearEqualityConstraintsBVector.getNumCols() != 1) {
            throw new RuntimeException("linearEqualityConstraintsBVector.getNumCols() != 1");
        }
        if (linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()");
        }
        if (linearEqualityConstraintsAMatrix.getNumCols() != this.originalQuadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.originalLinearEqualityConstraintsBVector.set((Matrix)linearEqualityConstraintsBVector);
        this.originalLinearEqualityConstraintsAMatrix.set((Matrix)linearEqualityConstraintsAMatrix);
    }

    @Override
    public void setLinearInequalityConstraints(DMatrix linearInequalityConstraintCMatrix, DMatrix linearInequalityConstraintDVector) {
        if (linearInequalityConstraintDVector.getNumCols() != 1) {
            throw new RuntimeException("linearInequalityConstraintDVector.getNumCols() != 1");
        }
        if (linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()");
        }
        if (linearInequalityConstraintCMatrix.getNumCols() != this.originalQuadraticCostQMatrix.getNumCols()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        this.originalLinearInequalityConstraintsDVectorO.set((Matrix)linearInequalityConstraintDVector);
        this.originalLinearInequalityConstraintsCMatrixO.set((Matrix)linearInequalityConstraintCMatrix);
    }

    @Override
    public void setActiveVariables(DMatrixRMaj activeVariables) {
        if (activeVariables.getNumRows() != this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("activeVariables.getNumRows() != quadraticCostQMatrix.getNumRows()");
        }
        this.activeVariables.set((DMatrixD1)activeVariables);
    }

    @Override
    public void setVariableActive(int variableIndex) {
        if (variableIndex < 0 || variableIndex >= this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variable index is outside the number of variables: " + variableIndex);
        }
        if (variableIndex >= this.activeVariables.getNumRows()) {
            return;
        }
        this.activeVariables.set(variableIndex, 0, 1.0);
    }

    @Override
    public void setVariableInactive(int variableIndex) {
        if (variableIndex < 0 || variableIndex >= this.originalQuadraticCostQMatrix.getNumRows()) {
            throw new RuntimeException("variable index is outside the number of variables: " + variableIndex);
        }
        if (variableIndex >= this.activeVariables.getNumRows()) {
            this.activeVariables.reshape(variableIndex + 1, 1, true);
        }
        this.activeVariables.set(variableIndex, 0, 0.0);
    }

    @Override
    public void setAllVariablesActive() {
        this.activeVariables.reshape(this.originalQuadraticCostQMatrix.getNumRows(), 1);
        CommonOps_DDRM.fill((DMatrixD1)this.activeVariables, (double)1.0);
    }

    @Override
    public void clear() {
        super.clear();
        this.originalQuadraticCostQMatrix.reshape(0, 0);
        this.originalQuadraticCostQVector.reshape(0, 0);
        this.originalLinearEqualityConstraintsAMatrix.reshape(0, 0);
        this.originalLinearEqualityConstraintsBVector.reshape(0, 0);
        this.originalLinearInequalityConstraintsCMatrixO.reshape(0, 0);
        this.originalLinearInequalityConstraintsDVectorO.reshape(0, 0);
        this.originalVariableLowerBounds.reshape(0, 0);
        this.originalVariableUpperBounds.reshape(0, 0);
        this.activeVariables.reshape(0, 0);
        this.activeVariableSolution.reshape(0, 0);
    }

    @Override
    public int solve(DMatrix solutionToPack) {
        this.removeInactiveVariables();
        this.activeVariableSolution.reshape(this.costQuadraticMatrix.getNumRows(), 1);
        if (solutionToPack.getNumRows() != this.originalQuadraticCostQMatrix.getNumRows() || solutionToPack.getNumCols() != 1) {
            throw new IllegalArgumentException("Invalid matrix dimensions.");
        }
        int numberOfIterations = super.solve((DMatrix)this.activeVariableSolution);
        this.copyActiveVariableSolutionToAllVariables(solutionToPack, this.activeVariableSolution);
        return numberOfIterations;
    }
}

